/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.classification;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import de.jungblut.classification.AbstractPredictor;
import de.jungblut.classification.Classifier;
import de.jungblut.math.DoubleVector;
import java.util.Arrays;

public abstract class AbstractClassifier
extends AbstractPredictor
implements Classifier {
    @Override
    public void train(DoubleVector[] features, DoubleVector[] outcome) {
        Preconditions.checkArgument((features.length > 0 ? 1 : 0) != 0, (Object)"Features must contain at least a single item!");
        Preconditions.checkArgument((features.length == outcome.length ? 1 : 0) != 0, (Object)"There must be an equal amount of features and prediction outcomes!");
        this.train(Arrays.asList(features), Arrays.asList(outcome));
    }

    @Override
    public void train(Iterable<DoubleVector> features, Iterable<DoubleVector> outcome) {
        this.train((DoubleVector[])Iterables.toArray(features, DoubleVector.class), (DoubleVector[])Iterables.toArray(outcome, DoubleVector.class));
    }
}

