/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.entitytagger.networking;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.documentparser.input.TextFile;
import uk.ac.man.entitytagger.Mention;
import uk.ac.man.entitytagger.doc.TaggedDocument;
import uk.ac.man.entitytagger.matching.MatchOperations;
import uk.ac.man.entitytagger.matching.Matcher;

public class AlibabaWorker
implements Runnable {
    private Socket s;
    private Matcher matcher;
    private Logger logger;
    private int privid;
    private File pmcBaseDir;
    private File medlineBaseDir;
    private static int id = 0;

    public AlibabaWorker(Socket s, Matcher matcher, Logger logger, File pmcBaseDir, File medlineBaseDir) {
        this.s = s;
        this.matcher = matcher;
        this.logger = logger;
        this.privid = id++;
        this.pmcBaseDir = pmcBaseDir;
        this.medlineBaseDir = medlineBaseDir;
    }

    @Override
    public void run() {
        try {
            BufferedReader inStream = new BufferedReader(new InputStreamReader(this.s.getInputStream()));
            BufferedWriter outStream = new BufferedWriter(new OutputStreamWriter(this.s.getOutputStream()));
            int i = 0;
            while (!inStream.ready() && i++ < 20) {
                Thread.sleep(50L);
            }
            String response = null;
            while (inStream.ready() && response == null) {
                String input = inStream.readLine();
                if (input.contains("type=text")) {
                    response = this.runText(input);
                    continue;
                }
                if (!input.contains("type=pmid")) continue;
                response = this.runPMID(input);
            }
            if (response == null) {
                this.logger.info("%t: Worker[" + this.privid + "]: did not receive any request, disconnecting.\n");
                this.s.close();
            } else {
                outStream.write("HTTP/1.1 200 OK\r\n");
                outStream.write("Server: LINNAEUS\r\n");
                outStream.write("Content-Length: " + response.getBytes().length + "\r\n");
                outStream.write("Date: Tue 01 Sep 2009 13:00:00 GMT\r\n\r\n");
                outStream.write(response);
                outStream.flush();
                this.s.close();
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private String runPMID(String input) {
        int s = input.indexOf("&query=") + 7;
        int e = input.indexOf(" ", s);
        if (s == 6 || e == -1) {
            throw new IllegalStateException("Invalid PMID request: " + input);
        }
        String id = input.substring(s, e);
        String first = ("0000" + id).substring(id.length() + 4 - 2, id.length() + 4);
        String second = ("0000" + id).substring(id.length() + 4 - 4, id.length() + 4 - 2);
        File file = id.startsWith("000000") ? new File(new File(this.pmcBaseDir, first), String.valueOf(id) + ".txt") : new File(new File(new File(this.medlineBaseDir, first), second), String.valueOf(id) + ".txt");
        Document doc = new TextFile(new File[]{file}).next();
        TaggedDocument tdoc = MatchOperations.matchDocument(this.matcher, doc);
        ArrayList<Mention> matches = tdoc.getAllMatches();
        String text = tdoc.getOriginal().toString();
        text = this.check(text, matches);
        String res = TaggedDocument.toHTML(text, matches, TaggedDocument.Format.Alibaba, true, null).toString();
        return res;
    }

    private String check(String text, List<Mention> matches) {
        if (matches.size() == 0) {
            matches.add(new Mention(new String[]{"species:ncbi:9606"}, 0, 1, ""));
            matches.add(new Mention(new String[]{"species:ncbi:10090"}, 1, 2, ""));
            if (text.length() < 2) {
                text = "..";
            }
        }
        for (Mention m : matches) {
            if (m.getEnd() <= text.length()) continue;
            System.err.println("'" + text + "'");
            System.err.println(m.toString());
            throw new IllegalStateException("Found match with end coordinate > text length");
        }
        return text;
    }

    /*
     * Unable to fully structure code
     */
    private String runText(String input) {
        s = input.indexOf("&query=") + 7;
        e = input.indexOf(" HTTP");
        if (s == 6 || e == -1) {
            return null;
        }
        text = input.substring(s, e);
        text = text.replaceAll("%20", " ");
        matches = this.matcher.match(text);
        text = this.check(text, matches);
        try {
            res = TaggedDocument.toHTML(text, matches, TaggedDocument.Format.Alibaba, true, null).toString();
            return res;
        }
        catch (Exception ex) {
            System.err.println("Error detected: " + ex);
            System.err.println("Text: " + text);
            ** for (m : matches)
        }
lbl-1000:
        // 1 sources

        {
            System.err.println(m.toString());
            continue;
        }
lbl18:
        // 1 sources

        ex.printStackTrace();
        return null;
    }
}

