/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.entitytagger.matching.matchers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import martin.common.CacheMap;
import martin.common.Function;
import martin.common.Misc;
import martin.common.Pair;
import martin.common.Sizeable;
import martin.common.StreamIterator;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.entitytagger.Mention;
import uk.ac.man.entitytagger.matching.Matcher;

public class VariantDictionaryMatcher
extends Matcher
implements Sizeable {
    private String[] terms = null;
    private String[][] termToIdsMap = null;
    private Connection conn;
    private String[] tableNames;
    private String tag;
    private final Pattern tokenizationPattern = Pattern.compile("\\b");
    private boolean ignoreCase;
    private long size = -1L;

    public VariantDictionaryMatcher(String[][] termToIdsMap, String[] terms, boolean ignoreCase) {
        this.termToIdsMap = termToIdsMap;
        this.terms = terms;
        this.ignoreCase = ignoreCase;
    }

    @Override
    public int size() {
        return this.terms.length;
    }

    public VariantDictionaryMatcher(Connection conn, String[] tableNames, String tag, boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.conn = conn;
        this.tableNames = tableNames;
        this.tag = tag;
    }

    public static VariantDictionaryMatcher load(File inFile, boolean ignoreCase) {
        try {
            return VariantDictionaryMatcher.load(new FileInputStream(inFile), ignoreCase);
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not find file " + inFile.getAbsolutePath() + ".");
            System.exit(0);
            return null;
        }
    }

    public static VariantDictionaryMatcher load(InputStream stream, boolean ignoreCase) {
        Map<String, Set<String>> termToIdsMap = VariantDictionaryMatcher.loadStream(stream, ignoreCase);
        Object[] terms = new String[termToIdsMap.size()];
        int i = 0;
        for (String term : termToIdsMap.keySet()) {
            terms[i++] = term;
        }
        Arrays.sort(terms);
        String[][] termToIdsMapArray = new String[terms.length][];
        int j = 0;
        while (j < terms.length) {
            termToIdsMapArray[j] = termToIdsMap.get(terms[j]).toArray(new String[0]);
            ++j;
        }
        return new VariantDictionaryMatcher(termToIdsMapArray, (String[])terms, ignoreCase);
    }

    private void init() {
        Map<String, Set<String>> termToIdsMap = this.loadFromDB();
        Object[] terms = new String[termToIdsMap.size()];
        int i = 0;
        for (String term : termToIdsMap.keySet()) {
            terms[i++] = term;
        }
        Arrays.sort(terms);
        String[][] termToIdsMapArray = new String[terms.length][];
        int j = 0;
        while (j < terms.length) {
            termToIdsMapArray[j] = termToIdsMap.get(terms[j]).toArray(new String[0]);
            ++j;
        }
        this.termToIdsMap = termToIdsMapArray;
        this.terms = terms;
    }

    public static Map<String, Matcher> loadSeparatedFromDB(Connection conn, String[] tableNames, boolean ignoreCase) {
        try {
            Statement stmt = conn.createStatement();
            HashMap<String, Matcher> res = new HashMap<String, Matcher>();
            String[] stringArray = tableNames;
            int n = tableNames.length;
            int n2 = 0;
            while (n2 < n) {
                String tableName = stringArray[n2];
                ResultSet rs = stmt.executeQuery("SELECT DISTINCT(tag) FROM " + tableName);
                while (rs.next()) {
                    String tag = rs.getString(1);
                    if (res.containsKey(tag)) continue;
                    res.put(tag, new VariantDictionaryMatcher(conn, tableNames, tag, ignoreCase));
                }
                ++n2;
            }
            conn.close();
            return res;
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public static CacheMap<String, VariantDictionaryMatcher> loadSeparatedFromDBCached(final Connection conn, final String[] tableNames, final boolean ignoreCase, long maxSize, Logger logger) {
        Function<VariantDictionaryMatcher> factory = new Function<VariantDictionaryMatcher>(){

            @Override
            public VariantDictionaryMatcher function(Object[] args) {
                String key = (String)args[0];
                return new VariantDictionaryMatcher(conn, tableNames, key, ignoreCase);
            }
        };
        return new CacheMap<String, VariantDictionaryMatcher>(maxSize, factory, logger);
    }

    public static Map<String, Matcher> loadSeparated(File[] inFiles, boolean ignoreCase) {
        HashMap<String, Matcher> res = new HashMap<String, Matcher>();
        File[] fileArray = inFiles;
        int n = inFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File inFile = fileArray[n2];
            Map<String, Map<String, Set<String>>> termToIdsMapSeparated = VariantDictionaryMatcher.loadFileSeparated(inFile, ignoreCase);
            for (String k : termToIdsMapSeparated.keySet()) {
                Map<String, Set<String>> termToIdsMap = termToIdsMapSeparated.get(k);
                Object[] terms = new String[termToIdsMap.size()];
                int i = 0;
                for (String term : termToIdsMap.keySet()) {
                    terms[i++] = term;
                }
                Arrays.sort(terms);
                String[][] termToIdsMapArray = new String[terms.length][];
                int j = 0;
                while (j < terms.length) {
                    termToIdsMapArray[j] = termToIdsMap.get(terms[j]).toArray(new String[0]);
                    ++j;
                }
                res.put(k, new VariantDictionaryMatcher(termToIdsMapArray, (String[])terms, ignoreCase));
            }
            ++n2;
        }
        return res;
    }

    private static Map<String, Map<String, Set<String>>> loadFileSeparated(File inFile, boolean ignoreCase) {
        HashMap<String, Map<String, Set<String>>> res = new HashMap<String, Map<String, Set<String>>>();
        StreamIterator fileData = new StreamIterator(inFile, true);
        for (String s : fileData) {
            String[] names;
            String[] fields = s.split("\t");
            if (fields.length < 3) {
                throw new IllegalStateException("The input file need three columns when calling loadFileSeparated");
            }
            if (ignoreCase) {
                fields[1] = fields[1].toLowerCase();
            }
            if (!res.containsKey(fields[2])) {
                res.put(fields[2], new HashMap());
            }
            Map map = (Map)res.get(fields[2]);
            String[] stringArray = names = fields[1].split("\\|");
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String n3 = stringArray[n2];
                if (!res.containsKey(n3)) {
                    map.put(n3, new HashSet());
                }
                ((Set)map.get(n3)).add(fields[0]);
                ++n2;
            }
        }
        return res;
    }

    private static Map<String, Set<String>> loadStream(InputStream inputStream, boolean ignoreCase) {
        HashMap<String, Set<String>> res = new HashMap<String, Set<String>>();
        StreamIterator fileData = new StreamIterator(inputStream, true);
        boolean c = false;
        Pattern tabPattern = Pattern.compile("\t");
        Pattern pipePattern = Pattern.compile("\\|");
        for (String s : fileData) {
            String[] names;
            String[] fields = tabPattern.split(s);
            if (ignoreCase) {
                fields[1] = fields[1].toLowerCase();
            }
            String[] stringArray = names = pipePattern.split(fields[1]);
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String n3 = stringArray[n2];
                if (!res.containsKey(n3)) {
                    res.put(n3, new HashSet());
                }
                ((Set)res.get(n3)).add(fields[0]);
                ++n2;
            }
        }
        return res;
    }

    private Map<String, Set<String>> loadFromDB() {
        try {
            if (this.tag != null) {
                System.out.println("Loading variantMatcher from " + Misc.implode(this.tableNames, ", ") + " (" + this.tag + ")... ");
            } else {
                System.out.println("Loading variantMatcher from " + Misc.implode(this.tableNames, ", ") + "... ");
            }
            HashMap<String, Set<String>> res = new HashMap<String, Set<String>>();
            String[] stringArray = this.tableNames;
            int n = this.tableNames.length;
            int n2 = 0;
            while (n2 < n) {
                String tableName = stringArray[n2];
                ResultSet rs = this.tag != null ? this.conn.createStatement().executeQuery("SELECT id_entity, name FROM " + tableName + " WHERE tag = '" + this.tag + "'") : this.conn.createStatement().executeQuery("SELECT id_entity, name FROM " + tableName);
                while (rs.next()) {
                    String id = rs.getString(1);
                    String name = rs.getString(2);
                    if (this.ignoreCase) {
                        name = name.toLowerCase();
                    }
                    if (!res.containsKey(name)) {
                        res.put(name, new HashSet());
                    }
                    ((Set)res.get(name)).add(id);
                }
                ++n2;
            }
            return res;
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    @Override
    public List<Mention> match(String text, Document doc) {
        if (this.terms == null || this.termToIdsMap == null) {
            this.init();
        }
        ArrayList<Mention> matches = new ArrayList<Mention>();
        String matchText = this.ignoreCase ? text.toLowerCase() : text;
        String docid = doc != null ? doc.getID() : null;
        java.util.regex.Matcher splitter = this.tokenizationPattern.matcher(matchText);
        ArrayList<Pair<Integer>> tokenLocations = new ArrayList<Pair<Integer>>();
        int prev = -1;
        while (splitter.find()) {
            if (prev != -1 && Character.isLetterOrDigit(matchText.charAt(prev))) {
                tokenLocations.add(new Pair<Integer>(prev, splitter.start()));
            }
            prev = splitter.start();
        }
        int i = 0;
        while (i < tokenLocations.size()) {
            Pair p = (Pair)tokenLocations.get(i);
            List<Integer> foundMatches = this.getMatchIds(tokenLocations, i, matchText);
            for (int fm : foundMatches) {
                String term = this.ignoreCase ? text.substring((Integer)p.getX(), (Integer)p.getX() + this.terms[fm].length()) : this.terms[fm];
                Mention m = new Mention((String[])this.termToIdsMap[fm].clone(), (int)((Integer)p.getX()), (Integer)p.getX() + term.length(), term);
                m.setDocid(docid);
                matches.add(m);
            }
            ++i;
        }
        return matches;
    }

    private List<Integer> getMatchIds(List<Pair<Integer>> tokenLocations, int i, String matchText) {
        Pair<Integer> p = tokenLocations.get(i);
        LinkedList<Integer> res = new LinkedList<Integer>();
        int add = 0;
        do {
            String term;
            int s;
            if ((s = Arrays.binarySearch(this.terms, term = matchText.substring(p.getX(), tokenLocations.get(i + add).getY()))) >= 0) {
                res.add(s);
                continue;
            }
            if (-s - 1 >= this.terms.length || !this.terms[-s - 1].startsWith(term)) break;
        } while (i + ++add < tokenLocations.size());
        return res;
    }

    @Override
    public long sizeof() {
        if (this.terms == null || this.termToIdsMap == null) {
            this.init();
        }
        if (this.size != -1L) {
            return this.size;
        }
        long size = 0L;
        String[] stringArray = this.terms;
        int n = this.terms.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            size += (long)(t.length() * 2);
            ++n2;
        }
        int i = 0;
        while (i < this.termToIdsMap.length) {
            int j = 0;
            while (j < this.termToIdsMap[i].length) {
                size += (long)(this.termToIdsMap[i][j].length() * 2);
                ++j;
            }
            ++i;
        }
        this.size = size;
        return size;
    }
}

