/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.entitytagger.matching.matchers;

import java.util.ArrayList;
import java.util.List;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.entitytagger.Mention;
import uk.ac.man.entitytagger.doc.TaggedDocument;
import uk.ac.man.entitytagger.matching.Matcher;

public class UnionMatcher
extends Matcher {
    private List<Matcher> matchers;
    private boolean equalMatchers;

    public UnionMatcher(List<Matcher> matchers, boolean equalMatchers) {
        this.matchers = matchers;
        this.equalMatchers = equalMatchers;
    }

    @Override
    public List<Mention> match(String text, Document doc) {
        ArrayList<Mention> matches = new ArrayList<Mention>();
        for (Matcher m : this.matchers) {
            List<Mention> localMatches = m.match(text, doc);
            int matcheslength = matches.size();
            int j = 0;
            while (j < localMatches.size()) {
                boolean overlapping = false;
                if (!this.equalMatchers) {
                    int k = 0;
                    while (k < matcheslength) {
                        if (localMatches.get(j).overlaps((Mention)matches.get(k))) {
                            overlapping = true;
                            break;
                        }
                        ++k;
                    }
                }
                if (!overlapping) {
                    matches.add(localMatches.get(j));
                }
                ++j;
            }
        }
        return matches;
    }

    public TaggedDocument matchDocument(Document doc) {
        String text = doc.toString();
        List<Mention> matches = this.match(text, doc);
        return new TaggedDocument(doc, null, null, matches, text.toString());
    }

    @Override
    public int size() {
        return this.matchers.size();
    }
}

