/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.entitytagger.matching.matchers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.entitytagger.Mention;
import uk.ac.man.entitytagger.matching.Matcher;

public class RegexpMatcher
extends Matcher {
    private Map<String, Pattern> hashmap;

    public RegexpMatcher(Map<String, Pattern> hashmap) {
        this.hashmap = hashmap;
    }

    @Override
    public List<Mention> match(String text, Document doc) {
        ArrayList<Mention> matches = new ArrayList<Mention>();
        for (String key : this.hashmap.keySet()) {
            java.util.regex.Matcher m = this.hashmap.get(key).matcher(text);
            while (m.find()) {
                Mention match = new Mention(new String[]{key}, m.start(), m.end(), text.substring(m.start(), m.end()));
                if (doc != null) {
                    match.setDocid(doc.getID());
                }
                if (!Matcher.isValidMatch(text, match) || doc != null && !doc.isValid(m.start(), m.end())) continue;
                matches.add(match);
            }
        }
        return matches;
    }

    @Override
    public int size() {
        return this.hashmap.size();
    }
}

