/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.entitytagger.matching.matchers;

import java.io.File;
import java.util.List;
import java.util.Map;
import martin.common.Misc;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.entitytagger.Mention;
import uk.ac.man.entitytagger.matching.Matcher;
import uk.ac.man.entitytagger.matching.Postprocessor;

public class MatchPostProcessor
extends Matcher {
    private Matcher matcher;
    private Matcher.Disambiguation mode;
    private boolean abbrevResolution;
    private Postprocessor postProcessor;
    private Map<String, String> mapConvertIDs;

    public MatchPostProcessor(Matcher matcher, Matcher.Disambiguation mode, boolean abbrevResolution, File ppConvertIDs, Postprocessor postProcessor) {
        this.matcher = matcher;
        this.mode = mode;
        this.abbrevResolution = abbrevResolution;
        this.postProcessor = postProcessor;
        this.mapConvertIDs = Misc.loadMap(ppConvertIDs);
    }

    @Override
    public List<Mention> match(String text, Document doc) {
        List<Object> mentions = this.matcher.match(text, doc);
        if (doc == null) {
            for (Mention mention : mentions) {
                mention.setDocid("none");
            }
        }
        mentions = Matcher.combineMatches(mentions);
        mentions = Matcher.disambiguate(text, mentions, this.mode);
        if (this.mapConvertIDs != null) {
            this.convertIDs(mentions, this.mapConvertIDs);
        }
        if (this.abbrevResolution) {
            Matcher.performAcronymResolution(doc, text, mentions);
        }
        if (this.postProcessor != null) {
            mentions = this.postProcessor.postProcess((List<Mention>)mentions, text);
        }
        mentions = Misc.sort(mentions);
        Matcher.detectEnumerations((List<Mention>)mentions, text);
        if (doc == null) {
            for (Mention mention : mentions) {
                mention.setDocid(null);
            }
        }
        return mentions;
    }

    /*
     * Unable to fully structure code
     */
    private void convertIDs(List<Mention> mentions, Map<String, String> mapConvertIDs2) {
        for (Mention m : mentions) {
            ids = m.getIds();
            i = 0;
            ** GOTO lbl9
            {
                ids[i] = mapConvertIDs2.get(ids[i]);
                do {
                    if (mapConvertIDs2.containsKey(ids[i])) continue block1;
                    ++i;
lbl9:
                    // 2 sources

                } while (i < ids.length);
            }
        }
    }
}

