/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.entitytagger.matching;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import uk.ac.man.entitytagger.Mention;

public class Postprocessor {
    private Map<String, List<Pattern>> stopTerms;
    private Map<String, HashMap<String, Double>> acronymProbabilities;
    private Map<String, Integer> entityFrequencies;
    protected Map<String, String> comments;

    public Postprocessor(File[] stopTermFile, File[] acronymProbFile, File[] entityFrequencyFile, Map<String, String> comments, Logger logger) {
        if (logger != null) {
            logger.info("Loading postprocessing data files... ");
        }
        this.comments = comments;
        this.stopTerms = stopTermFile != null ? this.loadStopTerms(stopTermFile) : null;
        this.acronymProbabilities = acronymProbFile != null ? this.loadAcronymProbabilities(acronymProbFile) : null;
        Map<String, Integer> map = this.entityFrequencies = entityFrequencyFile != null ? this.loadEntityFrequencies(entityFrequencyFile) : null;
        if (logger != null) {
            logger.info(" done (s: " + (this.stopTerms != null ? this.stopTerms.size() : 0) + ", a: " + (this.acronymProbabilities != null ? this.acronymProbabilities.size() : 0) + ", f: " + (this.entityFrequencies != null ? this.entityFrequencies.size() : 0) + ", c: " + (comments != null ? comments.size() : 0) + ").\n");
        }
    }

    public Postprocessor(InputStream[] stopTermStreams, InputStream[] acronymProbStreams, InputStream[] entityFrequencyStreams, Map<String, String> comments, Logger logger) {
        if (logger != null) {
            logger.info("Loading postprocessing data files... ");
        }
        this.comments = comments;
        this.stopTerms = stopTermStreams != null ? this.loadStopTerms(stopTermStreams) : null;
        this.acronymProbabilities = acronymProbStreams != null ? this.loadAcronymProbabilities(acronymProbStreams) : null;
        Map<String, Integer> map = this.entityFrequencies = entityFrequencyStreams != null ? this.loadEntityFrequencies(entityFrequencyStreams) : null;
        if (logger != null) {
            logger.info(" done (s: " + (this.stopTerms != null ? this.stopTerms.size() : 0) + ", a: " + (this.acronymProbabilities != null ? this.acronymProbabilities.size() : 0) + ", f: " + (this.entityFrequencies != null ? this.entityFrequencies.size() : 0) + ", c: " + (comments != null ? comments.size() : 0) + ").\n");
        }
    }

    private Map<String, Integer> loadEntityFrequencies(File[] entityFreqFiles) {
        try {
            InputStream[] streams = new InputStream[entityFreqFiles.length];
            int i = 0;
            while (i < streams.length) {
                streams[i] = new FileInputStream(entityFreqFiles[i]);
                ++i;
            }
            Map<String, Integer> res = this.loadEntityFrequencies(streams);
            int i2 = 0;
            while (i2 < streams.length) {
                streams[i2].close();
                ++i2;
            }
            return res;
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    private Map<String, Integer> loadEntityFrequencies(InputStream[] entityFrequencyStreams) {
        if (entityFrequencyStreams == null || entityFrequencyStreams.length == 0) {
            return null;
        }
        HashMap<String, Integer> retres = new HashMap<String, Integer>();
        try {
            InputStream[] inputStreamArray = entityFrequencyStreams;
            int n = entityFrequencyStreams.length;
            int n2 = 0;
            while (n2 < n) {
                InputStream entityFrequencyFile = inputStreamArray[n2];
                BufferedReader inStream = new BufferedReader(new InputStreamReader(entityFrequencyFile));
                String line = inStream.readLine();
                while (line != null) {
                    if (!line.startsWith("#")) {
                        String[] fields = line.split("\\t");
                        retres.put(fields[0], Integer.parseInt(fields[1]));
                    }
                    line = inStream.readLine();
                }
                inStream.close();
                ++n2;
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
        return retres;
    }

    private HashMap<String, HashMap<String, Double>> loadAcronymProbabilities(File[] acronymProbFiles) {
        try {
            InputStream[] streams = new InputStream[acronymProbFiles.length];
            int i = 0;
            while (i < streams.length) {
                streams[i] = new FileInputStream(acronymProbFiles[i]);
                ++i;
            }
            HashMap<String, HashMap<String, Double>> res = this.loadAcronymProbabilities(streams);
            int i2 = 0;
            while (i2 < streams.length) {
                streams[i2].close();
                ++i2;
            }
            return res;
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    private HashMap<String, HashMap<String, Double>> loadAcronymProbabilities(InputStream[] acronymProbStreams) {
        if (acronymProbStreams == null || acronymProbStreams.length == 0) {
            return null;
        }
        HashMap<String, HashMap<String, Double>> retres = new HashMap<String, HashMap<String, Double>>();
        try {
            InputStream[] inputStreamArray = acronymProbStreams;
            int n = acronymProbStreams.length;
            int n2 = 0;
            while (n2 < n) {
                InputStream acronymProbFile = inputStreamArray[n2];
                BufferedReader inStream = new BufferedReader(new InputStreamReader(acronymProbFile));
                String line = inStream.readLine();
                while (line != null) {
                    if (!line.startsWith("#")) {
                        String[] fields = line.split("\\t");
                        double d = Double.parseDouble(fields[2]);
                        if (!retres.containsKey(fields[0])) {
                            retres.put(fields[0], new HashMap());
                        }
                        retres.get(fields[0]).put(fields[1], d);
                    }
                    line = inStream.readLine();
                }
                inStream.close();
                ++n2;
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
        return retres;
    }

    private HashMap<String, List<Pattern>> loadStopTerms(File[] entityFreqFiles) {
        try {
            InputStream[] streams = new InputStream[entityFreqFiles.length];
            int i = 0;
            while (i < streams.length) {
                streams[i] = new FileInputStream(entityFreqFiles[i]);
                ++i;
            }
            HashMap<String, List<Pattern>> res = this.loadStopTerms(streams);
            int i2 = 0;
            while (i2 < streams.length) {
                streams[i2].close();
                ++i2;
            }
            return res;
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    private HashMap<String, List<Pattern>> loadStopTerms(InputStream[] stopTermStreams) {
        if (stopTermStreams == null || stopTermStreams.length == 0) {
            return null;
        }
        HashMap<String, List<Pattern>> retres = new HashMap<String, List<Pattern>>();
        try {
            InputStream[] inputStreamArray = stopTermStreams;
            int n = stopTermStreams.length;
            int n2 = 0;
            while (n2 < n) {
                InputStream stopTermFile = inputStreamArray[n2];
                BufferedReader inStream = new BufferedReader(new InputStreamReader(stopTermFile));
                String line = inStream.readLine();
                while (line != null) {
                    if (!line.startsWith("#") && line.length() > 0) {
                        String[] fields = line.split("\\t");
                        String id = fields[0];
                        if (!retres.containsKey(id)) {
                            retres.put(id, new ArrayList());
                        }
                        if (fields.length > 1) {
                            retres.get(fields[0]).add(Pattern.compile("^" + fields[1] + "$"));
                        } else {
                            System.err.println("Stop-term line \"" + line + "\" does not contain enough fields.");
                            System.exit(-1);
                        }
                    }
                    line = inStream.readLine();
                }
                inStream.close();
                ++n2;
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
        return retres;
    }

    public List<Mention> postProcess(List<Mention> matches, String text) {
        List<Mention> retres = this.filterByStopTerms(matches);
        if (this.comments != null) {
            this.comment(retres, this.comments);
        }
        this.removeLineNumbers(matches);
        this.setProbs(retres);
        return retres;
    }

    private void removeLineNumbers(List<Mention> matches) {
        for (Mention m : matches) {
            String[] ids = m.getIds();
            HashSet<String> idSet = new HashSet<String>();
            int i = 0;
            while (i < ids.length) {
                String[] fields = ids[i].split("\\|");
                idSet.add(fields[0]);
                ++i;
            }
            m.setIds(idSet.toArray(new String[0]));
        }
    }

    public void comment(List<Mention> matches, Map<String, String> comments2) {
        if (comments2 == null) {
            return;
        }
        for (Mention m : matches) {
            String id = m.getMostProbableIDWithIdLine();
            if (!comments2.containsKey(id)) continue;
            String c = m.getComment();
            c = c == null || c.length() == 0 ? comments2.get(id) : String.valueOf(c) + ", " + comments2.get(id);
            m.setComment(c);
        }
    }

    public void setProbs(List<Mention> matches) {
        if (this.entityFrequencies == null && this.acronymProbabilities == null) {
            return;
        }
        for (Mention m : matches) {
            String[] ids = m.getIds();
            String term = m.getText();
            Double[] probabilities = new Double[ids.length];
            int freqSum = 0;
            if (ids.length > 1) {
                String[] stringArray = ids;
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (this.entityFrequencies != null && this.entityFrequencies.containsKey(s)) {
                        freqSum += this.entityFrequencies.get(s).intValue();
                    }
                    ++n2;
                }
            }
            int i = 0;
            while (i < ids.length) {
                String s = ids[i];
                if (this.acronymProbabilities != null && this.acronymProbabilities.containsKey(s) && this.acronymProbabilities.get(s).containsKey(term)) {
                    probabilities[i] = this.acronymProbabilities.get(s).get(term);
                } else if (this.entityFrequencies != null && ids.length > 1 && this.entityFrequencies.containsKey(s)) {
                    probabilities[i] = (double)this.entityFrequencies.get(s).intValue() / (double)freqSum;
                }
                ++i;
            }
            m.setProbabilities(probabilities);
            m.sortIDsByProbabilities();
        }
    }

    private List<Mention> filterByStopTerms(List<Mention> matches) {
        ArrayList<Mention> retres = new ArrayList<Mention>(matches.size());
        List<Pattern> generalPatterns = this.stopTerms != null && this.stopTerms.containsKey("*") ? this.stopTerms.get("*") : null;
        for (Mention m : matches) {
            String[] ids = m.getIds();
            String term = m.getText();
            boolean remove = false;
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (this.stopTerms != null && this.stopTerms.containsKey(s)) {
                    List<Pattern> patterns = this.stopTerms.get(s);
                    for (Pattern p : patterns) {
                        if (!p.matcher(term).matches()) continue;
                        remove = true;
                        break;
                    }
                }
                if (generalPatterns != null) {
                    for (Pattern p : generalPatterns) {
                        if (!p.matcher(term).matches()) continue;
                        remove = true;
                        break;
                    }
                }
                if (remove) break;
                ++n2;
            }
            if (remove) continue;
            retres.add(m);
        }
        return retres;
    }
}

