/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.entitytagger.matching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import martin.common.Tuple;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.entitytagger.Mention;

public abstract class Matcher {
    public abstract List<Mention> match(String var1, Document var2);

    public int size() {
        throw new IllegalStateException("Matcher.size() is not implemented");
    }

    protected static boolean isValidMatch(String text, Mention match) {
        char c;
        int s = match.getStart();
        int e = match.getEnd();
        if (s > 0 && Character.isLetterOrDigit(c = text.charAt(s - 1)) && c != '>' && c != '<') {
            return false;
        }
        return e >= text.length() - 1 || !Character.isLetterOrDigit(c = text.charAt(e)) || c == '>' || c == '<';
    }

    public static List<Mention> disambiguate(String text, List<Mention> matches, Disambiguation mode) {
        Mention m2;
        if (mode == Disambiguation.OFF || matches == null || matches.size() == 0) {
            return matches;
        }
        ArrayList<Mention> res = new ArrayList<Mention>(matches);
        int i = 0;
        while (i < res.size()) {
            Mention m1 = (Mention)res.get(i);
            int s1 = m1.getStart();
            int e1 = m1.getEnd();
            int j = i + 1;
            while (j < res.size()) {
                m2 = (Mention)res.get(j);
                int s2 = m2.getStart();
                int e2 = m2.getEnd();
                if (Mention.overlaps(m1, m2)) {
                    if (e2 - s2 < e1 - s1) {
                        res.remove(j);
                        --j;
                    } else if (e1 - s1 < e2 - s2) {
                        res.remove(i);
                        --i;
                        break;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (mode == Disambiguation.ON_LONGEST_ONLY || matches.size() > 2000) {
            return res;
        }
        boolean[] isClear = new boolean[res.size()];
        int i2 = 0;
        while (i2 < isClear.length) {
            isClear[i2] = !((Mention)res.get(i2)).isAmbigous();
            ++i2;
        }
        i2 = 0;
        while (i2 < isClear.length) {
            Mention m1 = (Mention)res.get(i2);
            int j = i2 + 1;
            while (j < res.size()) {
                Mention m22 = (Mention)res.get(j);
                if (Mention.overlaps(m1, m22)) {
                    isClear[i2] = false;
                    isClear[j] = false;
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < res.size()) {
            Mention m1 = (Mention)res.get(i2);
            if (m1 != null && !isClear[i2]) {
                int s1 = m1.getStart();
                int j = 0;
                while (j < res.size()) {
                    m2 = (Mention)res.get(j);
                    if (m2 != null && (m2.getStart() < s1 || mode == Disambiguation.ON_WHOLE) && m2.getIds().length > 0 && m1.containsID(m2.getIds()[0]) && isClear[j]) {
                        isClear[i2] = true;
                        String id = m2.getIds()[0];
                        m1.disambiguate(id);
                        int k = 0;
                        while (k < res.size()) {
                            if (res.get(k) != null && Mention.overlaps(m1, (Mention)res.get(k)) && k != i2) {
                                res.set(k, null);
                            }
                            if (res.get(k) != null && mode == Disambiguation.ON_EARLIER && m1.getText().equals(((Mention)res.get(k)).getText()) && ((Mention)res.get(k)).containsID(id)) {
                                ((Mention)res.get(k)).disambiguate(id);
                                isClear[k] = true;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < res.size()) {
            if (res.get(i2) == null) {
                res.remove(i2--);
            }
            ++i2;
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Mention> combineMatches(List<Mention> matches) {
        ArrayList<Mention> res = new ArrayList<Mention>();
        boolean[] removed = new boolean[matches.size()];
        int i = 0;
        while (i < matches.size()) {
            if (!removed[i]) {
                void var12_18;
                Mention m1 = matches.get(i);
                ArrayList<Tuple<String, Double>> sp = new ArrayList<Tuple<String, Double>>();
                String[] ids_ = m1.getIdsWithLineNumbers();
                Double[] probs_ = m1.getProbabilities();
                int j = 0;
                while (j < ids_.length) {
                    double d = probs_ != null && probs_[j] != null ? probs_[j] : 0.0;
                    sp.add(new Tuple<String, Double>(ids_[j], d));
                    ++j;
                }
                j = i + 1;
                while (j < matches.size()) {
                    if (matches.get(j).getStart() == m1.getStart() && matches.get(j).getEnd() == m1.getEnd()) {
                        ids_ = matches.get(j).getIdsWithLineNumbers();
                        probs_ = matches.get(j).getProbabilities();
                        int k = 0;
                        while (k < ids_.length) {
                            double d = probs_ != null && probs_[k] != null ? probs_[k] : 0.0;
                            sp.add(new Tuple<String, Double>(ids_[k], d));
                            ++k;
                        }
                        removed[j] = true;
                    }
                    ++j;
                }
                String[] ids = new String[sp.size()];
                Double[] probs = new Double[sp.size()];
                double total = 0.0;
                for (Tuple tuple : sp) {
                    total += ((Double)tuple.getB()).doubleValue();
                }
                boolean bl = false;
                while (var12_18 < sp.size()) {
                    ids[var12_18] = (String)((Tuple)sp.get((int)var12_18)).getA();
                    probs[var12_18] = total > 0.0 ? (Double)((Tuple)sp.get((int)var12_18)).getB() / total : 0.0;
                    ++var12_18;
                }
                Mention mention = new Mention(ids, m1.getStart(), m1.getEnd(), m1.getText());
                mention.setDocid(m1.getDocid());
                mention.setComment(m1.getComment());
                mention.setProbabilities(probs);
                mention.sortIDsByProbabilities();
                res.add(mention);
            }
            ++i;
        }
        return res;
    }

    public List<Mention> match(String text) {
        return this.match(text, (Document)null);
    }

    public List<Mention> match(String text, String documentID) {
        if (documentID == null) {
            return this.match(text, (Document)null);
        }
        Document d = new Document(documentID, null, null, null, text, null, null, null, null, null, null, null, null, null, null);
        return this.match(text, d);
    }

    protected static void performAcronymResolution(Document doc, String text, List<Mention> matches) {
        HashMap<String, Mention> acronyms = new HashMap<String, Mention>();
        String regexp = "[ABCDEFGHIJKLMNOPQRSTUVWXYZ][ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789\\-\\.]+";
        String docID = doc != null ? doc.getID() : null;
        int i = 0;
        while (i < matches.size()) {
            String abb;
            int ncp;
            Mention m = matches.get(i);
            int s = m.getStart();
            int e = m.getEnd();
            if (s != -1 && e != -1 && e + 1 < text.length() && text.charAt(e) == ' ' && text.charAt(e + 1) == '(' && (ncp = text.indexOf(41, e + 2)) > -1 && ncp < text.length() && (abb = text.substring(e + 2, ncp)).matches(regexp) && abb.length() < 5) {
                Mention a = new Mention(m.getIds(), e + 2, ncp, abb);
                a.setComment("abbrev main (" + m.getText() + ")");
                a.setDocid(m.getDocid());
                boolean overlaps = false;
                int j = 0;
                while (j < matches.size()) {
                    if (matches.get(j).overlaps(a)) {
                        overlaps = true;
                    }
                    ++j;
                }
                if (!acronyms.containsKey(abb) && !overlaps) {
                    acronyms.put(abb, a);
                }
            }
            ++i;
        }
        for (Mention m : acronyms.values()) {
            Pattern p = Pattern.compile("\\b" + m.getText() + "\\b");
            java.util.regex.Matcher matcher = p.matcher(text);
            int numMatched = 0;
            while (matcher.find()) {
                int s = matcher.start();
                int e = matcher.end();
                if (s <= m.getEnd()) continue;
                Mention nm = new Mention(m.getIds(), s, e, text.substring(s, e));
                nm.setComment("abbrev sec");
                nm.setDocid(m.getDocid());
                boolean add = true;
                int i2 = 0;
                while (i2 < matches.size()) {
                    if (matches.get(i2).overlaps(nm)) {
                        add = false;
                        break;
                    }
                    ++i2;
                }
                if (!add) continue;
                nm.setDocid(docID);
                matches.add(nm);
                ++numMatched;
            }
            if (numMatched <= 0) continue;
            m.setDocid(docID);
            matches.add(m);
        }
    }

    public static void detectEnumerations(List<Mention> mentions, String text) {
        int nextGroup = 0;
        Mention.sort(mentions);
        HashMap<Integer, Integer> matchToGroupMap = new HashMap<Integer, Integer>();
        HashSet<Integer> validGroups = new HashSet<Integer>();
        Pattern cP = Pattern.compile("^[,/] ?$");
        Pattern aP = Pattern.compile("^,? and $");
        int i = 0;
        while (i < mentions.size() - 1) {
            Integer currentGroup;
            Mention m = mentions.get(i);
            Mention nm = mentions.get(i + 1);
            Integer n = currentGroup = matchToGroupMap.containsKey(i) ? (Integer)matchToGroupMap.get(i) : null;
            if (m.getEnd() < nm.getStart()) {
                String t = text.substring(m.getEnd(), nm.getStart());
                if (cP.matcher(t).matches()) {
                    if (currentGroup == null) {
                        currentGroup = nextGroup++;
                    }
                    matchToGroupMap.put(i, currentGroup);
                    matchToGroupMap.put(i + 1, currentGroup);
                    validGroups.add(currentGroup);
                }
                if (aP.matcher(t).matches()) {
                    if (currentGroup == null) {
                        currentGroup = nextGroup++;
                    }
                    matchToGroupMap.put(i, currentGroup);
                    matchToGroupMap.put(i + 1, currentGroup);
                    validGroups.add(currentGroup);
                }
            } else if (m.getStart() > nm.getEnd()) {
                throw new IllegalStateException("Mentions were not sorted!");
            }
            ++i;
        }
        Iterator iterator = matchToGroupMap.keySet().iterator();
        while (iterator.hasNext()) {
            int k = (Integer)iterator.next();
            mentions.get(k).setComment("group: " + matchToGroupMap.get(k) + ", valid: " + validGroups.contains(matchToGroupMap.get(k)));
        }
    }

    public List<Mention> match(Document d) {
        return this.match(d.toString(), d);
    }

    public static enum Disambiguation {
        OFF,
        ON_EARLIER,
        ON_WHOLE,
        ON_LONGEST_ONLY;

    }
}

