/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.entitytagger.generate;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicOperations;
import dk.brics.automaton.CustomRunAutomaton;
import dk.brics.automaton.RegExp;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import martin.common.Tuple;
import martin.common.compthreads.ArrayBasedMaster;
import martin.common.compthreads.IteratorBasedMaster;
import martin.common.compthreads.Problem;
import uk.ac.man.entitytagger.generate.DictionaryEntry;

class GenerateAutomatons {
    GenerateAutomatons() {
    }

    ArrayList<Automaton> process(ArrayList<Automaton> automatons, int multiJoin, boolean minimize, boolean showNumStates, int numThreads, Logger logger) {
        ArrayList<Automaton> res = new ArrayList<Automaton>();
        int numRuns = automatons.size() / multiJoin;
        int numStartStates = 0;
        int numEndStates = 0;
        if (numRuns * multiJoin < automatons.size()) {
            ++numRuns;
        }
        ProcessProblem[] problems = new ProcessProblem[numRuns];
        int i = 0;
        while (i < numRuns) {
            ArrayList<Automaton> temp = new ArrayList<Automaton>();
            int j = 0;
            while (j < multiJoin) {
                int index = i * multiJoin + j;
                if (index < automatons.size()) {
                    temp.add(automatons.get(index));
                    if (showNumStates) {
                        numStartStates += automatons.get(index).getNumberOfStates();
                    }
                }
                ++j;
            }
            problems[i] = new ProcessProblem(temp, minimize);
            ++i;
        }
        ArrayBasedMaster master = new ArrayBasedMaster(problems, numThreads);
        logger.info("%t: Processing automatons... ");
        new Thread(master).start();
        Object[] solutions = master.getSolutions();
        int i2 = 0;
        while (i2 < solutions.length) {
            Automaton a = (Automaton)solutions[i2];
            numEndStates += a.getNumberOfStates();
            res.add(a);
            ++i2;
        }
        logger.info("done. " + automatons.size() + " automatons (" + numStartStates + " states) -> " + res.size() + " (" + numEndStates + " states)\n");
        return res;
    }

    static CustomRunAutomaton[] loadRArray(File file, Logger logger) {
        CustomRunAutomaton[] r = null;
        try {
            ObjectInputStream inStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            int size = inStream.readInt();
            logger.info("%t: Loading runautomatons...");
            r = new CustomRunAutomaton[size];
            int i = 0;
            while (i < r.length) {
                r[i] = (CustomRunAutomaton)inStream.readObject();
                ++i;
            }
            logger.info(" done, loaded " + size + " automatons from file " + file.getAbsolutePath() + ".\n");
            inStream.close();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
        return r;
    }

    static void storeRArray(ArrayList<Automaton> list, boolean ignoreCase, boolean tableize, File file, Logger logger) {
        CustomRunAutomaton[] r = new CustomRunAutomaton[list.size()];
        logger.info("%t: Converting automatons to runautomatons (tableize = " + tableize + ")...");
        int i = 0;
        while (i < list.size()) {
            r[i] = new CustomRunAutomaton(list.get(i), tableize);
            ++i;
        }
        logger.info(" done.\n");
        try {
            logger.info("%t: Storing runautomatons...");
            ObjectOutputStream outStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            outStream.writeInt(list.size());
            outStream.writeBoolean(ignoreCase);
            int i2 = 0;
            while (i2 < r.length) {
                outStream.writeObject(r[i2]);
                ++i2;
            }
            outStream.close();
            logger.info(" done. Stored " + r.length + " runautomatons to file " + file.getAbsolutePath() + "\n");
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    ArrayList<Automaton> toAutomatons(ArrayList<DictionaryEntry> dictionaryEntries, int numThreads, Integer report, boolean ignoreCase, Logger logger) {
        logger.info("%t: Generating automatons, ignoreCase = " + ignoreCase + "...\n");
        ToAutomatonProblemIterator problems = new ToAutomatonProblemIterator(dictionaryEntries, ignoreCase);
        IteratorBasedMaster<Automaton> master = new IteratorBasedMaster<Automaton>(problems, numThreads);
        new Thread(master).start();
        int i = 0;
        ArrayList<Automaton> res = new ArrayList<Automaton>();
        while (master.hasNext()) {
            Automaton a = master.next();
            if (a != null) {
                res.add(a);
            }
            if (report == null || ++i % report != 0) continue;
            logger.info(String.valueOf(i) + " / " + dictionaryEntries.size() + "\n");
        }
        logger.info("%t: Automatons complete.\n");
        return res;
    }

    static Tuple<ArrayList<Automaton>, Boolean> loadArray(File file) {
        ArrayList<Automaton> l = new ArrayList<Automaton>();
        boolean ignoreCase = false;
        try {
            ObjectInputStream inStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            int size = inStream.readInt();
            ignoreCase = inStream.readBoolean();
            int i = 0;
            while (i < size) {
                l.add((Automaton)inStream.readObject());
                ++i;
            }
            inStream.close();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
        return new Tuple<ArrayList<Automaton>, Boolean>(l, ignoreCase);
    }

    static void storeArray(File file, ArrayList<Automaton> l, boolean ignoreCase) {
        try {
            ObjectOutputStream outStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            outStream.writeInt(l.size());
            outStream.writeBoolean(ignoreCase);
            int i = 0;
            while (i < l.size()) {
                outStream.writeObject(l.get(i));
                ++i;
            }
            outStream.close();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void storeVariants(File file, PreparedStatement pstmt, List<Automaton> automatons, Logger logger, int report) {
        try {
            BufferedWriter outStream = file != null ? new BufferedWriter(new FileWriter(file)) : null;
            Pattern splitter = Pattern.compile("\u25b2");
            int c = 0;
            logger.info("%t: Starting automaton conversion.\n");
            for (Automaton a : automatons) {
                Set<String> variants = a.getFiniteStrings();
                if (variants == null) {
                    throw new IllegalStateException("Non-finite automaton detected - this cannot be converted");
                }
                if (variants.size() == 0) {
                    System.err.println("0");
                }
                for (String v : variants) {
                    String[] parts = splitter.split(v);
                    if (parts.length != 2) {
                        throw new IllegalStateException("parts.length == " + parts.length);
                    }
                    if (outStream != null) {
                        outStream.write(String.valueOf(parts[1]) + "\t" + parts[0] + "\n");
                    }
                    if (pstmt == null) continue;
                    pstmt.setString(1, parts[1]);
                    pstmt.setString(2, parts[0]);
                    pstmt.setNull(3, 0);
                    pstmt.addBatch();
                }
                if (pstmt != null) {
                    pstmt.executeBatch();
                }
                if (report == -1 || ++c % report != 0) continue;
                logger.info("%t: Converted " + c + " automatons to variants.\n");
            }
            if (outStream != null) {
                outStream.close();
            }
            logger.info("%t: Completed.\n");
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private class ProcessProblem
    implements Problem<Automaton> {
        private ArrayList<Automaton> automatons;
        private boolean minimize;

        public ProcessProblem(ArrayList<Automaton> automatons, boolean minimize) {
            this.automatons = automatons;
            this.minimize = minimize;
        }

        @Override
        public Automaton compute() {
            Automaton res;
            if (this.automatons.size() > 1) {
                res = BasicOperations.union(this.automatons);
                res.setDeterministic(false);
            } else {
                res = this.automatons.get(0);
            }
            res.determinize();
            if (this.minimize) {
                res.minimize();
            }
            return res;
        }
    }

    private class ToAutomatonProblem
    implements Problem<Automaton> {
        private DictionaryEntry entry;
        private boolean lowercase;

        public ToAutomatonProblem(DictionaryEntry entry, boolean lowercase) {
            this.entry = entry;
            this.lowercase = lowercase;
        }

        @Override
        public Automaton compute() {
            String sr = "(" + this.entry.getRegexp() + ")";
            if (this.lowercase) {
                sr = sr.toLowerCase();
            }
            if (sr.contains("\u25b2")) {
                throw new IllegalStateException("The regular expression " + sr + " contains the CustomRunAutomaton.delimiter character. You need to change character.");
            }
            RegExp r = null;
            try {
                r = new RegExp(String.valueOf(sr) + '\u25b2' + this.entry.getId());
            }
            catch (Exception e) {
                System.err.println("Detected exception when creating regular expression: '" + sr + '\u25b2' + this.entry.getId() + "'");
                System.err.println(e);
                e.printStackTrace();
                System.exit(-1);
            }
            Automaton a = r.toAutomaton();
            String shortest = a.getShortestExample(true);
            if (shortest == null || shortest.equals(String.valueOf('\u25b2') + this.entry.getId())) {
                System.err.println("Warning: detected erroneous regexp for id " + this.entry.getId() + ", returning null automaton (regexp: '" + sr + "'");
                return null;
            }
            a.setDeterministic(false);
            a.determinize();
            return a;
        }
    }

    private class ToAutomatonProblemIterator
    implements Iterator<Problem<Automaton>> {
        private ArrayList<DictionaryEntry> dictionaryEntries;
        int currentItem = 0;
        private boolean lowercase;

        public ToAutomatonProblemIterator(ArrayList<DictionaryEntry> dictionaryEntries, boolean lowercase) {
            this.dictionaryEntries = dictionaryEntries;
            this.lowercase = lowercase;
        }

        @Override
        public boolean hasNext() {
            return this.currentItem < this.dictionaryEntries.size();
        }

        @Override
        public ToAutomatonProblem next() {
            return new ToAutomatonProblem(this.dictionaryEntries.get(this.currentItem++), this.lowercase);
        }

        @Override
        public void remove() {
            throw new IllegalStateException("not implemented");
        }
    }
}

