/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.entitytagger.generate;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import martin.common.Tuple;
import martin.common.compthreads.Problem;
import uk.ac.man.entitytagger.generate.DictionaryEntry;

public class ConvertToVariantsProblemIterator
implements Iterator<Problem<Tuple<DictionaryEntry, Set<String>>>> {
    private Iterator<DictionaryEntry> iterator;

    public ConvertToVariantsProblemIterator(HashMap<String, DictionaryEntry> dict) {
        this.iterator = dict.values().iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Problem<Tuple<DictionaryEntry, Set<String>>> next() {
        return new ConvertToVariantsProblem(this.iterator.next());
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    private class ConvertToVariantsProblem
    implements Problem<Tuple<DictionaryEntry, Set<String>>> {
        private DictionaryEntry de;

        public ConvertToVariantsProblem(DictionaryEntry de) {
            this.de = de;
        }

        @Override
        public Tuple<DictionaryEntry, Set<String>> compute() {
            Set<String> variants = this.de.convertRegexpToVariants();
            if (variants == null) {
                throw new IllegalStateException("Detected that regular expression '" + this.de.getRegexp() + "' is non-finite. Cannot convert this expression to variants.");
            }
            return new Tuple<DictionaryEntry, Set<String>>(this.de, variants);
        }
    }
}

