/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.entitytagger.entities.species;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashSet;
import java.util.Set;
import martin.common.ArgParser;
import martin.common.Misc;
import martin.common.StreamIterator;

public class CatalogueOfLife {
    public static void main(String[] args) {
        File out;
        ArgParser ap = new ArgParser(args);
        File inCommon = ap.getFile("inCommon");
        File inScientific = ap.getFile("inScientific");
        if (ap.containsKey("outRegexp")) {
            out = ap.getFile("outRegexp");
            CatalogueOfLife.process(inCommon, inScientific, out, ap.getRequired("idPrefix"), true);
        }
        if (ap.containsKey("outVariants")) {
            out = ap.getFile("outVariants");
            CatalogueOfLife.process(inCommon, inScientific, out, ap.getRequired("idPrefix"), false);
        }
    }

    private static void process(File inCommon, File inScientific, File out, String idPrefix, boolean doRegexp) {
        try {
            StreamIterator data;
            BufferedWriter outStream = new BufferedWriter(new FileWriter(out));
            if (inCommon != null) {
                data = new StreamIterator(inCommon);
                data.next();
                for (String s : data) {
                    String[] fs = s.split("\t");
                    if (fs.length != 2) continue;
                    String id = String.valueOf(idPrefix) + fs[0];
                    String name = fs[1];
                    Set<String> names = CatalogueOfLife.getCommonNames(name);
                    if (doRegexp) {
                        throw new IllegalStateException();
                    }
                    outStream.write(String.valueOf(id) + "\t" + Misc.unsplit(names, "|") + "\n");
                }
            }
            if (inScientific != null) {
                data = new StreamIterator(inScientific);
                data.next();
                HashSet<String> coveredNames = new HashSet<String>();
                for (String s : data) {
                    String[] fs = s.split("\t");
                    if (fs.length != 4) continue;
                    String id = String.valueOf(idPrefix) + fs[0];
                    String genus = fs[1];
                    String sp = fs[2];
                    if (fs.length > 3 && fs[3].length() > 0 && !fs[3].equals("NULL")) {
                        sp = String.valueOf(sp) + " " + fs[3];
                    }
                    if (coveredNames.contains(String.valueOf(genus) + " " + sp)) continue;
                    String v1 = String.valueOf(genus) + " " + sp;
                    String v2 = doRegexp ? String.valueOf(genus.charAt(0)) + "\\. " + sp : String.valueOf(genus.charAt(0)) + ". " + sp;
                    String v = doRegexp ? "(" + v1 + ")|(" + v2 + ")" : String.valueOf(v1) + "|" + v2;
                    outStream.write(String.valueOf(id) + "\t" + v + "\n");
                    coveredNames.add(String.valueOf(genus) + " " + sp);
                }
            }
            outStream.close();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static Set<String> getCommonNames(String name) {
        HashSet<String> names = new HashSet<String>();
        char c = name.charAt(0);
        if (!name.endsWith("s")) {
            names.add(String.valueOf(Character.toLowerCase(c)) + name.substring(1));
            names.add(String.valueOf(Character.toUpperCase(c)) + name.substring(1));
            names.add(String.valueOf(Character.toLowerCase(c)) + name.substring(1) + "s");
            names.add(String.valueOf(Character.toUpperCase(c)) + name.substring(1) + "s");
        } else {
            names.add(String.valueOf(Character.toLowerCase(c)) + name.substring(1));
            names.add(String.valueOf(Character.toUpperCase(c)) + name.substring(1));
        }
        return names;
    }
}

