/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.entitytagger;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import martin.common.ComparableTuple;
import martin.common.Misc;
import martin.common.SQL;

public class Mention
implements Comparable<Mention>,
Serializable {
    private static final long serialVersionUID = 6741123952662841857L;
    public static final String COMMENT_SEPARATOR = "|";
    private int start;
    private int end;
    private String text;
    private String[] ids;
    private String comment;
    private String docid;
    private Double[] probabilities;
    private String[] idLines;

    public Mention(String[] ids) {
        this(ids, -1, -1, null);
    }

    public Mention clone() {
        Mention m = new Mention((String[])this.getIdsWithLineNumbers().clone(), this.start, this.end, this.text);
        m.setProbabilities(this.probabilities != null ? (Double[])this.probabilities.clone() : null);
        m.setComment(this.comment);
        m.setDocid(this.docid);
        return m;
    }

    public Mention(String id, int start, int end, String text) {
        String[] stringArray;
        if (id != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = id;
        } else {
            stringArray = null;
        }
        this(stringArray, start, end, text);
    }

    public static void saveToStreamInBCFormat(BufferedWriter outStream, List<Mention> mentions, String restrictBySpecies, Map<String, String> toSpeciesMap) {
        if (restrictBySpecies != null && toSpeciesMap == null) {
            throw new IllegalStateException("If restrictBySpecies != null, toSpeciesMap also have to be != null (you most likely forgot to specify the file containing mappings from gene/protein entity ids to species ids.)");
        }
        try {
            for (Mention m : mentions) {
                HashMap counts = new HashMap();
                String[] stringArray = m.getIds();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    if (restrictBySpecies == null || !toSpeciesMap.get(id).equals(restrictBySpecies)) {
                        if (!counts.containsKey(id)) {
                            counts.put(id, new HashMap());
                        }
                        if (!((Map)counts.get(id)).containsKey(m.getText())) {
                            ((Map)counts.get(id)).put(m.getText(), 1);
                        } else {
                            ((Map)counts.get(id)).put(m.getText(), (Integer)((Map)counts.get(id)).get(m.getText()) + 1);
                        }
                    }
                    ++n2;
                }
                for (String id : counts.keySet()) {
                    Map map = (Map)counts.get(id);
                    String max = null;
                    for (String k : map.keySet()) {
                        if (max != null && (Integer)map.get(k) <= (Integer)map.get(max)) continue;
                        max = k;
                    }
                    outStream.write(String.valueOf(m.getDocid()) + "\t" + id + "\t" + max + "\t" + map.get(max) + "\n");
                }
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public Mention(String[] ids, int start, int end, String text) {
        this.text = null;
        this.comment = "";
        this.docid = "";
        if (ids == null) {
            ids = new String[]{};
        }
        this.ids = ids;
        this.start = start;
        this.end = end;
        this.text = text;
        this.idLines = new String[ids.length];
        int i = 0;
        while (i < ids.length) {
            String[] fields;
            if (ids[i].contains(COMMENT_SEPARATOR) && (fields = ids[i].split("\\|")).length == 2) {
                this.ids[i] = fields[0];
                this.idLines[i] = fields[1];
            }
            ++i;
        }
    }

    public boolean containsID(String id) {
        int i = 0;
        while (i < this.ids.length) {
            if (this.ids[i].equals(id)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public SimpleMention simplify(Map<String, String> descriptionMap) {
        return new SimpleMention(this.ids, this.probabilities, this.start, this.end, this.text, descriptionMap);
    }

    public void disambiguate(String id) {
        if (!this.containsID(id)) {
            throw new IllegalStateException("Disambiguated ids not found in Match entry");
        }
        this.ids = new String[]{id};
        this.probabilities = null;
    }

    public String toString() {
        String start_local = this.start != -1 ? "" + this.start : "";
        String end_local = this.end != -1 ? "" + this.end : "";
        String text_local = this.text != null ? this.text.replace('\t', ' ') : "";
        String comment_local = this.comment != null ? this.comment : "";
        return String.valueOf(this.getIdsToString()) + "\t" + this.docid + "\t" + start_local + "\t" + end_local + "\t" + text_local + "\t" + comment_local;
    }

    public String[] getIds() {
        return this.ids;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean isAmbigous() {
        return this.ids.length > 1;
    }

    public boolean equals(Object o) {
        Mention m = (Mention)o;
        return m.toString().equals(this.toString());
    }

    public static boolean overlaps(Mention m1, Mention m2) {
        if (m1.getDocid() == null && m2.getDocid() != null) {
            return false;
        }
        if (m1.getDocid() != null && m2.getDocid() == null) {
            return false;
        }
        if (m1.getDocid() != null && !m1.getDocid().equals(m2.getDocid())) {
            return false;
        }
        int s1 = m1.getStart();
        int s2 = m2.getStart();
        int e1 = m1.getEnd();
        int e2 = m2.getEnd();
        return s1 >= s2 && s1 < e2 || s2 >= s1 && s2 < e1;
    }

    public boolean overlaps(Mention m2) {
        return Mention.overlaps(this, m2);
    }

    public static Map<String, List<Mention>> loadFromFileToHash(File file, Set<String> validDocumentIDs, String restrictPostfix, HashMap<String, String> conversionMap) {
        HashMap<String, List<Mention>> res = new HashMap<String, List<Mention>>();
        List<Mention> matches = Mention.loadFromFile(file, validDocumentIDs, restrictPostfix, conversionMap);
        for (Mention m : matches) {
            if (!res.containsKey(m.getDocid())) {
                res.put(m.getDocid(), new ArrayList());
            }
            ((List)res.get(m.getDocid())).add(m);
        }
        return res;
    }

    public static List<Mention> loadFromFile(File file) {
        return Mention.loadFromFile(file, null, null, null);
    }

    public static List<Mention> loadFromFile(File file, Set<String> validDocumentIDs, String restrictPostfix, HashMap<String, String> conversionMap) {
        try {
            BufferedReader inStream = new BufferedReader(new FileReader(file));
            ArrayList<Mention> matches = new ArrayList<Mention>();
            String line = inStream.readLine();
            Pattern splitPattern = Pattern.compile("\\t");
            while (line != null) {
                if (!line.startsWith("#")) {
                    String[] fields = splitPattern.split(line, -1);
                    String id = fields[1];
                    boolean valid = false;
                    if (validDocumentIDs == null && restrictPostfix == null) {
                        valid = true;
                    } else if (restrictPostfix != null && id.endsWith(restrictPostfix)) {
                        valid = true;
                    } else if (validDocumentIDs != null && validDocumentIDs.contains(id)) {
                        valid = true;
                    } else if (conversionMap != null && conversionMap.containsKey(id) && validDocumentIDs != null && validDocumentIDs.contains(conversionMap.get(id))) {
                        valid = true;
                    }
                    if (valid) {
                        Double[] probs;
                        String[] isp;
                        int e;
                        int s = fields[2].length() > 0 ? Integer.parseInt(fields[2]) : -1;
                        int n = e = fields[3].length() > 0 ? Integer.parseInt(fields[3]) : -1;
                        if (fields[0].contains(COMMENT_SEPARATOR)) {
                            String[] sp = fields[0].split("\\|");
                            isp = new String[sp.length];
                            probs = new Double[sp.length];
                            int i = 0;
                            while (i < sp.length) {
                                if (sp[i].contains("?")) {
                                    String[] f2 = sp[i].split("\\?");
                                    isp[i] = f2[0];
                                    if (f2.length > 1) {
                                        probs[i] = Double.parseDouble(f2[1]);
                                    }
                                } else {
                                    isp[i] = sp[i];
                                }
                                ++i;
                            }
                        } else {
                            isp = new String[]{fields[0]};
                            probs = new Double[1];
                        }
                        Mention m = new Mention(isp, s, e, fields[4]);
                        m.setDocid(id);
                        m.setProbabilities(probs);
                        if (fields.length > 5) {
                            m.setComment(fields[5]);
                        }
                        matches.add(m);
                    }
                }
                line = inStream.readLine();
            }
            inStream.close();
            return matches;
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public static void saveToFile(ArrayList<Mention> matches, File file) {
        try {
            matches = Misc.sort(matches);
            BufferedWriter outStream = new BufferedWriter(new FileWriter(file));
            outStream.write("#entity id\tdocument\tstart\tend\ttext\tcomment\n");
            int i = 0;
            while (i < matches.size()) {
                outStream.write(String.valueOf(((Mention)matches.get(i)).toString()) + "\n");
                ++i;
            }
            outStream.close();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public int compareTo(Mention o) {
        if (this.docid != null && o.docid != null && !this.docid.equals(o.docid)) {
            return this.docid.compareTo(o.docid);
        }
        if (this.start != o.getStart()) {
            return new Integer(this.start).compareTo(o.getStart());
        }
        return new Integer(this.end).compareTo(o.getEnd());
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public String getText() {
        return this.text;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getDocid() {
        return this.docid;
    }

    public void setDocid(String docid) {
        this.docid = docid;
    }

    public Double[] getProbabilities() {
        return this.probabilities;
    }

    public void setProbabilities(Double[] probabilities) {
        if (probabilities != null && probabilities.length != this.ids.length) {
            throw new IllegalStateException("Different number of probabilities and ids");
        }
        this.probabilities = probabilities;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getMostProbableID() {
        if (this.ids == null || this.ids.length == 0) {
            return null;
        }
        int max = 0;
        if (this.probabilities != null) {
            double maxprob = this.probabilities[max] != null ? this.probabilities[max] : 0.0;
            int i = 0;
            while (i < this.probabilities.length) {
                if (this.probabilities[i] != null && this.probabilities[i] > maxprob) {
                    max = i;
                    maxprob = this.probabilities[i];
                }
                ++i;
            }
        }
        return this.ids[max];
    }

    public void addToPstmtBatch(PreparedStatement pstmt) {
        try {
            SQL.set(pstmt, 1, this.getMostProbableID());
            SQL.set(pstmt, 2, this.getDocid());
            SQL.set(pstmt, 3, this.getStart());
            SQL.set(pstmt, 4, this.getEnd());
            SQL.set(pstmt, 5, this.getText());
            SQL.set(pstmt, 6, this.getComment());
            pstmt.addBatch();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void setIds(String[] ids) {
        this.ids = ids;
        if (this.probabilities != null && this.probabilities.length != ids.length) {
            this.probabilities = null;
        }
    }

    public String getMostProbableIDWithIdLine() {
        int max = 0;
        if (this.ids.length > 1 && this.probabilities != null) {
            double maxprob = this.probabilities[max] != null ? this.probabilities[max] : 0.0;
            int i = 0;
            while (i < this.probabilities.length) {
                if (this.probabilities[i] != null && this.probabilities[i] > maxprob) {
                    max = i;
                    maxprob = this.probabilities[i];
                }
                ++i;
            }
        }
        String res = this.idLines[max] == null || this.idLines.length < max ? this.ids[max] : String.valueOf(this.ids[max]) + COMMENT_SEPARATOR + this.idLines[max];
        return res;
    }

    public String[] getIdsWithLineNumbers() {
        if (this.idLines == null) {
            return this.ids;
        }
        String[] res = new String[this.ids.length];
        int i = 0;
        while (i < this.ids.length) {
            res[i] = this.idLines[i] == null ? this.ids[i] : String.valueOf(this.ids[i]) + COMMENT_SEPARATOR + this.idLines[i];
            ++i;
        }
        return res;
    }

    public String getIdsToString() {
        if (this.ids.length == 0) {
            return "";
        }
        String sp = this.ids[0];
        if (this.probabilities != null && this.probabilities.length > 0 && this.probabilities[0] != null && this.probabilities[0] > 0.0) {
            sp = String.valueOf(sp) + "?" + this.probabilities[0];
        }
        int i = 1;
        while (i < this.ids.length) {
            sp = String.valueOf(sp) + COMMENT_SEPARATOR + this.ids[i];
            if (this.probabilities != null && this.probabilities.length > i && this.probabilities[i] != null && this.probabilities[i] > 0.0) {
                sp = String.valueOf(sp) + "?" + this.probabilities[i];
            }
            ++i;
        }
        return sp;
    }

    public static Mention findClosestMention(List<Mention> mentions, int pos) {
        if (mentions == null || mentions.size() == 0) {
            return null;
        }
        Mention aux = null;
        int dist = Integer.MAX_VALUE;
        for (Mention m : mentions) {
            if (aux != null && dist <= Math.abs((m.getStart() + m.getEnd()) / 2 - pos)) continue;
            aux = m;
            dist = Math.abs((m.getStart() + m.getEnd()) / 2 - pos);
        }
        return aux;
    }

    public static List<Mention> getMentionsInRange(List<Mention> mentions, int start, int end) {
        ArrayList<Mention> aux = new ArrayList<Mention>();
        for (Mention m : mentions) {
            if (m.getStart() >= start && m.getEnd() <= end) {
                aux.add(m);
                continue;
            }
            if (m.getStart() > end) break;
        }
        return aux;
    }

    public void sortIDsByProbabilities() {
        if (this.probabilities != null) {
            Object[] cts = new ComparableTuple[this.ids.length];
            int i = 0;
            while (i < cts.length) {
                cts[i] = new ComparableTuple<Double, Integer>(this.probabilities[i] != null ? -this.probabilities[i].doubleValue() : 0.0, i);
                ++i;
            }
            Arrays.sort(cts);
            String[] newIDs = new String[this.ids.length];
            Double[] newProbs = new Double[this.ids.length];
            String[] newIDLines = new String[this.ids.length];
            int i2 = 0;
            while (i2 < this.ids.length) {
                int x = (Integer)((ComparableTuple)cts[i2]).getB();
                newIDs[i2] = this.ids[x];
                newProbs[i2] = this.probabilities[x];
                newIDLines[i2] = this.idLines[x];
                ++i2;
            }
            this.ids = newIDs;
            this.probabilities = newProbs;
            this.idLines = newIDLines;
        }
    }

    public static void sort(List<Mention> mentions) {
        Object[] m2 = mentions.toArray(new Mention[0]);
        Arrays.sort(m2);
        mentions.clear();
        mentions.addAll(Arrays.asList(m2));
    }

    public boolean overlapsIgnoreDoc(Mention n) {
        int s1 = this.getStart();
        int s2 = n.getStart();
        int e1 = this.getEnd();
        int e2 = n.getEnd();
        return s1 >= s2 && s1 < e2 || s2 >= s1 && s2 < e1;
    }

    private class IDPair {
        private String id;
        private Double prob;
        private String description;

        public String getDescription() {
            return this.description;
        }

        public IDPair(String id, Double prob, String description) {
            this.id = id;
            this.prob = prob;
            this.description = description;
        }

        public String getId() {
            return this.id;
        }

        public Double getProb() {
            return this.prob;
        }
    }

    public class SimpleMention {
        private IDPair[] ids;
        private int start;
        private int end;
        private String text;

        public SimpleMention(String[] ids, Double[] probabilities, int start, int end, String text, Map<String, String> descriptions) {
            if (probabilities == null || probabilities.length != ids.length) {
                probabilities = new Double[ids.length];
            }
            this.ids = new IDPair[ids.length];
            int i = 0;
            while (i < this.ids.length) {
                String desc = descriptions != null && descriptions.containsKey(ids[i]) ? descriptions.get(ids[i]) : null;
                this.ids[i] = new IDPair(ids[i], probabilities[i], desc);
                ++i;
            }
            this.start = start;
            this.end = end;
            this.text = text;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String getText() {
            return this.text;
        }

        public IDPair[] getIds() {
            return this.ids;
        }
    }
}

