/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.documentparser.input.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import martin.common.Pair;
import martin.common.SentenceSplitter;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.documentparser.input.DocumentIterator;

public class Splitter
implements DocumentIterator {
    private int sentencesPerSplit;
    private DocumentIterator documents;
    private LinkedList<String> currentTexts = new LinkedList();
    private LinkedList<String> currentIDs;

    public Splitter(DocumentIterator documents, int sentencesPerSplit) {
        this.sentencesPerSplit = sentencesPerSplit;
        this.documents = documents;
        this.getNext();
    }

    private void getNext() {
        LinkedList<String> resTexts = new LinkedList<String>();
        LinkedList<String> resIDs = new LinkedList<String>();
        Document d = (Document)this.documents.next();
        String text = d.toString();
        SentenceSplitter ssp = new SentenceSplitter(text);
        StringBuffer sb = new StringBuffer();
        int c = 0;
        int x = 0;
        String currentID = String.valueOf(d.getID()) + "." + x++ + ".0";
        for (Pair<Integer> p : ssp) {
            sb.append(text.substring(p.getX(), p.getY()));
            if (++c != this.sentencesPerSplit) continue;
            resTexts.add(sb.toString());
            resIDs.add(currentID);
            currentID = String.valueOf(d.getID()) + "." + x++ + "." + p.getY();
            sb = new StringBuffer();
            c = 0;
        }
        if (c > 0) {
            resTexts.add(sb.toString());
            resIDs.add(currentID);
        }
        this.currentTexts = resTexts;
        this.currentIDs = resIDs;
    }

    @Override
    public void skip() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.currentTexts.size() == 0) {
            this.getNext();
        }
        this.currentTexts.removeFirst();
    }

    @Override
    public boolean hasNext() {
        return this.currentTexts != null && (this.currentTexts.size() > 0 || this.documents.hasNext());
    }

    @Override
    public Document next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.currentTexts.size() == 0) {
            this.getNext();
        }
        String t = this.currentTexts.removeFirst();
        String id = this.currentIDs.removeFirst();
        return new Document(id, null, null, null, t, null, null, null, null, null, null, null, null, null, null);
    }

    @Override
    public void remove() {
        throw new IllegalStateException();
    }

    @Override
    public Iterator<Document> iterator() {
        return this;
    }
}

