/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.documentparser.input.util;

import java.util.Iterator;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.documentparser.input.DocumentIterator;

public class CleanUnicode
implements DocumentIterator {
    private DocumentIterator documents;

    public CleanUnicode(DocumentIterator documents) {
        this.documents = documents;
    }

    @Override
    public void skip() {
        this.documents.skip();
    }

    @Override
    public boolean hasNext() {
        return this.documents.hasNext();
    }

    @Override
    public Document next() {
        Document d = (Document)this.documents.next();
        d.setTitle(this.clean(d.getTitle()));
        d.setAbs(this.clean(d.getAbs()));
        d.setBody(this.clean(d.getBody()));
        d.setRawContent(this.clean(d.getRawContent()));
        return d;
    }

    private String clean(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(s);
        int i = 0;
        while (i < sb.length()) {
            if (sb.codePointAt(i) == 8211 || sb.codePointAt(i) == 157) {
                sb.setCharAt(i, '-');
            }
            if (sb.codePointAt(i) < 32 && sb.codePointAt(i) != 10) {
                sb.setCharAt(i, ' ');
            }
            if (sb.codePointAt(i) > 126) {
                sb.setCharAt(i, ' ');
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void remove() {
        this.documents.remove();
    }

    @Override
    public Iterator<Document> iterator() {
        return this;
    }
}

