/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.documentparser.input;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.documentparser.dataholders.ExternalID;
import uk.ac.man.documentparser.input.DocumentIterator;

public class TextFile
implements DocumentIterator {
    private int nextArticle = 0;
    private File[] files;
    private String text;
    private String id;

    public TextFile(File[] files) {
        this.files = files;
    }

    public TextFile(String text) {
        this.text = text;
        this.files = new File[1];
    }

    @Override
    public boolean hasNext() {
        return this.nextArticle < this.files.length;
    }

    @Override
    public Iterator<Document> iterator() {
        return this;
    }

    @Override
    public Document next() {
        if (this.files != null && this.text == null) {
            StringBuffer sb = new StringBuffer();
            try {
                BufferedReader inStream = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.files[this.nextArticle]), "UTF-8"));
                String line = inStream.readLine();
                while (line != null) {
                    sb.append(String.valueOf(line) + "\n");
                    line = inStream.readLine();
                }
                inStream.close();
            }
            catch (Exception e) {
                System.err.println(e);
                e.printStackTrace();
                System.exit(-1);
            }
            this.id = this.files[this.nextArticle].getName();
            if (this.id.endsWith(".txt")) {
                this.id = this.id.substring(0, this.id.length() - 4);
            }
            this.text = sb.toString();
        }
        ExternalID externalID = new ExternalID(this.id, ExternalID.Source.TEXT);
        Document d = new Document(this.id, null, null, null, this.text, Document.Text_raw_type.TEXT, null, null, null, null, null, null, null, null, externalID);
        ++this.nextArticle;
        this.text = null;
        return d;
    }

    @Override
    public void remove() {
        throw new IllegalStateException("remove() is not supported");
    }

    @Override
    public void skip() {
        ++this.nextArticle;
    }
}

