/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.documentparser.input;

import java.util.Iterator;
import java.util.NoSuchElementException;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.documentparser.input.DocumentIterator;

public class PMCAbstract
implements DocumentIterator {
    private DocumentIterator pmcDocs;
    private DocumentIterator medlineDocs;
    int lastReturned = -1;

    public PMCAbstract(DocumentIterator pmcDocs, DocumentIterator medlineDocs) {
        this.pmcDocs = pmcDocs;
        this.medlineDocs = medlineDocs;
    }

    @Override
    public void skip() {
        if (this.pmcDocs != null && this.pmcDocs.hasNext()) {
            this.pmcDocs.skip();
        } else if (this.medlineDocs != null && this.medlineDocs.hasNext()) {
            this.medlineDocs.skip();
        } else {
            throw new NoSuchElementException();
        }
    }

    @Override
    public boolean hasNext() {
        return this.pmcDocs != null && this.pmcDocs.hasNext() || this.medlineDocs != null && this.medlineDocs.hasNext();
    }

    @Override
    public Iterator<Document> iterator() {
        return this;
    }

    @Override
    public Document next() {
        if (this.pmcDocs != null && this.pmcDocs.hasNext()) {
            Document d = (Document)this.pmcDocs.next();
            this.lastReturned = 0;
            return new Document(d.getID(), d.getTitle(), d.getAbs(), null, null, null, d.getYear(), d.getJournal(), d.getType(), d.getAuthors(), d.getVolume(), d.getIssue(), d.getPages(), null, null);
        }
        if (this.medlineDocs != null && this.medlineDocs.hasNext()) {
            this.lastReturned = 1;
            return (Document)this.medlineDocs.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (this.lastReturned == -1) {
            throw new NoSuchElementException();
        }
        if (this.lastReturned == 0) {
            this.pmcDocs.remove();
        } else if (this.lastReturned == 1) {
            this.medlineDocs.remove();
        }
        this.lastReturned = -1;
    }
}

