/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.documentparser.input;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Iterator;
import java.util.Set;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.documentparser.input.DocumentIterator;
import uk.ac.man.documentparser.input.Medline;
import uk.ac.man.documentparser.input.PMC;

public class MedlinePMCIndex
implements DocumentIterator {
    private File medlineBaseDir;
    private BufferedReader indexStream;
    private String currentFile;
    private BufferedReader currentFileStream;
    private int currentFilePassed;
    private String currentLine;
    private final String startXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><MedlineCitationSet>";
    private final String endXML = "</MedlineCitationSet>";
    private String nextEntry;
    private int minYearFilter;
    private Set<String> validIDs;
    private File pmcBaseDir;
    private String[] dtds;

    public MedlinePMCIndex(File medlineBaseDir, File pmcBaseDir, File indexFile, String[] dtds, int minYearFilter, Set<String> validIDs) {
        this.medlineBaseDir = medlineBaseDir;
        this.pmcBaseDir = pmcBaseDir;
        this.dtds = dtds;
        this.minYearFilter = minYearFilter;
        this.validIDs = validIDs;
        try {
            this.indexStream = new BufferedReader(new FileReader(indexFile));
        }
        catch (FileNotFoundException e) {
            System.err.println("The file " + indexFile.getAbsolutePath() + " could not be found. Exiting.");
            System.exit(-1);
        }
        this.fetchNextLine();
    }

    @Override
    public Iterator<Document> iterator() {
        return this;
    }

    private void fetchNextLine() {
        try {
            boolean read = true;
            while (read) {
                this.nextEntry = this.indexStream.readLine();
                read = false;
                if (this.nextEntry == null) continue;
                String[] fields = this.nextEntry.split(",");
                if (this.nextEntry.startsWith("#")) {
                    read = true;
                    continue;
                }
                if (this.minYearFilter != -1 && this.minYearFilter > Integer.parseInt(fields[12])) {
                    read = true;
                    continue;
                }
                if (this.validIDs == null || this.validIDs.contains(fields[0])) continue;
                read = true;
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public Document next() {
        Document doc = null;
        try {
            if (this.nextEntry != null) {
                String[] fields = this.nextEntry.split(",");
                String medlinefile = fields[2];
                int start = Integer.parseInt(fields[3]);
                int end = Integer.parseInt(fields[4]);
                if (!medlinefile.equals(this.currentFile)) {
                    if (this.currentFileStream != null) {
                        this.currentFileStream.close();
                    }
                    this.currentFile = medlinefile;
                    this.currentFileStream = new BufferedReader(new FileReader(new File(this.medlineBaseDir, medlinefile)));
                    this.currentFilePassed = 0;
                    this.currentLine = this.currentFileStream.readLine();
                }
                while (start >= this.currentFilePassed + this.currentLine.length()) {
                    this.currentFilePassed += this.currentLine.length();
                    this.currentLine = this.currentFileStream.readLine();
                }
                StringBuffer data = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?><MedlineCitationSet>");
                int localStart = Math.max(start - this.currentFilePassed, 0);
                while (end > this.currentFilePassed + this.currentLine.length()) {
                    data.append(this.currentLine.substring(localStart));
                    this.currentFilePassed += this.currentLine.length();
                    localStart = Math.max(start - this.currentFilePassed, 0);
                    this.currentLine = this.currentFileStream.readLine();
                }
                data.append(this.currentLine.substring(localStart, end - this.currentFilePassed));
                data.append("</MedlineCitationSet>");
                doc = new Medline(data).next();
                Document pmcDoc = new PMC(new File(this.pmcBaseDir, fields[5]).getAbsolutePath(), this.dtds, fields[1], fields[6].equals("1"), fields[7].equals("1"), fields[8].equals("1"), fields[9].equals("1")).next();
                doc.setBody(pmcDoc.getBody());
                doc.setRawContent(pmcDoc.getRawContent());
                doc.setRaw_type(pmcDoc.getRaw_type());
                this.fetchNextLine();
            } else {
                this.indexStream.close();
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
        return doc;
    }

    @Override
    public boolean hasNext() {
        return this.nextEntry != null;
    }

    @Override
    public void remove() {
        throw new IllegalStateException("Not implemented.");
    }

    @Override
    public void skip() {
        this.fetchNextLine();
    }
}

