/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.documentparser.input;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import martin.common.MyConnection;
import uk.ac.man.documentparser.dataholders.Author;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.documentparser.dataholders.ExternalID;
import uk.ac.man.documentparser.dataholders.Journal;
import uk.ac.man.documentparser.input.DocumentIterator;

public class DatabaseIterator
implements DocumentIterator {
    private ResultSet rs;
    private boolean hasNext;
    private boolean full;
    private Statement stmt;
    private int returnedDocs = 0;
    private String selectQuery;
    private MyConnection myConn;
    private Connection conn;
    private Set<String> skipIDs = null;

    public DatabaseIterator(MyConnection myConn, String selectQuery, boolean full, String skipDocIdsQuery) {
        this.selectQuery = selectQuery;
        this.myConn = myConn;
        if (skipDocIdsQuery != null) {
            System.out.println("Getting set of doc IDs to skip... (" + skipDocIdsQuery + ")");
            this.skipIDs = this.getSkipIDs(this.conn, skipDocIdsQuery);
            System.out.println("Done, got " + this.skipIDs.size() + " document IDs.");
        }
        System.out.println(selectQuery);
        this.reconnect();
        System.out.println("done");
        this.full = full;
    }

    private Set<String> getSkipIDs(Connection conn2, String skipDocIdsQuery) {
        HashSet<String> res = new HashSet<String>();
        try {
            this.conn = this.myConn.getConn();
            this.stmt = this.conn.createStatement(1003, 1007);
            this.stmt.setFetchSize(Integer.MIN_VALUE);
            ResultSet rs = this.stmt.executeQuery(skipDocIdsQuery);
            while (rs.next()) {
                res.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
        return res;
    }

    private void reconnect() {
        boolean retry = true;
        boolean sleep = false;
        while (retry) {
            try {
                if (sleep) {
                    Thread.sleep(10000L);
                }
                this.conn = this.myConn.getConn();
                this.stmt = this.conn.createStatement(1003, 1007);
                this.stmt.setFetchSize(Integer.MIN_VALUE);
                String q = this.selectQuery;
                if (this.returnedDocs > 0 && q.toLowerCase().contains("limit")) {
                    throw new IllegalStateException("Cannot reconnect to SQL database since the SELECT query contains a LIMIT clause.");
                }
                if (this.returnedDocs > 0) {
                    q = String.valueOf(q) + " LIMIT " + this.returnedDocs + ", " + Integer.MAX_VALUE;
                }
                System.out.println(q);
                this.rs = this.stmt.executeQuery(q);
                this.hasNext = this.rs.next();
                while (this.hasNext && this.skipIDs != null && this.skipIDs.contains(this.rs.getString("id_ext"))) {
                    this.hasNext = this.rs.next();
                }
                if (!this.hasNext) {
                    this.rs.close();
                }
                System.out.println("HasNext: " + this.hasNext);
                retry = false;
            }
            catch (Exception e) {
                if (e.toString().contains("com.mysql.jdbc.exceptions.jdbc4.MySQLSyntaxErrorException")) {
                    throw new RuntimeException(e);
                }
                System.err.println(e.toString());
                System.err.println("Retrying...");
                sleep = true;
            }
        }
    }

    @Override
    public void skip() {
        try {
            this.hasNext = this.rs.next();
            if (!this.hasNext) {
                this.rs.close();
            }
        }
        catch (SQLException e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Document next() {
        assert (this.hasNext);
        boolean reconnect = false;
        while (true) {
            try {
                if (reconnect) {
                    Thread.sleep(10000L);
                    this.reconnect();
                }
                Document d = null;
                d = !this.full ? new Document(this.rs.getString("id_ext"), this.rs.getString("text_title"), this.rs.getString("text_abstract"), this.rs.getString("text_body"), this.rs.getString("text_raw"), null, null, null, null, null, null, null, null, null, null) : new Document(this.rs.getString("id_ext"), this.rs.getString("text_title"), this.rs.getString("text_abstract"), this.rs.getString("text_body"), this.rs.getString("text_raw"), this.convTextRawType(this.rs.getString("text_raw_type")), this.rs.getString("year"), new Journal(this.rs.getString("id_issn"), null, null), this.convType(this.rs.getString("article_type")), this.convAuthors(this.rs.getString("authors")), this.rs.getString("volume"), this.rs.getString("issue"), this.rs.getString("pages"), this.rs.getString("xml"), new ExternalID(this.rs.getString("id_ext"), this.convSource(this.rs.getString("source"))));
                this.hasNext = this.rs.next();
                while (this.hasNext && this.skipIDs != null && this.skipIDs.contains(this.rs.getString("id_ext"))) {
                    this.hasNext = this.rs.next();
                }
                if (!this.hasNext) {
                    this.rs.close();
                }
                ++this.returnedDocs;
                return d;
            }
            catch (Exception e) {
                System.err.println("DatabaseIterator.java: An error occured: " + e.toString());
                System.err.println("Sleeping for 10s, reconnecting to DB and then retrying");
                reconnect = true;
                continue;
            }
            break;
        }
    }

    private ExternalID.Source convSource(String source) {
        if (source == null) {
            return null;
        }
        if (source.equals(ExternalID.Source.ELSEVIER.toString().toLowerCase())) {
            return ExternalID.Source.ELSEVIER;
        }
        if (source.equals(ExternalID.Source.MEDLINE.toString().toLowerCase())) {
            return ExternalID.Source.MEDLINE;
        }
        if (source.equals(ExternalID.Source.OTHER.toString().toLowerCase())) {
            return ExternalID.Source.OTHER;
        }
        if (source.equals(ExternalID.Source.PMC.toString().toLowerCase())) {
            return ExternalID.Source.PMC;
        }
        if (source.equals(ExternalID.Source.TEXT.toString().toLowerCase())) {
            return ExternalID.Source.TEXT;
        }
        return null;
    }

    private Author[] convAuthors(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new Author[0];
        }
        String[] fs = string.split("\\|");
        Author[] as = new Author[fs.length];
        int i = 0;
        while (i < fs.length) {
            String[] fss = fs[i].split(", ");
            as[i] = fss.length == 2 ? new Author(fss[0], fss[1], null) : new Author(fs[i], "", null);
            ++i;
        }
        return as;
    }

    private Document.Type convType(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals(Document.Type.OTHER.toString().toLowerCase())) {
            return Document.Type.OTHER;
        }
        if (type.equals(Document.Type.RESEARCH.toString().toLowerCase())) {
            return Document.Type.RESEARCH;
        }
        if (type.equals(Document.Type.REVIEW.toString().toLowerCase())) {
            return Document.Type.REVIEW;
        }
        return null;
    }

    private Document.Text_raw_type convTextRawType(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals(Document.Text_raw_type.OCR.toString().toLowerCase())) {
            return Document.Text_raw_type.OCR;
        }
        if (type.equals(Document.Text_raw_type.PDF2TEXT.toString().toLowerCase())) {
            return Document.Text_raw_type.PDF2TEXT;
        }
        if (type.equals(Document.Text_raw_type.TEXT.toString().toLowerCase())) {
            return Document.Text_raw_type.TEXT;
        }
        if (type.equals(Document.Text_raw_type.XML.toString().toLowerCase())) {
            return Document.Text_raw_type.XML;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public Iterator<Document> iterator() {
        return this;
    }
}

