/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.documentparser.dataholders;

import java.io.Serializable;

public class Section
implements Serializable {
    private static final long serialVersionUID = -5798559603277004111L;
    private String title;
    private String content;
    private Section[] subSections;

    public Section(String title, String content, Section[] subSections) {
        this.title = title;
        this.content = content;
        this.subSections = subSections;
    }

    public static String toString(Section[] sections) {
        if (sections == null) {
            return "";
        }
        String res = "";
        Section[] sectionArray = sections;
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            Section s = sectionArray[n2];
            if (s != null) {
                res = String.valueOf(res) + s.toString() + "\n";
            }
            ++n2;
        }
        return res;
    }

    public String toString() {
        StringBuffer res = new StringBuffer(String.valueOf(this.title) + "\n" + this.content);
        if (this.subSections != null) {
            Section[] sectionArray = this.subSections;
            int n = this.subSections.length;
            int n2 = 0;
            while (n2 < n) {
                Section s = sectionArray[n2];
                if (s != null) {
                    res.append(String.valueOf(s.toString()) + "\n");
                }
                ++n2;
            }
        }
        return res.toString();
    }

    public String toHTML(int level) {
        String content;
        StringBuffer sb = new StringBuffer();
        String title = this.title != null ? this.title : "[Section title missing]";
        String string = content = this.content != null ? this.content : "[Section content missing]";
        if (level == 0) {
            sb.append("<br><b>" + title + "</b><br>\n" + content.replace("\n", "<br>\n"));
        }
        if (level == 1) {
            sb.append("<br><i>" + title + "</i><br>\n" + content.replace("\n", "<br>\n"));
        }
        if (level > 1) {
            sb.append("<br>" + title + "<br>\n" + content.replace("\n", "<br>\n"));
        }
        if (this.subSections != null) {
            int i = 0;
            while (i < this.subSections.length) {
                sb.append(String.valueOf(this.subSections[i].toHTML(level + 1)) + "\n");
                ++i;
            }
        }
        return sb.toString();
    }

    public int getLength() {
        int c = 0;
        int s = 0;
        if (this.content != null) {
            c = this.content.length();
        }
        if (this.subSections != null) {
            int i = 0;
            while (i < this.subSections.length) {
                s += this.subSections[i].getLength();
                ++i;
            }
        }
        return c + s;
    }

    public String getTitle() {
        return this.title;
    }

    public String getContent() {
        return this.content;
    }

    public Section[] getSubSections() {
        return this.subSections;
    }

    public String getContentsRecursive() {
        if (this.subSections == null || this.subSections.length == 0) {
            return String.valueOf(this.content) + "\n";
        }
        String res = this.content;
        int i = 0;
        while (i < this.subSections.length) {
            res = String.valueOf(res) + "\n" + this.subSections[i].getContentsRecursive();
            ++i;
        }
        return res;
    }
}

