/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.documentparser.dataholders;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.HashSet;
import martin.common.Misc;
import martin.common.SQL;
import uk.ac.man.documentparser.dataholders.Author;
import uk.ac.man.documentparser.dataholders.ExternalID;
import uk.ac.man.documentparser.dataholders.Journal;

public class Document
implements Serializable {
    private static final long serialVersionUID = 6268131204084207996L;
    private String ID;
    private String title;
    private String abs;
    private String body;
    private String rawContent;
    private Text_raw_type raw_type;
    private String year;
    private boolean ignoreCoordinates = false;
    private Author[] authors;
    private Journal journal;
    private ExternalID externalID;
    private Type type;
    private String volume;
    private String issue;
    private String pages;
    private String xml;

    public Document(String id, String title, String abs, String body, String raw, Text_raw_type raw_type, String year, Journal journal, Type type, Author[] authors, String volume, String issue, String pages, String xml, ExternalID externalID) {
        this.ID = id;
        this.title = title;
        this.abs = abs;
        this.body = body;
        this.rawContent = raw;
        this.raw_type = raw_type;
        this.year = year;
        this.journal = journal;
        this.type = type;
        this.authors = authors;
        this.volume = volume;
        this.issue = issue;
        this.pages = pages;
        this.xml = xml;
        this.externalID = externalID;
    }

    public String getID() {
        return this.ID;
    }

    public boolean isValid(int start, int end) {
        return true;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean simplify) {
        StringBuffer res = new StringBuffer();
        if (this.title != null) {
            res.append(String.valueOf(this.title) + "\n");
        }
        if (this.abs != null) {
            res.append(String.valueOf(this.abs) + "\n");
        }
        if (this.body != null) {
            res.append(String.valueOf(this.body) + "\n");
        }
        if (this.rawContent != null && this.rawContent.length() > 0) {
            res.append(this.rawContent);
        }
        String s = res.toString();
        s = s.replaceAll("\\\\documentclass.*?\\\\end\\{document\\}", "");
        if (simplify) {
            while (s.indexOf("  ") != -1) {
                s = s.replace("  ", " ");
            }
            try {
                return new String(s.toString().getBytes("ascii"), "ascii");
            }
            catch (UnsupportedEncodingException e) {
                System.err.println(e.toString());
                e.printStackTrace();
                System.exit(-1);
            }
        }
        return s.toString();
    }

    public void print() {
        System.out.println(this.toString());
        if (this.authors != null) {
            System.out.println("Authors:");
            Author[] authorArray = this.authors;
            int n = this.authors.length;
            int n2 = 0;
            while (n2 < n) {
                Author a = authorArray[n2];
                System.out.println(a.toString());
                ++n2;
            }
        }
    }

    public static PreparedStatement prepareInsertStatements(Connection conn, boolean clear) {
        return Document.prepareInsertStatements(conn, "articles", clear);
    }

    public static PreparedStatement prepareInsertStatements(Connection conn, String table, boolean clear) {
        try {
            if (clear) {
                conn.createStatement().execute("DROP TABLE IF EXISTS " + table);
                conn.createStatement().execute("CREATE TABLE  " + table + " (" + "`id_art` int(10) unsigned NOT NULL auto_increment," + "`xml` mediumtext," + "`id_ext` varchar(255) NOT NULL," + "`source` enum('medline','pmc','elsevier','text','other') NOT NULL," + "`date_inserted` datetime NOT NULL," + "`text_title` varchar(4096) default NULL," + "`text_abstract` mediumtext," + "`text_body` mediumtext," + "`text_raw` mediumtext," + "`text_raw_type` enum('xml','ocr','pdf2text','text') default NULL," + "`article_type` enum('research','review','other') default NULL," + "`authors` mediumtext," + "`year` varchar(255) default NULL," + "`id_issn` varchar(255) default NULL," + "`volume` varchar(255) default NULL," + "`issue` varchar(255) default NULL," + "`pages` varchar(255) default NULL," + "PRIMARY KEY  (`id_art`)," + "KEY `index_issn` (`id_issn`)," + "KEY `index_type` (`article_type`)," + "KEY `index_id_ext` USING BTREE (`id_ext`)," + "KEY `index_src` (`source`)," + "KEY `yearIdx` (`year`)," + "KEY `type` (`article_type`)" + ") ENGINE=MyISAM AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;");
            }
            PreparedStatement pstmt = conn.prepareStatement("INSERT INTO " + table + " " + "(xml, id_ext, source, date_inserted, text_title, text_abstract, text_body, text_raw, " + "text_raw_type, article_type, authors, year, id_issn, volume, issue, pages) " + "VALUES (?, ?, ?, NOW(), ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            return pstmt;
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public void saveToDB(PreparedStatement pstmt) {
        try {
            SQL.set(pstmt, 1, this.xml);
            SQL.set(pstmt, 2, this.externalID != null ? this.externalID.getID() : null);
            SQL.set(pstmt, 3, this.externalID != null && this.externalID.getSource() != null ? this.externalID.getSource().toString().toLowerCase() : null);
            SQL.set(pstmt, 4, this.title);
            SQL.set(pstmt, 5, this.abs);
            SQL.set(pstmt, 6, this.body);
            SQL.set(pstmt, 7, this.rawContent);
            SQL.set(pstmt, 8, this.raw_type != null ? this.raw_type.toString().toLowerCase() : null);
            SQL.set(pstmt, 9, this.type != null ? this.type.toString().toLowerCase() : null);
            if (this.authors != null) {
                SQL.set(pstmt, 10, Misc.implode(this.authors, "|"));
            } else {
                SQL.set(pstmt, 10, null);
            }
            SQL.set(pstmt, 11, this.year);
            SQL.set(pstmt, 12, this.journal != null ? this.journal.getISSN() : null);
            SQL.set(pstmt, 13, this.volume);
            SQL.set(pstmt, 14, this.issue);
            SQL.set(pstmt, 15, this.pages);
            pstmt.execute();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getYear() {
        return this.year;
    }

    public boolean hasTitle() {
        return this.title != null && this.title.length() > 5;
    }

    public void saveToTextFile(File file, boolean simplify) {
        try {
            BufferedWriter outStream = new BufferedWriter(new FileWriter(file));
            String str = this.toString(simplify);
            outStream.write(str);
            outStream.close();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public String toHTML() {
        StringBuffer sb = new StringBuffer();
        if (this.title != null) {
            sb.append("<b>" + this.title.toString() + "</b><br><br>");
        } else {
            sb.append("[Title missing]");
        }
        if (this.abs != null) {
            sb.append("<b>" + this.abs.toString() + "</b><br><br>");
        } else {
            sb.append("[Abstract missing]");
        }
        if (this.body != null) {
            sb.append("<b>" + this.body.toString() + "</b><br><br>");
        } else {
            sb.append("[Body missing]");
        }
        if (this.rawContent != null) {
            sb.append("<b>" + this.rawContent.toString() + "</b><br><br>");
        } else {
            sb.append("[Raw content missing]");
        }
        return sb.toString();
    }

    public String getRawContent() {
        return this.rawContent;
    }

    public HashSet<Integer> getMeshTaxIDs(HashMap<String, Integer> meshToTax) {
        return null;
    }

    public boolean isIgnoreCoordinates() {
        return this.ignoreCoordinates;
    }

    public void setIgnoreCoordinates(boolean ignoreCoordinates) {
        this.ignoreCoordinates = ignoreCoordinates;
    }

    public static long getSerialVersionUID() {
        return 6268131204084207996L;
    }

    public String getAbs() {
        return this.abs;
    }

    public String getBody() {
        return this.body;
    }

    public Text_raw_type getRaw_type() {
        return this.raw_type;
    }

    public Author[] getAuthors() {
        return this.authors;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public ExternalID getExternalID() {
        return this.externalID;
    }

    public Type getType() {
        return this.type;
    }

    public String getVolume() {
        return this.volume;
    }

    public String getIssue() {
        return this.issue;
    }

    public String getPages() {
        return this.pages;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setRawContent(String rawContent) {
        this.rawContent = rawContent;
    }

    public String getXml() {
        return this.xml;
    }

    public void setRaw_type(Text_raw_type raw_type) {
        this.raw_type = raw_type;
    }

    public String getDescription() {
        if (this.authors == null || this.authors.length == 0) {
            return this.ID;
        }
        String res = "";
        res = this.authors.length == 1 ? this.authors[0].getSurname() : (this.authors.length == 2 ? String.valueOf(this.authors[0].getSurname()) + " and " + this.authors[1].getSurname() : String.valueOf(this.authors[0].getSurname()) + " et al.");
        if (this.year != null) {
            res = String.valueOf(res) + " (" + this.year + ")";
        }
        return res;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAbs(String abs) {
        this.abs = abs;
    }

    public static enum Text_raw_type {
        XML,
        OCR,
        PDF2TEXT,
        TEXT;

    }

    public static enum Type {
        RESEARCH,
        REVIEW,
        OTHER;

    }
}

