/*
 * Decompiled with CFR 0.152.
 */
package martin.common.compthreads;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Semaphore;
import martin.common.ArrayIterator;
import martin.common.compthreads.Master;
import martin.common.compthreads.Problem;
import martin.common.compthreads.Worker;

public class IteratorBasedMaster<E>
extends Master<E>
implements Runnable,
Iterator<E>,
Iterable<E> {
    private Iterator<Problem<E>> problemIterator;
    private Map<Integer, E> solutions;
    private Map<Integer, Semaphore> solutionSemaphores;
    private Semaphore threadsem;
    private Semaphore solutionsem = new Semaphore(1, true);
    private Semaphore addedsem = new Semaphore(0, true);
    private int nextJobToRelease = 0;
    private Semaphore storageLimitSem;

    public IteratorBasedMaster(Iterator<Problem<E>> problemIterator, int numThreads, Integer maxStorageLength) {
        this.problemIterator = problemIterator;
        this.solutions = Collections.synchronizedMap(new HashMap());
        this.solutionSemaphores = Collections.synchronizedMap(new HashMap());
        this.threadsem = new Semaphore(numThreads, true);
        this.storageLimitSem = maxStorageLength != null ? new Semaphore(maxStorageLength, true) : null;
    }

    public IteratorBasedMaster(Iterator<Problem<E>> problemIterator, int numThreads) {
        this(problemIterator, numThreads, null);
    }

    public IteratorBasedMaster(Problem<E>[] array, int numThreads) {
        this(new ArrayIterator<Problem<E>>(array), numThreads, null);
    }

    public IteratorBasedMaster(Collection<Problem<E>> collection, int numThreads) {
        this(collection.iterator(), numThreads, null);
    }

    @Override
    public void run() {
        int nextJob = 0;
        while (this.problemIterator.hasNext()) {
            try {
                this.threadsem.acquire();
                if (this.storageLimitSem != null) {
                    this.storageLimitSem.acquire();
                }
                this.solutionSemaphores.put(nextJob, new Semaphore(0, true));
                Worker<E> w = new Worker<E>(this.problemIterator.next(), this, nextJob++);
                new Thread(w).start();
                this.addedsem.release();
            }
            catch (Exception e) {
                System.err.println(e);
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }

    @Override
    void report(E solution, int id) {
        try {
            this.solutionsem.acquire();
            this.solutions.put(id, solution);
            this.solutionsem.release();
        }
        catch (InterruptedException e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
        if (this.getReportProgress()) {
            System.out.println("\tThread " + id + " finished.");
        }
        this.solutionSemaphores.get(id).release();
        this.threadsem.release();
    }

    @Override
    public boolean hasNext() {
        if (this.problemIterator.hasNext()) {
            return true;
        }
        return this.solutionSemaphores.containsKey(this.nextJobToRelease);
    }

    @Override
    public E next() {
        return this.next(true);
    }

    public E next(boolean remove) {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        E res = null;
        int job = this.nextJobToRelease++;
        try {
            this.addedsem.acquire();
            this.solutionSemaphores.get(job).acquire();
            res = this.solutions.get(job);
            if (remove) {
                this.solutions.remove(job);
                this.solutionSemaphores.remove(job);
                if (this.storageLimitSem != null) {
                    this.storageLimitSem.release();
                }
            } else {
                this.solutionSemaphores.get(job).release();
            }
        }
        catch (InterruptedException e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
        return res;
    }

    public void reset() {
        this.addedsem.release(this.nextJobToRelease);
        this.nextJobToRelease = 0;
    }

    @Override
    public void remove() {
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }
}

