/*
 * Decompiled with CFR 0.152.
 */
package martin.common.compthreads;

import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import martin.common.compthreads.Master;
import martin.common.compthreads.Problem;
import martin.common.compthreads.Worker;

public class ArrayBasedMaster<E>
extends Master<E>
implements Runnable {
    private Problem<E>[] problems;
    private Object[] solutions;
    private Semaphore threadsem;
    private Semaphore solutionsem = new Semaphore(0, true);

    public ArrayBasedMaster(Problem<E>[] problems, int numThreads) {
        this.problems = problems;
        this.solutions = new Object[problems.length];
        this.threadsem = new Semaphore(numThreads, true);
    }

    @Override
    public void run() {
        int i = 0;
        while (i < this.problems.length) {
            try {
                this.threadsem.acquire();
                Worker<E> w = new Worker<E>(this.problems[i], this, i);
                new Thread(w).start();
            }
            catch (Exception e) {
                System.err.println(e);
                e.printStackTrace();
                System.exit(-1);
            }
            ++i;
        }
    }

    public Object[] getSolutions() {
        try {
            int i = 0;
            while (i < this.problems.length) {
                this.solutionsem.acquire();
                ++i;
            }
        }
        catch (InterruptedException e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
        return this.solutions;
    }

    public ArrayList<E> getArrayListSolutions() {
        Object[] sols = this.getSolutions();
        ArrayList<Object> res = new ArrayList<Object>(sols.length);
        int i = 0;
        while (i < res.size()) {
            res.add(sols[i]);
            ++i;
        }
        return res;
    }

    @Override
    void report(E solution, int id) {
        this.solutions[id] = solution;
        if (this.getReportProgress()) {
            if (solution != null) {
                System.out.println("\tThread " + id + " finished.");
            } else {
                System.out.println("\tThread finished.");
            }
        }
        this.solutionsem.release();
        this.threadsem.release();
    }
}

