/*
 * Decompiled with CFR 0.152.
 */
package martin.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class StreamIterator
implements Iterator<String>,
Iterable<String> {
    private BufferedReader stream;
    String line;
    private boolean ignoreHashedLines;

    public StreamIterator(File file) {
        this(file, false);
    }

    public StreamIterator(File file, boolean ignoreHashedLines) {
        this.ignoreHashedLines = ignoreHashedLines;
        try {
            this.stream = new BufferedReader(new FileReader(file));
            this.line = this.stream.readLine();
            if (ignoreHashedLines) {
                while (this.line != null && this.line.startsWith("#")) {
                    this.line = this.stream.readLine();
                }
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public StreamIterator(InputStream inputStream, boolean ignoreHashedLines) {
        this.ignoreHashedLines = ignoreHashedLines;
        try {
            this.stream = new BufferedReader(new InputStreamReader(inputStream));
            this.line = this.stream.readLine();
            if (ignoreHashedLines) {
                while (this.line != null && this.line.startsWith("#")) {
                    this.line = this.stream.readLine();
                }
            }
            if (this.line == null) {
                this.stream.close();
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public boolean hasNext() {
        return this.line != null;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String res = this.line;
        try {
            this.line = this.stream.readLine();
            if (this.ignoreHashedLines) {
                while (this.line != null && this.line.startsWith("#")) {
                    this.line = this.stream.readLine();
                }
            }
            if (this.line == null) {
                this.stream.close();
            }
        }
        catch (IOException e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
        return res;
    }

    @Override
    public void remove() {
        throw new IllegalStateException();
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }
}

