/*
 * Decompiled with CFR 0.152.
 */
package martin.common;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import martin.common.Pair;

public class SentenceSplitter
implements Iterator<Pair<Integer>>,
Iterable<Pair<Integer>> {
    int c = 1;
    private List<Integer> breaks;

    public SentenceSplitter(String text) {
        this(text, true);
    }

    public SentenceSplitter(String text, boolean splitOnLineBreaks) {
        int i;
        BreakIterator bi = BreakIterator.getSentenceInstance();
        bi.setText(text);
        this.breaks = new ArrayList<Integer>();
        this.breaks.add(0);
        while ((i = bi.next()) != -1) {
            this.breaks.add(i);
        }
        int prev = 0;
        if (splitOnLineBreaks) {
            int i2 = 0;
            while (i2 < this.breaks.size()) {
                int x = text.indexOf("\n", prev) + 1;
                int end = this.breaks.get(i2);
                while (x != 0 && x < end) {
                    if (i2 > 0 && x - this.breaks.get(i2 - 1) > 5 && Character.isLetterOrDigit(text.codePointAt(x))) {
                        this.breaks.add(i2++, x);
                    }
                    x = text.indexOf("\n", x + 1) + 1;
                }
                prev = end;
                ++i2;
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.c < this.breaks.size();
    }

    @Override
    public Pair<Integer> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return new Pair<Integer>(this.breaks.get(this.c - 1), this.breaks.get(this.c++));
    }

    @Override
    public void remove() {
        throw new IllegalStateException();
    }

    @Override
    public Iterator<Pair<Integer>> iterator() {
        return this;
    }

    public static List<Pair<Integer>> toList(String text) {
        SentenceSplitter ss = new SentenceSplitter(text);
        ArrayList<Pair<Integer>> res = new ArrayList<Pair<Integer>>();
        for (Pair<Integer> p : ss) {
            res.add(p);
        }
        return res;
    }

    public static void main(String[] args) {
        String text = "When a therapy proves effective , do \n\nclinicians \ntruly know how it works ? Even with a \ntherapy as specific as anti-TNF antibody , it is not clear if the benefit is attributable to simple binding and clearance of TNF-alpha or to binding on the cell surface and subsequent deletion of the activated macrophage . And this is another sentence.";
        SentenceSplitter s = new SentenceSplitter(text);
        for (Pair<Integer> p : s) {
            System.out.println(String.valueOf(p.toString()) + ", '" + text.substring(p.getX(), p.getY()) + "'");
        }
    }
}

