/*
 * Decompiled with CFR 0.152.
 */
package martin.common;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Logger;

public class MyConnection {
    private String user;
    private String pass;
    private String host;
    private int port;
    private String schema;
    private Logger logger;
    private Connection conn;
    private final int RECONNECT_SLEEP_TIME = 10000;

    public MyConnection(String user, String pass, String host, int port, String schema, Logger logger) {
        this.user = user;
        this.pass = pass;
        this.host = host;
        this.port = port;
        this.schema = schema;
        this.logger = logger;
    }

    public Connection getConn() {
        try {
            if (this.conn == null || this.conn.isClosed()) {
                boolean retry = true;
                boolean sleep = false;
                while (retry) {
                    try {
                        if (sleep) {
                            Thread.sleep(10000L);
                        }
                        if (this.logger != null) {
                            this.logger.info("%t: Connecting to MySQL database " + this.schema + " at " + this.user + "@" + this.host + ":" + this.port + "... ");
                        }
                        Class.forName("com.mysql.jdbc.Driver").newInstance();
                        this.conn = DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.schema + "?autoReconnect=true&user=" + this.user + "&password=" + this.pass + "&netTimeoutForStreamingResults=3600");
                        if (this.logger != null) {
                            this.logger.info("%t: Done, connected to SQL server.\n");
                        }
                        retry = false;
                    }
                    catch (Exception e) {
                        this.logger.warning("%t: SQL connection failed (" + e.toString() + "). Trying again in " + 10000 + " ms...");
                        sleep = true;
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return this.conn;
    }

    public Connection reconnect() {
        try {
            this.conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.conn = null;
        return this.getConn();
    }
}

