/*
 * Decompiled with CFR 0.152.
 */
package martin.common;

import java.io.File;
import martin.common.Misc;

public class ChiTester {
    private double[][] vals;

    public ChiTester(File file) {
        double[][] csvvals = Misc.loadCSV(file);
        double[][] vals = new double[csvvals.length][2];
        int i = 0;
        while (i < csvvals.length) {
            double X2 = csvvals[i][1];
            double p = csvvals[i][2];
            vals[i][0] = X2;
            vals[i][1] = p;
            ++i;
        }
        this.vals = vals;
    }

    public String doTest(double X2) {
        int i = 0;
        while (i < this.vals.length - 1) {
            double X2_1 = this.vals[i][0];
            double X2_2 = this.vals[i + 1][0];
            if (X2 >= X2_1 && X2 < X2_2) {
                if (Math.abs(X2 - X2_1) < Math.abs(X2 - X2_2)) {
                    return "X2: " + Misc.round(X2, 4) + "; best match: " + X2_1 + " => " + Misc.round(this.vals[i][1], 4);
                }
                return "X2: " + Misc.round(X2, 4) + "; best match: " + X2_2 + " => " + Misc.round(this.vals[i + 1][1], 4);
            }
            ++i;
        }
        return "X2: " + Misc.round(X2, 4) + ", best match: " + this.vals[this.vals.length - 1][0] + " => " + this.vals[this.vals.length - 1][1];
    }

    public String doTest(double o1, double e1, double o2, double e2) {
        double X2 = (o1 - e1) * (o1 - e1) / e1 + (o2 - e2) * (o2 - e2) / e2;
        return this.doTest(X2);
    }

    public String doTest(double observed, double total, double expectedRatio) {
        double o1 = observed;
        double e1 = total * expectedRatio;
        double o2 = total - observed;
        double e2 = total - e1;
        return this.doTest(o1, e1, o2, e2);
    }

    public void printValues() {
        int i = 0;
        while (i < this.vals.length) {
            int j = 0;
            while (j < this.vals[0].length) {
                System.out.print(String.valueOf(this.vals[i][j]) + "\t");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }
}

