/*
 * Decompiled with CFR 0.152.
 */
package martin.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import martin.common.Function;
import martin.common.Loggers;
import martin.common.Misc;
import martin.common.SimpleClass;
import martin.common.Sizeable;

public class CacheMap<K, V extends Sizeable>
implements Iterable<K> {
    private HashMap<K, V> hashMap = new HashMap();
    private HashMap<K, Long> sizes = new HashMap();
    private LinkedList<K> priority = new LinkedList();
    private long maxSize;
    private long currentSize = 0L;
    private Function<V> factory = null;
    private Logger logger;

    public CacheMap(long maxSize) {
        this(maxSize, null, null);
    }

    public CacheMap(long maxSize, Function<V> factory, Logger logger) {
        this.maxSize = maxSize;
        this.factory = factory;
        this.logger = logger;
    }

    public V get(K key) {
        V v = this.remove(key);
        this.put(key, v);
        return v;
    }

    public void put(K key, V value) {
        if (this.containsKey(key)) {
            this.remove(key);
        }
        this.hashMap.put(key, value);
        this.priority.addFirst(key);
        long size = value.sizeof();
        this.currentSize += size;
        this.sizes.put(key, size);
        this.free();
    }

    public String listKeys() {
        Object[] a = this.priority.toArray();
        return Misc.implode(a, ",");
    }

    private void free() {
        while (this.priority.size() > 1 && this.currentSize > this.maxSize) {
            K k = this.priority.removeLast();
            if (this.logger != null) {
                this.logger.info("Unloading cache map data: " + k + "\n");
            }
            long s = this.sizes.remove(k);
            this.hashMap.remove(k);
            this.currentSize -= s;
        }
        System.gc();
    }

    public V remove(K key) {
        if (!this.containsKey(key)) {
            throw new NoSuchElementException();
        }
        this.priority.remove(key);
        this.currentSize -= this.sizes.remove(key).longValue();
        return (V)((Sizeable)this.hashMap.remove(key));
    }

    public boolean containsKey(K key) {
        return this.hashMap.containsKey(key);
    }

    @Override
    public Iterator<K> iterator() {
        return this.priority.iterator();
    }

    public Set<K> keySet() {
        return this.hashMap.keySet();
    }

    public Collection<V> values() {
        return this.hashMap.values();
    }

    public static void main(String[] args) {
        Logger l = Loggers.getDefaultLogger(null);
        CacheMap<Integer, SimpleClass<String>> c = new CacheMap<Integer, SimpleClass<String>>(5L, null, l);
        int i = 0;
        while (i < 10) {
            c.put(i, new SimpleClass<String>("x" + i, i));
            for (Integer k : c) {
                System.out.print(k + ", ");
            }
            System.out.println();
            ++i;
        }
    }

    public V getOrCreate(K key) {
        if (this.containsKey(key)) {
            return this.get(key);
        }
        if (this.factory != null) {
            if (this.logger != null) {
                this.logger.info("Loading cache map data: " + key + "\n");
            }
            Sizeable v = (Sizeable)this.factory.function(new Object[]{key});
            this.put(key, v);
            if (this.logger != null) {
                this.logger.info("Loaded " + key + ", size: " + this.sizes.get(key) + "\n");
            }
            return (V)v;
        }
        throw new IllegalStateException("getOrCreate can only be called if a factory function has been specified.");
    }

    public void clear() {
        this.priority.clear();
        this.hashMap.clear();
        this.sizes.clear();
        this.currentSize = 0L;
        System.gc();
    }
}

