/*
 * Decompiled with CFR 0.152.
 */
package martin.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import martin.common.Properties;

public class ArgParser {
    private static ArgParser parser;
    private String[] nonSwitched;
    private HashSet<String> enabledSwitches = new HashSet();
    private HashMap<String, String[]> followers = new HashMap();

    public static ArgParser getParser(String[] args) {
        if (parser == null) {
            parser = new ArgParser(args);
        }
        return parser;
    }

    public static ArgParser getParser() {
        return parser;
    }

    public void addAlternate(String a, String b) {
        if (this.enabledSwitches.contains(a)) {
            this.enabledSwitches.add(b);
            if (this.followers.containsKey(a)) {
                this.followers.put(b, this.followers.get(a));
            }
        } else if (this.enabledSwitches.contains(b)) {
            this.enabledSwitches.add(a);
            if (this.followers.containsKey(b)) {
                this.followers.put(a, this.followers.get(b));
            }
        }
    }

    public void addProperties(String name) {
        this.addProperties(Properties.load(name));
    }

    private void addProperties(Properties p) {
        HashMap<String, String> variables = new HashMap<String, String>();
        for (Object ko : p.keySet()) {
            String k = (String)ko;
            String v = p.getProperty(k);
            if (!k.startsWith("$")) continue;
            variables.put(k, v);
        }
        Pattern pattern = Pattern.compile("\\$[a-zA-Z]+");
        for (Object ko : p.keySet()) {
            String k = (String)ko;
            if (this.enabledSwitches.contains(k)) continue;
            String v = p.getProperty(k);
            this.enabledSwitches.add(k);
            String[] fs = v.split(";");
            int i = 0;
            while (i < fs.length) {
                Matcher m = pattern.matcher(fs[i]);
                while (m.find()) {
                    String var = fs[i].substring(m.start(), m.end());
                    if (variables.containsKey(var)) {
                        fs[i] = String.valueOf(fs[i].substring(0, m.start())) + (String)variables.get(var) + fs[i].substring(m.end());
                        m = pattern.matcher(fs[i]);
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized variable: '" + var + "'");
                }
                ++i;
            }
            this.followers.put(k, fs);
        }
    }

    public ArgParser(String[] args) {
        ArrayList nonSwitched = new ArrayList();
        int i = 0;
        while (i < args.length) {
            ArrayList<String> followers;
            String switch_;
            String arg = args[i];
            if (arg.startsWith("--")) {
                if (arg.length() > 2) {
                    switch_ = arg.substring(2);
                    this.enabledSwitches.add(switch_);
                    followers = new ArrayList<String>();
                    while (i + 1 < args.length && (!args[i + 1].startsWith("-") || Character.isDigit(args[i + 1].charAt(1)))) {
                        followers.add(args[++i]);
                    }
                    if (followers.size() > 0) {
                        this.followers.put(switch_, followers.toArray(new String[0]));
                        nonSwitched.addAll(followers);
                    }
                } else {
                    System.err.println("Invalid argument: " + arg);
                    System.exit(-1);
                }
            } else if (arg.startsWith("-") && !Character.isDigit(arg.charAt(1))) {
                if (arg.length() > 1) {
                    if (arg.length() > 2) {
                        int j = 1;
                        while (j < arg.length()) {
                            this.enabledSwitches.add("" + arg.charAt(j));
                            ++j;
                        }
                    } else {
                        switch_ = arg.substring(1);
                        this.enabledSwitches.add(switch_);
                        followers = new ArrayList();
                        while (i + 1 < args.length && (!args[i + 1].startsWith("-") || Character.isDigit(args[i + 1].charAt(1)))) {
                            followers.add(args[++i]);
                        }
                        if (followers.size() > 0) {
                            this.followers.put(switch_, followers.toArray(new String[0]));
                            nonSwitched.addAll(followers);
                        }
                    }
                } else {
                    System.err.println("Invalid argument: " + arg);
                    System.exit(-1);
                }
            } else {
                nonSwitched.add(arg);
            }
            ++i;
        }
        this.nonSwitched = nonSwitched.toArray(new String[0]);
        if (this.containsKey("properties")) {
            String[] stringArray = this.gets("properties");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.addProperties(Properties.load(s));
                ++n2;
            }
        }
    }

    public void printContents() {
        System.out.println("\nNonSwitched:");
        String[] stringArray = this.nonSwitched;
        int n = this.nonSwitched.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            System.out.println("\t" + s);
            ++n2;
        }
        System.out.println("\nEnabled switches:");
        for (String s : this.enabledSwitches) {
            System.out.println("\t" + s);
        }
        System.out.println("\nFollowers:");
        for (String k : this.followers.keySet()) {
            System.out.println("\t" + k);
            String[] stringArray2 = this.followers.get(k);
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String s = stringArray2[n4];
                System.out.println("\t\t" + s);
                ++n4;
            }
        }
    }

    public boolean containsKey(String key) {
        return this.enabledSwitches.contains(key);
    }

    public double[] getDoubles(String key) {
        if (!this.followers.containsKey(key)) {
            return new double[0];
        }
        String[] followers = this.gets(key);
        double[] retres = new double[followers.length];
        int i = 0;
        while (i < retres.length) {
            retres[i] = Double.parseDouble(followers[i]);
            ++i;
        }
        return retres;
    }

    public boolean[] getBooleans(String key) {
        if (!this.followers.containsKey(key)) {
            return new boolean[0];
        }
        String[] followers = this.gets(key);
        boolean[] retres = new boolean[followers.length];
        int i = 0;
        while (i < retres.length) {
            retres[i] = Boolean.parseBoolean(followers[i]);
            ++i;
        }
        return retres;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Boolean b = this.getBoolean(key);
        if (b == null) {
            return defaultValue;
        }
        return b;
    }

    public Boolean getBoolean(String key) {
        if (!this.followers.containsKey(key) || this.followers.get(key).length != 1) {
            return null;
        }
        return Boolean.parseBoolean(this.get(key));
    }

    public int[] getInts(String key) {
        if (!this.followers.containsKey(key)) {
            return new int[0];
        }
        String[] followers = this.gets(key);
        int[] retres = new int[followers.length];
        int i = 0;
        while (i < retres.length) {
            retres[i] = Integer.parseInt(followers[i]);
            ++i;
        }
        return retres;
    }

    public String[] gets(String key) {
        if (this.followers.containsKey(key)) {
            return this.followers.get(key);
        }
        return new String[0];
    }

    public String get(String key) {
        if (this.followers.containsKey(key) && this.followers.get(key).length == 1) {
            return this.followers.get(key)[0];
        }
        return null;
    }

    public String get(String key, String defaultValue) {
        if (this.followers.containsKey(key) && this.followers.get(key).length == 1) {
            return this.followers.get(key)[0];
        }
        return defaultValue;
    }

    public Integer getInt(String key) {
        if (!this.followers.containsKey(key) || this.followers.get(key).length != 1) {
            return null;
        }
        return Integer.parseInt(this.get(key));
    }

    public int getInt(String key, int defaultValue) {
        Integer x = this.getInt(key);
        if (x == null) {
            return defaultValue;
        }
        return x;
    }

    public Double getDouble(String key) {
        if (!this.followers.containsKey(key) || this.followers.get(key).length != 1) {
            return null;
        }
        return Double.parseDouble(this.get(key));
    }

    public double getDouble(String key, double defaultValue) {
        Double d = this.getDouble(key);
        if (d == null) {
            return defaultValue;
        }
        return d;
    }

    public File[] getFiles(String key) {
        if (!this.followers.containsKey(key)) {
            return new File[0];
        }
        String[] followers = this.gets(key);
        File[] retres = new File[followers.length];
        int i = 0;
        while (i < retres.length) {
            retres[i] = new File(followers[i]);
            ++i;
        }
        return retres;
    }

    public File getFile(String key) {
        if (!this.containsKey(key) || this.gets(key).length == 0) {
            return null;
        }
        return new File(this.get(key));
    }

    public File getFile(String key, File defaultValue) {
        File f = this.getFile(key);
        if (f != null) {
            return f;
        }
        return defaultValue;
    }

    public String getRequired(String string) {
        String res = this.get(string);
        if (res == null) {
            throw new IllegalStateException("When running this software, you need to specify exactly one argument for the switch --" + string + ".");
        }
        return res;
    }

    public InputStream getInputStream(String key) {
        String v = this.get(key);
        if (v == null) {
            return null;
        }
        if (v.startsWith("internal:")) {
            InputStream stream = this.getClass().getResourceAsStream(v.substring(9));
            if (stream == null) {
                System.out.println("Could not find the internal resource " + v);
                System.exit(0);
            }
            return stream;
        }
        try {
            return new FileInputStream(new File(v));
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not find the file " + v);
            System.exit(0);
            return null;
        }
    }

    public InputStream[] getInputStreams(String key) {
        String[] v = this.gets(key);
        if (v == null) {
            return null;
        }
        InputStream[] res = new InputStream[v.length];
        int i = 0;
        while (i < res.length) {
            if (v[i].startsWith("internal:")) {
                InputStream stream = this.getClass().getResourceAsStream(v[i].substring(9));
                if (stream == null) {
                    System.out.println("Could not find the internal resource " + v);
                    System.exit(0);
                }
                res[i] = stream;
            } else {
                try {
                    res[i] = new FileInputStream(new File(v[i]));
                }
                catch (FileNotFoundException e) {
                    System.out.println("Could not find the file " + v[i]);
                    System.exit(0);
                }
            }
            ++i;
        }
        return res;
    }

    public InputStream getInputStream(String key, InputStream defaultStream) {
        InputStream stream = this.getInputStream(key);
        if (stream != null) {
            return stream;
        }
        return defaultStream;
    }
}

