/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicAutomata;
import dk.brics.automaton.State;
import dk.brics.automaton.StatePair;
import dk.brics.automaton.Transition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BasicOperations {
    private BasicOperations() {
    }

    public static Automaton concatenate(Automaton automaton, Automaton automaton2) {
        if (automaton.isSingleton() && automaton2.isSingleton()) {
            return BasicAutomata.makeString(automaton.singleton + automaton2.singleton);
        }
        if (automaton == automaton2) {
            automaton = automaton.cloneExpanded();
            automaton2 = automaton2.cloneExpanded();
        } else {
            automaton = automaton.cloneExpandedIfRequired();
            automaton2 = automaton2.cloneExpandedIfRequired();
        }
        for (State state : automaton.getAcceptStates()) {
            state.accept = false;
            state.addEpsilon(automaton2.initial);
        }
        automaton.deterministic = false;
        automaton.clearHashCode();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    public static Automaton concatenate(List<Automaton> list) {
        Automaton automaton4;
        HashSet<Integer> hashSet;
        if (list.isEmpty()) {
            return BasicAutomata.makeEmptyString();
        }
        boolean bl = true;
        for (Automaton object : list) {
            if (object.isSingleton()) continue;
            bl = false;
            break;
        }
        if (bl) {
            hashSet = new StringBuilder();
            for (Automaton automaton2 : list) {
                ((StringBuilder)((Object)hashSet)).append(automaton2.singleton);
            }
            return BasicAutomata.makeString(((StringBuilder)((Object)hashSet)).toString());
        }
        for (Automaton automaton3 : list) {
            if (!automaton3.isEmpty()) continue;
            return BasicAutomata.makeEmpty();
        }
        hashSet = new HashSet<Integer>();
        for (Automaton automaton4 : list) {
            hashSet.add(System.identityHashCode(automaton4));
        }
        boolean bl2 = hashSet.size() != list.size();
        automaton4 = list.get(0);
        automaton4 = bl2 ? automaton4.cloneExpanded() : automaton4.cloneExpandedIfRequired();
        Set<State> set = automaton4.getAcceptStates();
        boolean bl3 = true;
        for (Automaton automaton5 : list) {
            if (bl3) {
                bl3 = false;
                continue;
            }
            if (automaton5.isEmptyString()) continue;
            Automaton automaton6 = automaton5;
            automaton6 = bl2 ? automaton6.cloneExpanded() : automaton6.cloneExpandedIfRequired();
            Set<State> set2 = automaton6.getAcceptStates();
            for (State state : set) {
                state.accept = false;
                state.addEpsilon(automaton6.initial);
                if (!state.accept) continue;
                set2.add(state);
            }
            set = set2;
        }
        automaton4.deterministic = false;
        automaton4.clearHashCode();
        automaton4.checkMinimizeAlways();
        return automaton4;
    }

    public static Automaton optional(Automaton automaton) {
        automaton = automaton.cloneExpandedIfRequired();
        State state = new State();
        state.addEpsilon(automaton.initial);
        state.accept = true;
        automaton.initial = state;
        automaton.deterministic = false;
        automaton.clearHashCode();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    public static Automaton repeat(Automaton automaton) {
        automaton = automaton.cloneExpanded();
        State state = new State();
        state.accept = true;
        state.addEpsilon(automaton.initial);
        for (State state2 : automaton.getAcceptStates()) {
            state2.addEpsilon(state);
        }
        automaton.initial = state;
        automaton.deterministic = false;
        automaton.clearHashCode();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    public static Automaton repeat(Automaton automaton, int n) {
        if (n == 0) {
            return BasicOperations.repeat(automaton);
        }
        ArrayList<Automaton> arrayList = new ArrayList<Automaton>();
        while (n-- > 0) {
            arrayList.add(automaton);
        }
        arrayList.add(BasicOperations.repeat(automaton));
        return BasicOperations.concatenate(arrayList);
    }

    public static Automaton repeat(Automaton automaton, int n, int n2) {
        Object object;
        Automaton automaton2;
        if (n > n2) {
            return BasicAutomata.makeEmpty();
        }
        n2 -= n;
        automaton.expandSingleton();
        if (n == 0) {
            automaton2 = BasicAutomata.makeEmptyString();
        } else if (n == 1) {
            automaton2 = automaton.clone();
        } else {
            object = new ArrayList();
            while (n-- > 0) {
                object.add((Automaton)automaton);
            }
            automaton2 = BasicOperations.concatenate(object);
        }
        if (n2 > 0) {
            object = automaton.clone();
            while (--n2 > 0) {
                Automaton automaton3 = automaton.clone();
                for (State state : automaton3.getAcceptStates()) {
                    state.addEpsilon(((Automaton)object).initial);
                }
                object = automaton3;
            }
            for (State state : automaton2.getAcceptStates()) {
                state.addEpsilon(((Automaton)object).initial);
            }
            automaton2.deterministic = false;
            automaton2.clearHashCode();
            automaton2.checkMinimizeAlways();
        }
        return automaton2;
    }

    public static Automaton complement(Automaton automaton) {
        automaton = automaton.cloneExpandedIfRequired();
        automaton.determinize();
        automaton.totalize();
        for (State state : automaton.getStates()) {
            state.accept = !state.accept;
        }
        automaton.removeDeadTransitions();
        return automaton;
    }

    public static Automaton minus(Automaton automaton, Automaton automaton2) {
        if (automaton.isEmpty() || automaton == automaton2) {
            return BasicAutomata.makeEmpty();
        }
        if (automaton2.isEmpty()) {
            return automaton.cloneIfRequired();
        }
        if (automaton.isSingleton()) {
            if (automaton2.run(automaton.singleton)) {
                return BasicAutomata.makeEmpty();
            }
            return automaton.cloneIfRequired();
        }
        return BasicOperations.intersection(automaton, automaton2.complement());
    }

    public static Automaton intersection(Automaton automaton, Automaton automaton2) {
        State state;
        if (automaton.isSingleton()) {
            if (automaton2.run(automaton.singleton)) {
                return automaton.cloneIfRequired();
            }
            return BasicAutomata.makeEmpty();
        }
        if (automaton2.isSingleton()) {
            if (automaton.run(automaton2.singleton)) {
                return automaton2.cloneIfRequired();
            }
            return BasicAutomata.makeEmpty();
        }
        if (automaton == automaton2) {
            return automaton.cloneIfRequired();
        }
        Transition[][] transitionArray = Automaton.getSortedTransitions(automaton.getStates());
        Transition[][] transitionArray2 = Automaton.getSortedTransitions(automaton2.getStates());
        Automaton automaton3 = new Automaton();
        LinkedList<StatePair> linkedList = new LinkedList<StatePair>();
        HashMap<StatePair, StatePair> hashMap = new HashMap<StatePair, StatePair>();
        automaton3.initial = state = new State();
        StatePair statePair = new StatePair(state, automaton.initial, automaton2.initial);
        linkedList.add(statePair);
        hashMap.put(statePair, statePair);
        while (linkedList.size() > 0) {
            statePair = (StatePair)linkedList.removeFirst();
            statePair.s.accept = statePair.s1.accept && statePair.s2.accept;
            Transition[] transitionArray3 = transitionArray[statePair.s1.number];
            Transition[] transitionArray4 = transitionArray2[statePair.s2.number];
            int n = 0;
            for (int i = 0; i < transitionArray3.length; ++i) {
                while (n < transitionArray4.length && transitionArray4[n].max < transitionArray3[i].min) {
                    ++n;
                }
                for (int j = n; j < transitionArray4.length && transitionArray3[i].max >= transitionArray4[j].min; ++j) {
                    if (transitionArray4[j].max < transitionArray3[i].min) continue;
                    StatePair statePair2 = new StatePair(transitionArray3[i].to, transitionArray4[j].to);
                    StatePair statePair3 = (StatePair)hashMap.get(statePair2);
                    if (statePair3 == null) {
                        statePair2.s = new State();
                        linkedList.add(statePair2);
                        hashMap.put(statePair2, statePair2);
                        statePair3 = statePair2;
                    }
                    char c = transitionArray3[i].min > transitionArray4[j].min ? transitionArray3[i].min : transitionArray4[j].min;
                    char c2 = transitionArray3[i].max < transitionArray4[j].max ? transitionArray3[i].max : transitionArray4[j].max;
                    statePair.s.transitions.add(new Transition(c, c2, statePair3.s));
                }
            }
        }
        automaton3.deterministic = automaton.deterministic && automaton2.deterministic;
        automaton3.removeDeadTransitions();
        automaton3.checkMinimizeAlways();
        return automaton3;
    }

    public static boolean subsetOf(Automaton automaton, Automaton automaton2) {
        if (automaton == automaton2) {
            return true;
        }
        if (automaton.isSingleton()) {
            if (automaton2.isSingleton()) {
                return automaton.singleton.equals(automaton2.singleton);
            }
            return automaton2.run(automaton.singleton);
        }
        automaton2.determinize();
        Transition[][] transitionArray = Automaton.getSortedTransitions(automaton.getStates());
        Transition[][] transitionArray2 = Automaton.getSortedTransitions(automaton2.getStates());
        LinkedList<StatePair> linkedList = new LinkedList<StatePair>();
        HashSet<StatePair> hashSet = new HashSet<StatePair>();
        StatePair statePair = new StatePair(automaton.initial, automaton2.initial);
        linkedList.add(statePair);
        hashSet.add(statePair);
        while (linkedList.size() > 0) {
            statePair = (StatePair)linkedList.removeFirst();
            if (statePair.s1.accept && !statePair.s2.accept) {
                return false;
            }
            Transition[] transitionArray3 = transitionArray[statePair.s1.number];
            Transition[] transitionArray4 = transitionArray2[statePair.s2.number];
            int n = 0;
            for (int i = 0; i < transitionArray3.length; ++i) {
                while (n < transitionArray4.length && transitionArray4[n].max < transitionArray3[i].min) {
                    ++n;
                }
                char c = transitionArray3[i].min;
                char c2 = transitionArray3[i].max;
                for (int j = n; j < transitionArray4.length && transitionArray3[i].max >= transitionArray4[j].min; ++j) {
                    if (transitionArray4[j].min > c) {
                        return false;
                    }
                    if (transitionArray4[j].max < '\uffff') {
                        c = transitionArray4[j].max + '\u0001';
                    } else {
                        c = '\uffff';
                        c2 = '\u0000';
                    }
                    StatePair statePair2 = new StatePair(transitionArray3[i].to, transitionArray4[j].to);
                    if (hashSet.contains(statePair2)) continue;
                    linkedList.add(statePair2);
                    hashSet.add(statePair2);
                }
                if (c > c2) continue;
                return false;
            }
        }
        return true;
    }

    public static Automaton union(Automaton automaton, Automaton automaton2) {
        if (automaton.isSingleton() && automaton2.isSingleton() && automaton.singleton.equals(automaton2.singleton) || automaton == automaton2) {
            return automaton.cloneIfRequired();
        }
        if (automaton == automaton2) {
            automaton = automaton.cloneExpanded();
            automaton2 = automaton2.cloneExpanded();
        } else {
            automaton = automaton.cloneExpandedIfRequired();
            automaton2 = automaton2.cloneExpandedIfRequired();
        }
        State state = new State();
        state.addEpsilon(automaton.initial);
        state.addEpsilon(automaton2.initial);
        automaton.initial = state;
        automaton.deterministic = false;
        automaton.clearHashCode();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    public static Automaton union(Collection<Automaton> collection) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Automaton serializable2 : collection) {
            hashSet.add(System.identityHashCode(serializable2));
        }
        boolean bl = hashSet.size() != collection.size();
        State state = new State();
        for (Automaton automaton : collection) {
            if (automaton.isEmpty()) continue;
            Automaton automaton2 = automaton;
            automaton2 = bl ? automaton2.cloneExpanded() : automaton2.cloneExpandedIfRequired();
            state.addEpsilon(automaton2.initial);
        }
        Automaton automaton = new Automaton();
        automaton.initial = state;
        automaton.deterministic = false;
        automaton.clearHashCode();
        automaton.checkMinimizeAlways();
        return automaton;
    }

    public static void determinize(Automaton automaton) {
        if (automaton.deterministic || automaton.isSingleton()) {
            return;
        }
        HashSet<State> hashSet = new HashSet<State>();
        hashSet.add(automaton.initial);
        BasicOperations.determinize(automaton, hashSet);
    }

    static void determinize(Automaton automaton, Set<State> set) {
        char[] cArray = automaton.getStartPoints();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        HashMap<Object, State> hashMap2 = new HashMap<Object, State>();
        hashMap.put(set, set);
        linkedList.add(set);
        automaton.initial = new State();
        hashMap2.put(set, automaton.initial);
        while (linkedList.size() > 0) {
            Set set2 = (Set)linkedList.removeFirst();
            State state = (State)hashMap2.get(set2);
            for (Serializable serializable : set2) {
                if (!((State)serializable).accept) continue;
                state.accept = true;
                break;
            }
            for (int i = 0; i < cArray.length; ++i) {
                Serializable serializable;
                serializable = new HashSet();
                for (State state2 : set2) {
                    for (Transition transition : state2.transitions) {
                        if (transition.min > cArray[i] || cArray[i] > transition.max) continue;
                        serializable.add(transition.to);
                    }
                }
                if (!hashMap.containsKey(serializable)) {
                    hashMap.put(serializable, serializable);
                    linkedList.add(serializable);
                    hashMap2.put(serializable, new State());
                }
                State state3 = (State)hashMap2.get(serializable);
                char c = cArray[i];
                char c2 = i + 1 < cArray.length ? (char)((char)(cArray[i + 1] - '\u0001')) : (char)'\uffff';
                state.transitions.add(new Transition(c, c2, state3));
            }
        }
        automaton.deterministic = true;
        automaton.removeDeadTransitions();
    }

    /*
     * WARNING - void declaration
     */
    public static void addEpsilons(Automaton automaton, Collection<StatePair> collection) {
        HashSet<State> hashSet;
        automaton.expandSingleton();
        HashMap<State, Object> hashMap = new HashMap<State, Object>();
        HashMap hashMap2 = new HashMap();
        for (StatePair object2 : collection) {
            void var7_8;
            hashSet = (HashSet<State>)hashMap.get(object2.s1);
            if (hashSet == null) {
                hashSet = new HashSet<State>();
                hashMap.put(object2.s1, hashSet);
            }
            hashSet.add(object2.s2);
            HashSet hashSet2 = (HashSet)hashMap2.get(object2.s2);
            if (hashSet2 == null) {
                HashSet hashSet3 = new HashSet();
                hashMap2.put(object2.s2, hashSet3);
            }
            var7_8.add(object2.s1);
        }
        LinkedList<StatePair> linkedList = new LinkedList<StatePair>(collection);
        HashSet<StatePair> hashSet4 = new HashSet<StatePair>(collection);
        while (!linkedList.isEmpty()) {
            hashSet = (StatePair)linkedList.removeFirst();
            hashSet4.remove(hashSet);
            HashSet hashSet5 = (HashSet)hashMap.get(((StatePair)((Object)hashSet)).s2);
            HashSet hashSet6 = (HashSet)hashMap2.get(((StatePair)((Object)hashSet)).s1);
            if (hashSet5 == null) continue;
            for (State state : hashSet5) {
                StatePair statePair = new StatePair(((StatePair)((Object)hashSet)).s1, state);
                if (collection.contains(statePair)) continue;
                collection.add(statePair);
                ((HashSet)hashMap.get(((StatePair)((Object)hashSet)).s1)).add(state);
                ((HashSet)hashMap2.get(state)).add(((StatePair)((Object)hashSet)).s1);
                linkedList.add(statePair);
                hashSet4.add(statePair);
                if (hashSet6 == null) continue;
                for (State state2 : hashSet6) {
                    StatePair statePair2 = new StatePair(state2, ((StatePair)((Object)hashSet)).s1);
                    if (hashSet4.contains(statePair2)) continue;
                    linkedList.add(statePair2);
                    hashSet4.add(statePair2);
                }
            }
        }
        for (StatePair statePair : collection) {
            statePair.s1.addEpsilon(statePair.s2);
        }
        automaton.deterministic = false;
        automaton.clearHashCode();
        automaton.checkMinimizeAlways();
    }

    public static boolean isEmptyString(Automaton automaton) {
        if (automaton.isSingleton()) {
            return automaton.singleton.length() == 0;
        }
        return automaton.initial.accept && automaton.initial.transitions.isEmpty();
    }

    public static boolean isEmpty(Automaton automaton) {
        if (automaton.isSingleton()) {
            return false;
        }
        return !automaton.initial.accept && automaton.initial.transitions.isEmpty();
    }

    public static boolean isTotal(Automaton automaton) {
        if (automaton.isSingleton()) {
            return false;
        }
        if (automaton.initial.accept && automaton.initial.transitions.size() == 1) {
            Transition transition = automaton.initial.transitions.iterator().next();
            return transition.to == automaton.initial && transition.min == '\u0000' && transition.max == '\uffff';
        }
        return false;
    }

    public static String getShortestExample(Automaton automaton, boolean bl) {
        if (automaton.isSingleton()) {
            if (bl) {
                return automaton.singleton;
            }
            if (automaton.singleton.length() > 0) {
                return "";
            }
            return "\u0000";
        }
        return BasicOperations.getShortestExample(automaton.getInitialState(), bl);
    }

    static String getShortestExample(State state, boolean bl) {
        HashMap<State, String> hashMap = new HashMap<State, String>();
        LinkedList<State> linkedList = new LinkedList<State>();
        hashMap.put(state, "");
        linkedList.add(state);
        String string = null;
        while (!linkedList.isEmpty()) {
            State state2 = (State)linkedList.removeFirst();
            String string2 = (String)hashMap.get(state2);
            if (state2.accept == bl) {
                if (string != null && string2.length() >= string.length() && (string2.length() != string.length() || string2.compareTo(string) >= 0)) continue;
                string = string2;
                continue;
            }
            for (Transition transition : state2.getTransitions()) {
                String string3 = (String)hashMap.get(transition.to);
                String string4 = string2 + transition.min;
                if (string3 != null && (string3.length() != string4.length() || string4.compareTo(string3) >= 0)) continue;
                if (string3 == null) {
                    linkedList.addLast(transition.to);
                }
                hashMap.put(transition.to, string4);
            }
        }
        return string;
    }

    public static boolean run(Automaton automaton, String string) {
        if (automaton.isSingleton()) {
            return string.equals(automaton.singleton);
        }
        if (automaton.deterministic) {
            State state = automaton.initial;
            for (int i = 0; i < string.length(); ++i) {
                State state2 = state.step(string.charAt(i));
                if (state2 == null) {
                    return false;
                }
                state = state2;
            }
            return state.accept;
        }
        Set<State> set = automaton.getStates();
        Automaton.setStateNumbers(set);
        LinkedList<State> linkedList = new LinkedList<State>();
        Object object = new LinkedList();
        BitSet bitSet = new BitSet(set.size());
        Serializable serializable = new BitSet(set.size());
        linkedList.add(automaton.initial);
        ArrayList<State> arrayList = new ArrayList<State>();
        boolean bl = automaton.initial.accept;
        for (int i = 0; i < string.length(); ++i) {
            Serializable serializable22;
            char c = string.charAt(i);
            bl = false;
            ((LinkedList)object).clear();
            ((BitSet)serializable).clear();
            for (Serializable serializable22 : linkedList) {
                arrayList.clear();
                serializable22.step(c, arrayList);
                for (State state : arrayList) {
                    if (state.accept) {
                        bl = true;
                    }
                    if (((BitSet)serializable).get(state.number)) continue;
                    ((BitSet)serializable).set(state.number);
                    ((LinkedList)object).add(state);
                }
            }
            LinkedList<State> linkedList2 = linkedList;
            linkedList = object;
            object = linkedList2;
            serializable22 = bitSet;
            bitSet = serializable;
            serializable = serializable22;
        }
        return bl;
    }
}

