/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.entitytagger.networking;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import martin.common.compthreads.Problem;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.entitytagger.Mention;
import uk.ac.man.entitytagger.matching.Matcher;

public class SimpleServerWorker
implements Problem<Object> {
    private Socket s;
    private Matcher matcher;
    private Map<Integer, List<Mention>> cache;
    private Semaphore cacheSem;

    public SimpleServerWorker(Socket s, Matcher matcher, Map<Integer, List<Mention>> cache, Semaphore cacheSem) {
        this.s = s;
        this.matcher = matcher;
        this.cache = cache;
        this.cacheSem = cacheSem;
    }

    @Override
    public Object compute() {
        try {
            ObjectInputStream inputStream = new ObjectInputStream(new BufferedInputStream(this.s.getInputStream()));
            String text = (String)inputStream.readObject();
            boolean hasDoc = inputStream.readBoolean();
            Document doc = hasDoc ? (Document)inputStream.readObject() : null;
            List<Mention> mentions = null;
            if (this.cache != null) {
                int hash = text.hashCode();
                String docid = doc != null ? doc.getID() : null;
                try {
                    this.cacheSem.acquire();
                    if (this.cache.containsKey(hash) && this.cache.get(hash) != null) {
                        List<Mention> ms = this.cache.get(hash);
                        mentions = new ArrayList<Mention>(ms.size());
                        for (Mention m : ms) {
                            Mention m2 = m.clone();
                            m2.setDocid(docid);
                            mentions.add(m2);
                        }
                    }
                    this.cacheSem.release();
                    if (mentions == null) {
                        mentions = doc != null ? this.matcher.match(text, doc) : this.matcher.match(text, "tempid");
                        this.cacheSem.acquire();
                        if (mentions != null) {
                            this.cache.put(hash, mentions);
                        }
                        this.cacheSem.release();
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                    e.printStackTrace();
                    System.exit(-1);
                }
            } else {
                mentions = doc != null ? this.matcher.match(text, doc) : this.matcher.match(text, "tempid");
            }
            ObjectOutputStream outputStream = new ObjectOutputStream(new BufferedOutputStream(this.s.getOutputStream()));
            outputStream.writeObject(mentions);
            outputStream.flush();
            this.s.close();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
        return null;
    }
}

