/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.entitytagger.matching.matchers;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.entitytagger.Mention;
import uk.ac.man.entitytagger.matching.Matcher;

public class PrecomputedMatcher
extends Matcher {
    private Map<String, List<Mention>> map;
    private Connection conn;
    private String table;

    public PrecomputedMatcher(File file) {
        this(file, null, null);
    }

    public PrecomputedMatcher(Connection conn, String table) {
        this.conn = conn;
        this.table = table;
    }

    public PrecomputedMatcher(File file, Set<String> validDocuments, String restrictPostfix) {
        this.map = Mention.loadFromFileToHash(file, validDocuments, restrictPostfix, null);
    }

    public List<Mention> matchByID(String id) {
        if (this.map != null) {
            if (this.map.containsKey(id)) {
                return this.map.get(id);
            }
            return new ArrayList<Mention>(0);
        }
        if (this.conn != null) {
            LinkedList<Mention> mentions = new LinkedList<Mention>();
            try {
                ResultSet rs = this.conn.createStatement().executeQuery("SELECT entity,start,end,text,comment FROM " + this.table + " WHERE document='" + id + "'");
                while (rs.next()) {
                    String[] ids = rs.getString(1).split("\\|");
                    int start = rs.getInt(2);
                    int end = rs.getInt(3);
                    String term = rs.getString(4);
                    String comment = rs.getString(5);
                    Mention m = new Mention(ids, start, end, term);
                    m.setComment(comment);
                    m.setDocid(id);
                    mentions.add(m);
                }
                rs.close();
            }
            catch (Exception e) {
                System.err.println(e);
                e.printStackTrace();
                System.exit(-1);
            }
            return mentions;
        }
        return null;
    }

    @Override
    public List<Mention> match(String text, Document doc) {
        if (doc == null || doc.getID() == null || doc.getID().length() == 0) {
            throw new IllegalStateException("A PrecomputedMatcher must be called with a document to resolve the ID");
        }
        List<Mention> matches = this.matchByID(doc.getID());
        return matches;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public Map<String, List<Mention>> getStoredData() {
        return this.map;
    }
}

