/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.entitytagger.matching.matchers;

import dk.brics.automaton.CustomAutomatonMatcher;
import dk.brics.automaton.CustomRunAutomaton;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.entitytagger.Mention;
import uk.ac.man.entitytagger.matching.Matcher;

public class AutomatonMatcher
extends Matcher {
    private CustomRunAutomaton[] automatons;
    private boolean ignoreCase;

    public static AutomatonMatcher loadMatcher(File file) {
        try {
            ObjectInputStream inStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            int size = inStream.readInt();
            boolean ignoreCase = inStream.readBoolean();
            CustomRunAutomaton[] automatons = new CustomRunAutomaton[size];
            for (int i = 0; i < size; ++i) {
                automatons[i] = (CustomRunAutomaton)inStream.readObject();
            }
            inStream.close();
            return new AutomatonMatcher(automatons, ignoreCase);
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public static AutomatonMatcher[] loadMatchers(File[] files) {
        AutomatonMatcher[] matchers = new AutomatonMatcher[files.length];
        for (int i = 0; i < matchers.length; ++i) {
            matchers[i] = AutomatonMatcher.loadMatcher(files[i]);
        }
        return matchers;
    }

    public AutomatonMatcher(CustomRunAutomaton[] automatons, boolean ignoreCase) {
        this.automatons = automatons;
        this.ignoreCase = ignoreCase;
    }

    public void store(File file) {
        try {
            ObjectOutputStream dataStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            dataStream.writeInt(this.automatons.length);
            dataStream.writeBoolean(this.ignoreCase);
            for (int i = 0; i < this.automatons.length; ++i) {
                dataStream.writeObject(this.automatons[i]);
            }
            dataStream.close();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public List<Mention> match(String text, Document doc) {
        ArrayList<Mention> matches = new ArrayList<Mention>();
        String docID = doc != null ? doc.getID() : null;
        String matchText = this.ignoreCase ? text.toLowerCase() : text;
        for (int i = 0; i < this.automatons.length; ++i) {
            CustomAutomatonMatcher matcher = this.automatons[i].newCustomMatcher(matchText);
            while (matcher.findWithDelimitedID('\u25b2')) {
                int start = matcher.start();
                int end = matcher.end();
                ArrayList<String> ids = matcher.getMatchIDs();
                String matchedText = text.substring(start, end);
                Mention match = new Mention(ids.toArray(new String[0]), start, end, matchedText);
                match.setDocid(docID);
                if (!Matcher.isValidMatch(text, match) || doc != null && !doc.isValid(start, end)) continue;
                matches.add(match);
            }
        }
        return matches;
    }

    @Override
    public int size() {
        return this.automatons.length;
    }

    public CustomRunAutomaton[] getAutomatons() {
        return this.automatons;
    }
}

