/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.entitytagger.matching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import martin.common.Tuple;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.entitytagger.Mention;

public abstract class Matcher {
    public abstract List<Mention> match(String var1, Document var2);

    public int size() {
        throw new IllegalStateException("Matcher.size() is not implemented");
    }

    protected static boolean isValidMatch(String text, Mention match) {
        char c;
        int s = match.getStart();
        int e = match.getEnd();
        if (s > 0 && Character.isLetterOrDigit(c = text.charAt(s - 1)) && c != '>' && c != '<') {
            return false;
        }
        return e >= text.length() - 1 || !Character.isLetterOrDigit(c = text.charAt(e)) || c == '>' || c == '<';
    }

    public static List<Mention> disambiguate(String text, List<Mention> matches, Disambiguation mode) {
        int i;
        Mention m2;
        if (mode == Disambiguation.OFF || matches == null || matches.size() == 0) {
            return matches;
        }
        ArrayList<Mention> res = new ArrayList<Mention>(matches);
        block0: for (int i2 = 0; i2 < res.size(); ++i2) {
            Mention m1 = (Mention)res.get(i2);
            int s1 = m1.getStart();
            int e1 = m1.getEnd();
            for (int j = i2 + 1; j < res.size(); ++j) {
                m2 = (Mention)res.get(j);
                int s2 = m2.getStart();
                int e2 = m2.getEnd();
                if (!Mention.overlaps(m1, m2)) continue;
                if (e2 - s2 < e1 - s1) {
                    res.remove(j);
                    --j;
                    continue;
                }
                if (e1 - s1 >= e2 - s2) continue;
                res.remove(i2);
                --i2;
                continue block0;
            }
        }
        if (mode == Disambiguation.ON_LONGEST_ONLY || matches.size() > 2000) {
            return res;
        }
        boolean[] isClear = new boolean[res.size()];
        for (i = 0; i < isClear.length; ++i) {
            isClear[i] = !((Mention)res.get(i)).isAmbigous();
        }
        for (i = 0; i < isClear.length; ++i) {
            Mention m1 = (Mention)res.get(i);
            for (int j = i + 1; j < res.size(); ++j) {
                Mention m22 = (Mention)res.get(j);
                if (!Mention.overlaps(m1, m22)) continue;
                isClear[i] = false;
                isClear[j] = false;
            }
        }
        for (i = 0; i < res.size(); ++i) {
            Mention m1 = (Mention)res.get(i);
            if (m1 == null || isClear[i]) continue;
            int s1 = m1.getStart();
            for (int j = 0; j < res.size(); ++j) {
                m2 = (Mention)res.get(j);
                if (m2 == null || m2.getStart() >= s1 && mode != Disambiguation.ON_WHOLE || m2.getIds().length <= 0 || !m1.containsID(m2.getIds()[0]) || !isClear[j]) continue;
                isClear[i] = true;
                String id = m2.getIds()[0];
                m1.disambiguate(id);
                for (int k = 0; k < res.size(); ++k) {
                    if (res.get(k) != null && Mention.overlaps(m1, (Mention)res.get(k)) && k != i) {
                        res.set(k, null);
                    }
                    if (res.get(k) == null || mode != Disambiguation.ON_EARLIER || !m1.getText().equals(((Mention)res.get(k)).getText()) || !((Mention)res.get(k)).containsID(id)) continue;
                    ((Mention)res.get(k)).disambiguate(id);
                    isClear[k] = true;
                }
            }
        }
        for (i = 0; i < res.size(); ++i) {
            if (res.get(i) != null) continue;
            res.remove(i--);
        }
        return res;
    }

    public static List<Mention> combineMatches(List<Mention> matches) {
        ArrayList<Mention> res = new ArrayList<Mention>();
        boolean[] removed = new boolean[matches.size()];
        for (int i = 0; i < matches.size(); ++i) {
            int j;
            if (removed[i]) continue;
            Mention m1 = matches.get(i);
            ArrayList<Tuple<String, Double>> sp = new ArrayList<Tuple<String, Double>>();
            String[] ids_ = m1.getIdsWithLineNumbers();
            Double[] probs_ = m1.getProbabilities();
            for (j = 0; j < ids_.length; ++j) {
                double d = probs_ != null && probs_[j] != null ? probs_[j] : 0.0;
                sp.add(new Tuple<String, Double>(ids_[j], d));
            }
            for (j = i + 1; j < matches.size(); ++j) {
                if (matches.get(j).getStart() != m1.getStart() || matches.get(j).getEnd() != m1.getEnd()) continue;
                ids_ = matches.get(j).getIdsWithLineNumbers();
                probs_ = matches.get(j).getProbabilities();
                for (int k = 0; k < ids_.length; ++k) {
                    double d = probs_ != null && probs_[k] != null ? probs_[k] : 0.0;
                    sp.add(new Tuple<String, Double>(ids_[k], d));
                }
                removed[j] = true;
            }
            String[] ids = new String[sp.size()];
            Double[] probs = new Double[sp.size()];
            double total = 0.0;
            for (Tuple tuple : sp) {
                total += ((Double)tuple.getB()).doubleValue();
            }
            for (int j2 = 0; j2 < sp.size(); ++j2) {
                ids[j2] = (String)((Tuple)sp.get(j2)).getA();
                probs[j2] = total > 0.0 ? (Double)((Tuple)sp.get(j2)).getB() / total : 0.0;
            }
            Mention m = new Mention(ids, m1.getStart(), m1.getEnd(), m1.getText());
            m.setDocid(m1.getDocid());
            m.setComment(m1.getComment());
            m.setProbabilities(probs);
            m.sortIDsByProbabilities();
            res.add(m);
        }
        return res;
    }

    public List<Mention> match(String text) {
        return this.match(text, (Document)null);
    }

    public List<Mention> match(String text, String documentID) {
        if (documentID == null) {
            return this.match(text, (Document)null);
        }
        Document d = new Document(documentID, null, null, null, text, null, null, null, null, null, null, null, null, null, null);
        return this.match(text, d);
    }

    protected static void performAcronymResolution(Document doc, String text, List<Mention> matches) {
        HashMap<String, Mention> acronyms = new HashMap<String, Mention>();
        String regexp = "[ABCDEFGHIJKLMNOPQRSTUVWXYZ][ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789\\-\\.]+";
        String docID = doc != null ? doc.getID() : null;
        for (int i = 0; i < matches.size(); ++i) {
            String abb;
            int ncp;
            Mention m = matches.get(i);
            int s = m.getStart();
            int e = m.getEnd();
            if (s == -1 || e == -1 || e + 1 >= text.length() || text.charAt(e) != ' ' || text.charAt(e + 1) != '(' || (ncp = text.indexOf(41, e + 2)) <= -1 || ncp >= text.length() || !(abb = text.substring(e + 2, ncp)).matches(regexp) || abb.length() >= 5) continue;
            Mention a = new Mention(m.getIds(), e + 2, ncp, abb);
            a.setComment("abbrev main (" + m.getText() + ")");
            a.setDocid(m.getDocid());
            boolean overlaps = false;
            for (int j = 0; j < matches.size(); ++j) {
                if (!matches.get(j).overlaps(a)) continue;
                overlaps = true;
            }
            if (acronyms.containsKey(abb) || overlaps) continue;
            acronyms.put(abb, a);
        }
        for (Mention m : acronyms.values()) {
            Pattern p = Pattern.compile("\\b" + m.getText() + "\\b");
            java.util.regex.Matcher matcher = p.matcher(text);
            int numMatched = 0;
            while (matcher.find()) {
                int s = matcher.start();
                int e = matcher.end();
                if (s <= m.getEnd()) continue;
                Mention nm = new Mention(m.getIds(), s, e, text.substring(s, e));
                nm.setComment("abbrev sec");
                nm.setDocid(m.getDocid());
                boolean add = true;
                for (int i = 0; i < matches.size(); ++i) {
                    if (!matches.get(i).overlaps(nm)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                nm.setDocid(docID);
                matches.add(nm);
                ++numMatched;
            }
            if (numMatched <= 0) continue;
            m.setDocid(docID);
            matches.add(m);
        }
    }

    public static void detectEnumerations(List<Mention> mentions, String text) {
        int nextGroup = 0;
        Mention.sort(mentions);
        HashMap<Integer, Integer> matchToGroupMap = new HashMap<Integer, Integer>();
        HashSet<Integer> validGroups = new HashSet<Integer>();
        Pattern cP = Pattern.compile("^[,/] ?$");
        Pattern aP = Pattern.compile("^,? and $");
        for (int i = 0; i < mentions.size() - 1; ++i) {
            Integer currentGroup;
            Mention m = mentions.get(i);
            Mention nm = mentions.get(i + 1);
            Integer n = currentGroup = matchToGroupMap.containsKey(i) ? (Integer)matchToGroupMap.get(i) : null;
            if (m.getEnd() < nm.getStart()) {
                String t = text.substring(m.getEnd(), nm.getStart());
                if (cP.matcher(t).matches()) {
                    if (currentGroup == null) {
                        currentGroup = nextGroup++;
                    }
                    matchToGroupMap.put(i, currentGroup);
                    matchToGroupMap.put(i + 1, currentGroup);
                    validGroups.add(currentGroup);
                }
                if (!aP.matcher(t).matches()) continue;
                if (currentGroup == null) {
                    currentGroup = nextGroup++;
                }
                matchToGroupMap.put(i, currentGroup);
                matchToGroupMap.put(i + 1, currentGroup);
                validGroups.add(currentGroup);
                continue;
            }
            if (m.getStart() <= nm.getEnd()) continue;
            throw new IllegalStateException("Mentions were not sorted!");
        }
        Iterator iterator = matchToGroupMap.keySet().iterator();
        while (iterator.hasNext()) {
            int k = (Integer)iterator.next();
            mentions.get(k).setComment("group: " + matchToGroupMap.get(k) + ", valid: " + validGroups.contains(matchToGroupMap.get(k)));
        }
    }

    public List<Mention> match(Document d) {
        return this.match(d.toString(), d);
    }

    public static enum Disambiguation {
        OFF,
        ON_EARLIER,
        ON_WHOLE,
        ON_LONGEST_ONLY;

    }
}

