/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.entitytagger.generate;

import dk.brics.automaton.RegExp;
import java.sql.PreparedStatement;
import java.util.Set;
import java.util.regex.Pattern;

public class DictionaryEntry {
    private String id;
    private Pattern pattern = null;
    private String regexp = "";
    private String comment = null;

    public DictionaryEntry(String id) {
        this.id = id;
    }

    public DictionaryEntry(String id, String comment) {
        this.id = id;
        this.comment = comment;
    }

    public String toString() {
        if (this.comment != null) {
            return this.id + "\t" + this.getRegexp() + "\t" + this.comment;
        }
        return this.id + "\t" + this.getRegexp() + "\t";
    }

    public String getId() {
        return this.id;
    }

    private void reset() {
        this.pattern = null;
    }

    public Pattern getPattern() {
        if (this.pattern != null) {
            return this.pattern;
        }
        this.pattern = Pattern.compile(this.getRegexp());
        return this.pattern;
    }

    String getRegexp() {
        return this.regexp;
    }

    public void addPattern(String regexp) {
        this.reset();
        this.regexp = this.regexp.length() > 0 ? this.regexp + "|(" + regexp + ")" : this.regexp + "(" + regexp + ")";
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getComment() {
        return this.comment;
    }

    public Set<String> convertRegexpToVariants() {
        String r = this.getRegexp();
        Set res = new RegExp(r).toAutomaton().getFiniteStrings();
        return res;
    }

    public void saveVariantsToDB(PreparedStatement pstmt, Set<String> stopList) {
        Set<String> names = this.convertRegexpToVariants();
        try {
            for (String n : names) {
                if (stopList != null && (stopList.contains(n) || stopList.contains(n.toLowerCase()) && n.substring(1).equals(n.substring(1).toLowerCase()))) continue;
                pstmt.setString(1, this.id);
                pstmt.setString(2, n);
                if (this.comment != null) {
                    pstmt.setString(3, this.comment);
                } else {
                    pstmt.setNull(3, 0);
                }
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

