/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.entitytagger.evaluate;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import martin.common.ArgParser;
import martin.common.compthreads.IteratorBasedMaster;
import martin.common.r.RGraphics;
import uk.ac.man.documentparser.DocumentParser;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.documentparser.input.DocumentIterator;
import uk.ac.man.entitytagger.Mention;
import uk.ac.man.entitytagger.evaluate.EvaluateProblem;
import uk.ac.man.entitytagger.evaluate.Result;
import uk.ac.man.entitytagger.matching.matchers.ACIDMatcher;

public class Evaluate {
    Result[] process(Map<String, List<Mention>> mainTags, Map<String, Map<String, List<Tag>>> mainTagsByDoc, Map<String, List<Mention>> refTags, Map<String, Map<String, List<Tag>>> refTagsByDoc, Map<String, String> articleConversionMap, Set<String> validEntities, File logFile, boolean print, Set<String> validDocIDs, String title) {
        try {
            int j;
            List fns;
            List fps;
            boolean microOK;
            Result documentLevelResult = new Result();
            Result microLevelResult = new Result();
            Result macroLevelResult = new Result();
            BufferedWriter logStream = logFile != null ? new BufferedWriter(new FileWriter(logFile)) : null;
            Set<String> mainDocsToProcess = mainTags.keySet();
            Set<String> refDocsToProcess = refTags.keySet();
            HashMap microFPs = new HashMap();
            HashMap microFNs = new HashMap();
            HashMap macroFPs = new HashMap();
            HashMap macroFNs = new HashMap();
            for (String d : mainDocsToProcess) {
                if (validDocIDs != null && !validDocIDs.contains(d) && (articleConversionMap == null || !articleConversionMap.containsKey(d) || !validDocIDs.contains(articleConversionMap.get(d)))) continue;
                List<Mention> mainDocTags = mainTags.get(d);
                Map<String, List<Tag>> refDocTags = refTagsByDoc.get(d);
                if (refDocTags == null && articleConversionMap != null && articleConversionMap.get(d) != null) {
                    refDocTags = refTagsByDoc.get(articleConversionMap.get(d));
                }
                HashSet<String> allDocumentTPIDs = new HashSet<String>();
                Iterator<String> allDocumentFPIDs = new HashSet();
                for (Mention m : mainDocTags) {
                    microOK = false;
                    boolean macroOK = false;
                    String documentEntityOK = null;
                    boolean validEntity = false;
                    String[] stringArray = m.getIds();
                    int n = stringArray.length;
                    block4: for (int i = 0; i < n; ++i) {
                        String id = stringArray[i];
                        if (!validEntities.contains(id)) continue;
                        validEntity = true;
                        if (refDocTags == null || !refDocTags.containsKey(id)) continue;
                        documentEntityOK = id;
                        List<Tag> refList = refDocTags.get(id);
                        Tag mt = new Tag(m);
                        for (Tag rt : refList) {
                            if (mt.equals(rt)) {
                                microOK = true;
                                macroOK = true;
                                continue block4;
                            }
                            if (!mt.overlaps(rt)) continue;
                            macroOK = true;
                        }
                    }
                    if (!validEntity) continue;
                    if (documentEntityOK != null) {
                        allDocumentTPIDs.add(documentEntityOK);
                    } else {
                        allDocumentFPIDs.add(m.getIds()[0]);
                    }
                    if (microOK) {
                        ++microLevelResult.tp;
                        if (logStream != null) {
                            logStream.write("micro\ttp\t" + m.toString() + "\n");
                        }
                    } else {
                        ++microLevelResult.fp;
                        if (!microFPs.containsKey(d)) {
                            microFPs.put(d, new ArrayList());
                        }
                        ((List)microFPs.get(d)).add(m);
                    }
                    if (macroOK) {
                        ++macroLevelResult.tp;
                        if (logStream == null) continue;
                        logStream.write("macro\ttp\t" + m.toString() + "\n");
                        continue;
                    }
                    ++macroLevelResult.fp;
                    if (!macroFPs.containsKey(d)) {
                        macroFPs.put(d, new ArrayList());
                    }
                    ((List)macroFPs.get(d)).add(m);
                }
                documentLevelResult.tp += allDocumentTPIDs.size();
                documentLevelResult.fp += allDocumentFPIDs.size();
                if (logStream == null) continue;
                for (String id : allDocumentTPIDs) {
                    logStream.write("document,tp," + id + "," + d + "\n");
                }
                Iterator<Mention> iterator = allDocumentFPIDs.iterator();
                while (iterator.hasNext()) {
                    String id;
                    id = (String)((Object)iterator.next());
                    logStream.write("document,fp," + id + "," + d + "\n");
                }
            }
            for (String d : refDocsToProcess) {
                if (validDocIDs != null && !validDocIDs.contains(d) && (articleConversionMap == null || !articleConversionMap.containsKey(d) || !validDocIDs.contains(articleConversionMap.get(d)))) continue;
                List<Mention> refDocTags = refTags.get(d);
                Map<String, List<Tag>> mainDocTags = mainTagsByDoc.get(d);
                if (mainDocTags == null && articleConversionMap != null && articleConversionMap.get(d) != null) {
                    mainDocTags = mainTagsByDoc.get(articleConversionMap.get(d));
                }
                HashSet<String> allDocumentFNIDs = new HashSet<String>();
                for (Mention m : refDocTags) {
                    boolean macroOK = false;
                    microOK = false;
                    boolean documentOK = false;
                    boolean validID = false;
                    block10: for (String id : m.getIds()) {
                        if (!validEntities.contains(id)) continue;
                        validID = true;
                        if (mainDocTags == null || !mainDocTags.containsKey(id)) continue;
                        documentOK = true;
                        List<Tag> mainList = mainDocTags.get(id);
                        Tag rt = new Tag(m);
                        for (Tag mt : mainList) {
                            if (mt.equals(rt)) {
                                macroOK = true;
                                microOK = true;
                                continue block10;
                            }
                            if (!mt.overlaps(rt)) continue;
                            macroOK = true;
                        }
                    }
                    if (!validID) continue;
                    if (!documentOK) {
                        allDocumentFNIDs.add(m.getIds()[0]);
                    }
                    if (!microOK) {
                        ++microLevelResult.fn;
                        if (!microFNs.containsKey(d)) {
                            microFNs.put(d, new ArrayList());
                        }
                        ((List)microFNs.get(d)).add(m);
                    }
                    if (macroOK) continue;
                    ++macroLevelResult.fn;
                    if (!macroFNs.containsKey(d)) {
                        macroFNs.put(d, new ArrayList());
                    }
                    ((List)macroFNs.get(d)).add(m);
                }
                documentLevelResult.fn += allDocumentFNIDs.size();
                for (String id : allDocumentFNIDs) {
                    if (logStream == null) continue;
                    logStream.write("document\tfn\t" + id + "," + d + "\n");
                }
            }
            HashMap microFPFNs = new HashMap();
            HashMap macroFPFNs = new HashMap();
            for (String d : microFPs.keySet()) {
                fps = (List)microFPs.get(d);
                fns = (List)microFNs.get(d);
                if (fps == null || fns == null) continue;
                for (int i = 0; i < fps.size(); ++i) {
                    int found = -1;
                    for (j = 0; j < fns.size(); ++j) {
                        if (!((Mention)fps.get(i)).overlaps((Mention)fns.get(j))) continue;
                        found = j;
                        break;
                    }
                    if (found == -1) continue;
                    if (!microFPFNs.containsKey(d)) {
                        microFPFNs.put(d, new ArrayList());
                    }
                    ((List)microFPFNs.get(d)).add(fps.get(i));
                    fps.remove(i--);
                    fns.remove(found);
                    ++microLevelResult.fpfn;
                }
            }
            for (String d : macroFPs.keySet()) {
                fps = (List)macroFPs.get(d);
                fns = (List)macroFNs.get(d);
                if (fps == null || fns == null) continue;
                for (int i = 0; i < fps.size(); ++i) {
                    int found = -1;
                    for (j = 0; j < fns.size(); ++j) {
                        if (!((Mention)fps.get(i)).overlaps((Mention)fns.get(j))) continue;
                        found = j;
                        break;
                    }
                    if (found == -1) continue;
                    if (!macroFPFNs.containsKey(d)) {
                        macroFPFNs.put(d, new ArrayList());
                    }
                    ((List)macroFPFNs.get(d)).add(fps.get(i));
                    fps.remove(i--);
                    fns.remove(found);
                    ++macroLevelResult.fpfn;
                }
            }
            if (logStream != null) {
                for (String d : microFPFNs.keySet()) {
                    for (Mention m : (List)microFPFNs.get(d)) {
                        logStream.write("micro\tfpfn\t" + m.toString() + "\n");
                    }
                }
                for (String d : macroFPFNs.keySet()) {
                    for (Mention m : (List)macroFPFNs.get(d)) {
                        logStream.write("macro\tfpfn\t" + m.toString() + "\n");
                    }
                }
                for (String d : microFPs.keySet()) {
                    for (Mention m : (List)microFPs.get(d)) {
                        logStream.write("micro\tfp\t" + m.toString() + "\n");
                    }
                }
                for (String d : microFNs.keySet()) {
                    for (Mention m : (List)microFNs.get(d)) {
                        logStream.write("micro\tfn\t" + m.toString() + "\n");
                    }
                }
                for (String d : macroFPs.keySet()) {
                    for (Mention m : (List)macroFPs.get(d)) {
                        logStream.write("macro\tfp\t" + m.toString() + "\n");
                    }
                }
                for (String d : macroFNs.keySet()) {
                    for (Mention m : (List)macroFNs.get(d)) {
                        logStream.write("macro\tfn\t" + m.toString() + "\n");
                    }
                }
            }
            if (print) {
                System.out.println("result," + title + ",level," + Result.getHeader());
                System.out.println("result," + title + ",document," + documentLevelResult.toString());
                System.out.println("result," + title + ",micro," + microLevelResult.toString());
                System.out.println("result," + title + ",macro," + macroLevelResult.toString());
            }
            if (logStream != null) {
                logStream.close();
            }
            return new Result[]{documentLevelResult, microLevelResult};
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    private Map<String, Map<String, List<Tag>>> convert(Map<String, List<Mention>> hash) {
        HashMap<String, Map<String, List<Tag>>> res = new HashMap<String, Map<String, List<Tag>>>();
        for (String doc : hash.keySet()) {
            if (!res.containsKey(doc)) {
                res.put(doc, new HashMap());
            }
            Map<String, List<Tag>> docHash = res.get(doc);
            for (Mention m : hash.get(doc)) {
                for (String id : m.getIds()) {
                    if (!docHash.containsKey(id)) {
                        docHash.put(id, new ArrayList());
                    }
                    docHash.get(id).add(new Tag(m.getStart(), m.getEnd()));
                }
            }
        }
        return res;
    }

    private static HashMap<String, String> loadIndexfile(File file) {
        HashMap<String, String> hash = new HashMap<String, String>();
        System.out.print("Loading " + file.getAbsolutePath() + "...");
        try {
            BufferedReader inStream = new BufferedReader(new FileReader(file));
            String line = inStream.readLine();
            while (line != null) {
                String[] fields;
                if (!line.startsWith("#") && (fields = line.split(","))[1].length() > 1) {
                    hash.put(fields[0], fields[1]);
                    hash.put(fields[1], fields[0]);
                }
                line = inStream.readLine();
            }
            inStream.close();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
        System.out.println(" done, loaded " + hash.size() + " mappings.");
        return hash;
    }

    private static Set<String> loadDocumentIDSet(File file) {
        HashSet<String> res = new HashSet<String>();
        try {
            System.out.print("Loading " + file.getAbsolutePath() + "...");
            BufferedReader inStream = new BufferedReader(new FileReader(file));
            String line = inStream.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    String[] fields = line.split(",");
                    res.add(fields[0]);
                }
                line = inStream.readLine();
            }
            inStream.close();
            System.out.println(" done, loaded " + res.size() + " document IDs.");
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
        return res;
    }

    private static Set<String> loadValidEntities(File file, String prefix) {
        System.out.print("Loading " + file.getAbsolutePath() + "...");
        HashSet<String> ids = new HashSet<String>();
        try {
            BufferedReader inStream = new BufferedReader(new FileReader(file));
            String line = inStream.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    String[] fields = line.split(",");
                    if (prefix != null) {
                        ids.add(prefix + fields[0]);
                    } else {
                        ids.add(fields[0]);
                    }
                }
                line = inStream.readLine();
            }
            inStream.close();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
        System.out.println(" done, loaded " + ids.size() + " species.");
        return ids;
    }

    static Set<String> getDocumentSelection(String[] documents, int n) {
        HashSet<String> res = new HashSet<String>();
        if (n >= documents.length) {
            for (int i = 0; i < documents.length; ++i) {
                res.add(documents[i]);
            }
            return res;
        }
        Random r = new Random();
        for (int i = 0; i < n; ++i) {
            int e = r.nextInt(documents.length);
            while (res.contains(documents[e])) {
                e = r.nextInt(documents.length);
            }
            res.add(documents[e]);
        }
        return res;
    }

    public static void main(String[] args) {
        HashMap<String, Pattern> regexpFilters;
        ArgParser ap = new ArgParser(args);
        if (args.length == 0 || ap.containsKey("help")) {
            System.out.println("Usage: evaluate_tagset.jar --title <title> --taxonomy <file> --medlineIndex <file> --pmcIndex <file> --main <main tags file> --ref <ref tags file(s)> [--restrictToRefDocs]");
            System.exit(-1);
        }
        boolean recognitionOnly = ap.containsKey("recognitionOnly");
        HashMap<String, Pattern> hashMap = regexpFilters = ap.containsKey("filterRegexp") ? ACIDMatcher.loadPatterns(ap.getFile("filterRegexp")).getA() : null;
        if (regexpFilters != null) {
            System.out.println("Loaded " + regexpFilters.size() + " filters.");
        }
        HashMap<String, Integer> docLengthFilters = ap.containsKey("filterDocLength") ? Evaluate.loadDocLengthFilters(DocumentParser.getDocuments(ap)) : null;
        String title = ap.get("title");
        int threads = ap.getInt("threads", 1);
        Set<String> validEntities = Evaluate.loadValidEntities(ap.getFile("validEntities"), null);
        if (validEntities != null && recognitionOnly) {
            validEntities.add("0");
        }
        HashMap<String, String> conversionMap = ap.containsKey("conversionIndex") ? Evaluate.loadIndexfile(ap.getFile("conversionIndex")) : null;
        Set<String> mainSet = Evaluate.loadDocumentIDSet(ap.getFile("mainSet"));
        Set<String> refSet = Evaluate.loadDocumentIDSet(ap.getFile("refSet"));
        System.out.print("Loading " + ap.getFile("mainTaggedSet").getAbsolutePath() + "...");
        Map<String, List<Mention>> mainTaggedSet = Mention.loadFromFileToHash(ap.getFile("mainTaggedSet"), refSet, null, conversionMap);
        System.out.println(" done, loaded tags for " + mainTaggedSet.size() + " documents.");
        if (regexpFilters != null) {
            Evaluate.filterTagsByRegexp(mainTaggedSet, regexpFilters);
        }
        if (docLengthFilters != null) {
            Evaluate.filterTagsByDocLength(mainTaggedSet, docLengthFilters);
        }
        if (recognitionOnly) {
            Evaluate.reduceIDs(mainTaggedSet);
        }
        Map<String, Map<String, List<Tag>>> mainTagsBySpecies = new Evaluate().convert(mainTaggedSet);
        Evaluate.printEffectiveStats(title + ",main", mainTaggedSet, mainTagsBySpecies, mainSet, refSet, conversionMap);
        System.out.print("Loading " + ap.getFile("refTaggedSet").getAbsolutePath() + "...");
        Map<String, List<Mention>> refTaggedSet = Mention.loadFromFileToHash(ap.getFile("refTaggedSet"), mainSet, null, conversionMap);
        System.out.println(" done, loaded tags for " + refTaggedSet.size() + " documents.");
        if (regexpFilters != null) {
            Evaluate.filterTagsByRegexp(refTaggedSet, regexpFilters);
        }
        if (docLengthFilters != null) {
            Evaluate.filterTagsByDocLength(refTaggedSet, docLengthFilters);
        }
        if (recognitionOnly) {
            Evaluate.reduceIDs(refTaggedSet);
        }
        Map<String, Map<String, List<Tag>>> refTagsBySpecies = new Evaluate().convert(refTaggedSet);
        Evaluate.printEffectiveStats(title + ",ref", refTaggedSet, refTagsBySpecies, mainSet, refSet, conversionMap);
        Set<String> validDocs = Evaluate.getValidDocs(mainSet, mainTaggedSet.keySet(), refSet, refTaggedSet.keySet(), conversionMap);
        if (ap.containsKey("evaluateSimple")) {
            new Evaluate().process(mainTaggedSet, mainTagsBySpecies, refTaggedSet, refTagsBySpecies, conversionMap, validEntities, ap.getFile("log"), true, validDocs, title);
        }
        if (ap.containsKey("evaluateMulti")) {
            RGraphics R = new RGraphics(ap.getFile("rscriptdir"), null, ap.getFile("tempdir"));
            int[] sizes = ap.getInts("sizes");
            int numPerRun = ap.getInt("numPerRun", 20);
            System.out.println("numPerRun set to " + numPerRun);
            String[] a = validDocs.toArray(new String[0]);
            ArrayList[] rValues = new ArrayList[sizes.length];
            ArrayList[] pValues = new ArrayList[sizes.length];
            ArrayList[] rMicroValues = new ArrayList[sizes.length];
            ArrayList[] pMicroValues = new ArrayList[sizes.length];
            String[] labels = new String[sizes.length];
            for (int i = 0; i < sizes.length; ++i) {
                labels[i] = "" + Math.min(sizes[i], a.length);
                rValues[i] = new ArrayList();
                pValues[i] = new ArrayList();
                rMicroValues[i] = new ArrayList();
                pMicroValues[i] = new ArrayList();
                EvaluateProblem[] problems = new EvaluateProblem[numPerRun];
                for (int j = 0; j < numPerRun; ++j) {
                    problems[j] = new EvaluateProblem(mainTaggedSet, mainTagsBySpecies, refTaggedSet, refTagsBySpecies, conversionMap, validEntities, sizes[i], a, title);
                }
                IteratorBasedMaster master = new IteratorBasedMaster(problems, threads);
                master.startThread();
                while (master.hasNext()) {
                    Result[] r = (Result[])master.next();
                    rValues[i].add(r[0].getRecall());
                    pValues[i].add(r[0].getPrecision());
                    rMicroValues[i].add(r[1].getRecall());
                    pMicroValues[i].add(r[1].getPrecision());
                }
            }
            if (ap.containsKey("outR")) {
                R.boxPlot(rValues, labels, ap.getFile("outR"), 800, 400);
            }
            if (ap.containsKey("outP")) {
                R.boxPlot(pValues, labels, ap.getFile("outP"), 800, 400);
            }
            if (ap.containsKey("outRMicro")) {
                R.boxPlot(rMicroValues, labels, ap.getFile("outRMicro"), 800, 400);
            }
            if (ap.containsKey("outPMicro")) {
                R.boxPlot(pMicroValues, labels, ap.getFile("outPMicro"), 800, 400);
            }
        }
    }

    private static void reduceIDs(Map<String, List<Mention>> mainTaggedSet) {
        for (List<Mention> l : mainTaggedSet.values()) {
            for (Mention m : l) {
                m.setIds(new String[]{"0"});
                m.setProbabilities(null);
            }
        }
    }

    private static void filterTagsByDocLength(Map<String, List<Mention>> mainTaggedSet, Map<String, Integer> docLengthFilters) {
        HashSet<String> toRemove = new HashSet<String>();
        for (String d : mainTaggedSet.keySet()) {
            if (docLengthFilters.containsKey(d)) {
                int length = docLengthFilters.get(d);
                List<Mention> matches = mainTaggedSet.get(d);
                for (int i = 0; i < matches.size(); ++i) {
                    if (matches.get(i).getEnd() <= length) continue;
                    matches.remove(i);
                    --i;
                }
                continue;
            }
            toRemove.add(d);
        }
        for (String d : toRemove) {
            mainTaggedSet.remove(d);
        }
    }

    private static HashMap<String, Integer> loadDocLengthFilters(DocumentIterator documents) {
        if (documents == null) {
            return null;
        }
        System.out.print("Loading document lengths...");
        HashMap<String, Integer> retres = new HashMap<String, Integer>();
        for (Document d : documents) {
            retres.put(d.getID(), d.toString().length());
        }
        System.out.println(" done, parsed " + retres.size() + " documents.");
        return retres;
    }

    public static void filterTagsByRegexp(Map<String, List<Mention>> mainTaggedSet, Map<String, Pattern> filters) {
        for (List<Mention> matches : mainTaggedSet.values()) {
            for (int i = 0; i < matches.size(); ++i) {
                Matcher matcher;
                Mention m = matches.get(i);
                if (m.getIds().length != 1 || !filters.containsKey(m.getIds()[0]) || !(matcher = filters.get(m.getIds()[0]).matcher(m.getText())).matches()) continue;
                matches.remove(i);
                --i;
            }
        }
    }

    private static void printEffectiveStats(String title, Map<String, List<Mention>> mainTaggedSet, Map<String, Map<String, List<Tag>>> mainTagsBySpecies, Set<String> doclist_a, Set<String> doclist_b, Map<String, String> conversionMap) {
        int numTags = 0;
        HashSet<String> ids = new HashSet<String>();
        for (String d : mainTaggedSet.keySet()) {
            numTags += mainTaggedSet.get(d).size();
            for (String id : mainTagsBySpecies.get(d).keySet()) {
                ids.add(id);
            }
        }
        int numdocs = 0;
        for (String d : doclist_a) {
            if (!doclist_b.contains(d) && (!conversionMap.containsKey(d) || !doclist_b.contains(conversionMap.get(d)))) continue;
            ++numdocs;
        }
        System.out.println("#size,title,title2,docs,ids,tags");
        System.out.println("size," + title + "," + mainTaggedSet.size() + "," + ids.size() + "," + numTags);
        System.out.println("Intersecting documents: " + numdocs);
    }

    private static Set<String> getValidDocs(Set<String> mainSet, Set<String> mainTaggedSet, Set<String> refSet, Set<String> refTaggedSet, HashMap<String, String> articleConversions) {
        HashSet<String> s = new HashSet<String>();
        for (String str : mainTaggedSet) {
            if (!refSet.contains(str) && (!articleConversions.containsKey(str) || !refSet.contains(articleConversions.get(str)))) continue;
            s.add(str);
        }
        for (String str : refTaggedSet) {
            if (!mainSet.contains(str) && (!articleConversions.containsKey(str) || !mainSet.contains(articleConversions.get(str)))) continue;
            s.add(str);
        }
        return s;
    }

    class Tag {
        int start;
        int end;

        public Tag(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public Tag(Mention m) {
            this(m.getStart(), m.getEnd());
        }

        public boolean equals(Tag t) {
            if (this.start == -1 || this.end == -1) {
                return false;
            }
            return t.start == this.start && t.end == this.end;
        }

        public boolean overlaps(Tag t) {
            if (this.start == -1 || this.end == -1) {
                return false;
            }
            int s1 = this.start;
            int s2 = t.start;
            int e1 = this.end;
            int e2 = t.end;
            return s1 >= s2 && s1 < e2 || s2 >= s1 && s2 < e1;
        }

        public String toString() {
            return "[" + this.start + "," + this.end + "]";
        }
    }
}

