/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.entitytagger.doc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import martin.common.Function;
import martin.common.Pair;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.entitytagger.Mention;
import uk.ac.man.entitytagger.doc.TaggedSection;

public class TaggedDocument {
    private Document original;
    private TaggedSection[] abs;
    private TaggedSection[] body;
    private List<Mention> rawMatches;
    private String rawContent;

    public TaggedDocument(Document original, TaggedSection[] abs, TaggedSection[] body, List<Mention> rawMatches, String rawContent) {
        this.original = original;
        this.abs = abs;
        this.body = body;
        this.rawMatches = rawMatches;
        this.rawContent = rawContent;
    }

    public StringBuffer toHTML(boolean link, Function<Pair<String>> alternativeTagFunction) {
        int i;
        if (this.rawMatches == null) {
            return new StringBuffer(this.original.toString());
        }
        StringBuffer sb = new StringBuffer();
        if (this.original != null && this.original.getTitle() != null) {
            sb.append("<b>" + this.original.getTitle().replace("<", "_").replace(">", "_") + "</b><br>");
        }
        if (this.abs != null) {
            for (i = 0; i < this.abs.length; ++i) {
                if (this.abs[i] == null) continue;
                sb.append(this.abs[i].toHTML());
            }
        }
        if (this.body != null) {
            for (i = 0; i < this.body.length; ++i) {
                if (this.body[i] == null) continue;
                sb.append(this.body[i].toHTML());
            }
        }
        if (this.rawContent != null) {
            sb.append(TaggedDocument.toHTML(this.rawContent.replace("<", "_").replace(">", "_"), this.rawMatches, Format.HTML, link, alternativeTagFunction));
        }
        return sb;
    }

    private static Pair<String> getMatchTags(Mention m, Format format, boolean link) {
        String[] ids = m.getIds();
        Double[] probs = m.getProbabilities();
        String starttag = "";
        String endtag = null;
        if (m.isAmbigous()) {
            link = false;
        }
        if (!link && format == Format.HTML) {
            if (ids[0].equals("red")) {
                starttag = "<font style=\"background-color: #FF7777\">";
                endtag = "</font>";
            } else if (ids[0].equals("green")) {
                starttag = "<font style=\"background-color: #77FF77\">";
                endtag = "</font>";
            } else if (ids[0].equals("orange")) {
                starttag = "<font style=\"background-color: #FF9933\">";
                endtag = "</font>";
            } else if (ids[0].equals("purple")) {
                starttag = "<font style=\"background-color: #DB70FF\">";
                endtag = "</font>";
            } else if (ids[0].equals("0")) {
                starttag = "<font style=\"background-color: #FF7777\">";
                endtag = "</font>";
            } else {
                starttag = "<font style=\"background-color: #7777FF\">";
                endtag = "</font>";
            }
        } else if (ids.length <= 1 && format == Format.HTML) {
            if (ids.length == 0 || ids[0].equals("0") || ids[0].startsWith("CellLine:CLKB:")) {
                starttag = "<font style=\"background-color: #FF7777\">";
                endtag = "</font>";
            } else if (ids[0].equals("red")) {
                starttag = "<font style=\"background-color: #FF7777\">";
                endtag = "</font>";
            } else if (ids[0].startsWith("species:ncbi:")) {
                starttag = "<font style=\"background-color: #88FF88\"><a href=\"http://www.ncbi.nlm.nih.gov/Taxonomy/Browser/wwwtax.cgi?id=" + ids[0].substring(13) + "&mode=info\">";
            } else if (ids[0].startsWith("genus:ncbi:")) {
                starttag = "<font style=\"background-color: #88FF88\"><a href=\"http://www.ncbi.nlm.nih.gov/Taxonomy/Browser/wwwtax.cgi?id=" + ids[0].substring(11) + "&mode=info\">";
            } else if (ids[0].startsWith("gene:ncbi:")) {
                starttag = "<font style=\"background-color: #88FF88\"><a href=\"http://www.ncbi.nlm.nih.gov/gene/" + ids[0].substring(10) + "\">";
            } else if (ids[0].startsWith("protein:uniprot:")) {
                starttag = "<font style=\"background-color: #88FF88\"><a href=\"http://www.uniprot.org/uniprot/" + ids[0].substring(16) + "\">";
            } else {
                throw new IllegalStateException("Could not recognize entity type '" + ids[0] + "'");
            }
            if (endtag == null) {
                endtag = "</a></font>";
            }
        } else if (ids.length > 1 && format == Format.HTML) {
            starttag = "<u>";
            if (ids[0].startsWith("species:ncbi:")) {
                endtag = "</u>[<a href=\"http://www.ncbi.nlm.nih.gov/Taxonomy/Browser/wwwtax.cgi?id=" + ids[0].substring(13) + "&mode=info\">" + ids[0] + "</a>";
            } else if (ids[0].startsWith("genus:ncbi:")) {
                endtag = "</u>[<a href=\"http://www.ncbi.nlm.nih.gov/Taxonomy/Browser/wwwtax.cgi?id=" + ids[0].substring(11) + "&mode=info\">" + ids[0] + "</a>";
            } else if (ids[0].startsWith("gene:ncbi:")) {
                endtag = "</u>[<a href=\"http://www.ncbi.nlm.nih.gov/gene/" + ids[0].substring(10) + "\">" + ids[0] + "</a>";
            } else if (ids[0].startsWith("protein:uniprot:")) {
                endtag = "</u><a href=\"http://www.uniprot.org/uniprot/" + ids[0].substring(16) + "\">" + ids[0] + "</a>";
            } else {
                throw new IllegalStateException("Could not recognize entity type");
            }
            for (int j = 1; j < ids.length; ++j) {
                if (ids[j].startsWith("species:ncbi:")) {
                    endtag = endtag + ", <a href=\"http://www.ncbi.nlm.nih.gov/Taxonomy/Browser/wwwtax.cgi?id=" + ids[j].substring(13) + "&mode=info\">" + ids[j] + "</a>";
                    continue;
                }
                if (ids[j].startsWith("genus:ncbi:")) {
                    endtag = endtag + ", <a href=\"http://www.ncbi.nlm.nih.gov/Taxonomy/Browser/wwwtax.cgi?id=" + ids[j].substring(11) + "&mode=info\">" + ids[j] + "</a>";
                    continue;
                }
                if (ids[j].startsWith("gene:ncbi:")) {
                    endtag = endtag + "</u>[<a href=\"http://www.ncbi.nlm.nih.gov/gene/" + ids[j].substring(10) + "\">" + ids[j] + "</a>";
                    continue;
                }
                if (ids[j].startsWith("protein:uniprot:")) {
                    endtag = endtag + "</u><a href=\"http://www.uniprot.org/uniprot/" + ids[j].substring(16) + "\">" + ids[j] + "</a>";
                    continue;
                }
                throw new IllegalStateException("Could not recognize entity type");
            }
            endtag = endtag + "]";
        } else if (format == Format.XMLTags) {
            starttag = "<e data=\"";
            for (int i = 0; i < ids.length; ++i) {
                starttag = i == 0 ? starttag + ids[i] : starttag + "|" + ids[i];
                if (probs[i] == null) continue;
                starttag = starttag + "?" + probs[i];
            }
            starttag = starttag + "\">";
            endtag = "</e>";
        } else {
            if (format == Format.Alibaba) {
                int max = 0;
                if (probs != null) {
                    for (int i = 0; i < probs.length; ++i) {
                        if ((probs[i] == null || probs[max] != null) && (probs[i] == null || probs[max] == null || !(probs[i] > probs[max]))) continue;
                        max = i;
                    }
                }
                if (ids[max].startsWith("species:ncbi:")) {
                    String id = ids[max].substring(13);
                    return new Pair<String>("<z:species ids=\"" + id + "\">", "</z:species>");
                }
                throw new IllegalStateException("Could not convert " + ids[max] + " to alibaba");
            }
            throw new IllegalStateException("Should not have reached this stage");
        }
        return new Pair<String>(starttag, endtag);
    }

    public static StringBuffer toHTML(String text, List<Mention> matches, Format format, boolean link, Function<Pair<String>> alternativeTagFunction) {
        StringBuffer sb = new StringBuffer(text);
        Object[] matchesArr = matches.toArray(new Mention[0]);
        Arrays.sort(matchesArr);
        int added = 0;
        int prevend = -1;
        for (int i = 0; i < matchesArr.length; ++i) {
            Object m = matchesArr[i];
            if (((Mention)m).getStart() <= prevend) continue;
            Pair<String> tags = alternativeTagFunction == null ? TaggedDocument.getMatchTags((Mention)m, format, link) : alternativeTagFunction.function(new Object[]{m, format, link});
            String starttag = tags.getX();
            String endtag = tags.getY();
            if (((Mention)m).getEnd() + added > sb.length()) {
                throw new IllegalStateException("m.getEnd(): " + ((Mention)m).getEnd() + ", added: " + added + ", sb.length(): " + sb.length() + ", sb: " + sb.toString());
            }
            sb = sb.insert(((Mention)m).getEnd() + added, endtag);
            if (((Mention)m).getStart() + added > sb.length()) {
                throw new IllegalStateException("m.getStart(): " + ((Mention)m).getStart() + ", added: " + added + ", sb.length(): " + sb.length() + ", sb: " + sb.toString());
            }
            sb = sb.insert(((Mention)m).getStart() + added, starttag);
            added += starttag.length() + endtag.length();
            prevend = ((Mention)m).getEnd();
        }
        return sb;
    }

    public Document getOriginal() {
        return this.original;
    }

    public TaggedSection[] getAbs() {
        return this.abs;
    }

    public TaggedSection[] getBody() {
        return this.body;
    }

    public List<Mention> getRawMatches() {
        return this.rawMatches;
    }

    public ArrayList<Mention> getAllMatches() {
        int i;
        ArrayList<Mention> matches = new ArrayList<Mention>();
        if (this.rawMatches != null) {
            matches.addAll(this.rawMatches);
        }
        if (this.abs != null) {
            for (i = 0; i < this.abs.length; ++i) {
                if (this.abs[i] == null) continue;
                matches.addAll(this.abs[i].getAllMatches());
            }
        }
        if (this.body != null) {
            for (i = 0; i < this.body.length; ++i) {
                if (this.body[i] == null) continue;
                matches.addAll(this.body[i].getAllMatches());
            }
        }
        return matches;
    }

    public HashSet<String> getAllMatchedSpecies() {
        HashSet<String> res = new HashSet<String>();
        ArrayList<Mention> matches = this.getAllMatches();
        for (Mention m : matches) {
            for (String id : m.getIds()) {
                res.add(id);
            }
        }
        return res;
    }

    public String getContent() {
        return this.rawContent;
    }

    public static enum Format {
        XMLTags,
        HTML,
        Alibaba;

    }
}

