/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.entitytagger;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import martin.common.ArgParser;
import martin.common.Loggers;
import martin.common.SQL;
import martin.common.compthreads.IteratorBasedMaster;
import uk.ac.man.documentparser.DocumentParser;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.documentparser.input.DocumentIterator;
import uk.ac.man.entitytagger.doc.TaggedDocument;
import uk.ac.man.entitytagger.entities.misc.CellLinePostprocessor;
import uk.ac.man.entitytagger.matching.MatchOperations;
import uk.ac.man.entitytagger.matching.Matcher;
import uk.ac.man.entitytagger.matching.Postprocessor;
import uk.ac.man.entitytagger.matching.matchers.ACIDMatcher;
import uk.ac.man.entitytagger.matching.matchers.AutomatonMatcher;
import uk.ac.man.entitytagger.matching.matchers.DuplicationMatcher;
import uk.ac.man.entitytagger.matching.matchers.MatchPostProcessor;
import uk.ac.man.entitytagger.matching.matchers.PrecomputedMatcher;
import uk.ac.man.entitytagger.matching.matchers.RegexpMatcher;
import uk.ac.man.entitytagger.matching.matchers.SentenceMatcher;
import uk.ac.man.entitytagger.matching.matchers.TaxonGrabMatcher;
import uk.ac.man.entitytagger.matching.matchers.UnionMatcher;
import uk.ac.man.entitytagger.matching.matchers.VariantDictionaryMatcher;
import uk.ac.man.entitytagger.networking.SimpleClientMatcher;
import uk.ac.man.entitytagger.networking.SimpleServer;

public class EntityTagger {
    public static final String LINNAEUS_VERSION = "LINNAEUS, v. 2.0 (July, 2011)";

    public static Postprocessor getPostprocessor(ArgParser ap, Logger logger, Map<String, String> comments) {
        return EntityTagger.getPostprocessor(ap, logger, comments, "");
    }

    public static Postprocessor getPostprocessor(ArgParser ap, Logger logger, Map<String, String> comments, String tag) {
        if (ap.containsKey("postProcessing" + tag)) {
            InputStream[] stop = ap.getInputStreams("ppStopTerms" + tag);
            InputStream[] acr = ap.getInputStreams("ppAcrProbs" + tag);
            InputStream[] spf = ap.getInputStreams("ppEntityFreqs" + tag);
            Postprocessor res = new Postprocessor(stop, acr, spf, comments, logger);
            try {
                if (stop != null) {
                    for (InputStream s : stop) {
                        s.close();
                    }
                }
                if (acr != null) {
                    for (InputStream s : acr) {
                        s.close();
                    }
                }
                if (spf != null) {
                    for (InputStream s : spf) {
                        s.close();
                    }
                }
            }
            catch (Exception e) {
                System.err.println(e);
                e.printStackTrace();
                System.exit(0);
            }
            return res;
        }
        if (logger != null) {
            logger.info("Not performing post-processing.\n");
        }
        return null;
    }

    public static Matcher getMatcher(ArgParser ap, Logger logger) {
        return EntityTagger.getMatcher(ap, logger, null);
    }

    public static Matcher getMatcher(ArgParser ap, Logger logger, String tag) {
        Matcher matcher;
        Matcher m;
        if (tag != null && !tag.startsWith("-")) {
            tag = "-" + tag;
        }
        if (tag == null) {
            tag = "";
        }
        boolean abbrevResolution = !ap.containsKey("noAbbreviationResolution" + tag);
        logger.info("%t: Abbreviation resolution mode set to: " + abbrevResolution + ".\n");
        Matcher.Disambiguation disambiguation = Matcher.Disambiguation.ON_WHOLE;
        if (ap.containsKey("noDisambiguation" + tag)) {
            disambiguation = Matcher.Disambiguation.OFF;
        }
        if (ap.containsKey("longestDisambiguation")) {
            disambiguation = Matcher.Disambiguation.ON_LONGEST_ONLY;
        }
        if (ap.containsKey("earlierDisambiguation" + tag)) {
            disambiguation = Matcher.Disambiguation.ON_EARLIER;
        }
        if (ap.containsKey("wholeDisambiguation" + tag)) {
            disambiguation = Matcher.Disambiguation.ON_WHOLE;
        }
        logger.info("%t: Disambiguation mode set to: " + (Object)((Object)disambiguation) + ".\n");
        Map<String, String> comments = ap.containsKey("comments" + tag) ? EntityTagger.loadComments(ap.getFiles("comments" + tag), logger) : null;
        Postprocessor defaultPostprocessor = EntityTagger.getPostprocessor(ap, logger, comments, tag);
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        if (ap.containsKey("automatons" + tag)) {
            for (File f : ap.getFiles("automatons" + tag)) {
                logger.info("%t: Loading automatons from file " + f.getAbsolutePath() + "...\n");
                m = AutomatonMatcher.loadMatcher(f);
                matchers.add(m);
                logger.info("%t: Done, loaded " + m.size() + " automatons.\n");
            }
        }
        if (ap.containsKey("regexpMatcher" + tag)) {
            for (File f : ap.getFiles("regexpMatcher" + tag)) {
                logger.info("Loading regular expressions from file " + f.getAbsolutePath() + "...");
                HashMap<String, Pattern> patterns = ACIDMatcher.loadPatterns(f).getA();
                RegexpMatcher m2 = new RegexpMatcher(patterns);
                matchers.add(m2);
                logger.info(" done, loaded " + ((Matcher)m2).size() + " patterns.\n");
            }
        }
        if (ap.containsKey("sentenceMatcher" + tag)) {
            matchers.add(new SentenceMatcher());
        }
        if (ap.containsKey("taxongrabMatcher")) {
            matchers.add(new TaxonGrabMatcher(ap.getFile("taxongrabMatcher")));
        }
        if (ap.containsKey("precomputedMatcher" + tag)) {
            for (File f : ap.getFiles("precomputedMatcher" + tag)) {
                logger.info("Loading precomputed match data from file " + f.getAbsolutePath() + "...");
                m = new PrecomputedMatcher(f);
                matchers.add(m);
                logger.info(" done, loaded data for " + m.size() + " documents.\n");
            }
        }
        if (ap.containsKey("precomputedDBMatcher" + tag)) {
            File[] db = ap.gets("precomputedDBMatcher" + tag)[0];
            String table = ap.gets("precomputedDBMatcher" + tag)[1];
            Connection conn = SQL.connectMySQL(ap, logger, (String)db);
            PrecomputedMatcher m3 = new PrecomputedMatcher(conn, table);
            matchers.add(m3);
            logger.info("%t: Created precomputedDBMatcher.\n");
        }
        if (ap.containsKey("ACIDs" + tag)) {
            for (File f : ap.getFiles("ACIDs" + tag)) {
                logger.info("Loading ACID data from file " + f.getAbsolutePath() + "...");
                m = new ACIDMatcher(f);
                matchers.add(m);
                logger.info(" done.\n");
            }
        }
        if (ap.containsKey("celllines" + tag)) {
            boolean ignoreCase = ap.containsKey("ignoreCase");
            defaultPostprocessor = CellLinePostprocessor.getPostprocessor(ap, logger, comments);
            logger.info("%t: Loading variants from file " + ap.getFile("celllines" + tag).getAbsolutePath() + "...");
            Connection conn = SQL.connectMySQL(ap, logger, "dictionaries");
            VariantDictionaryMatcher m4 = new VariantDictionaryMatcher(conn, ap.gets("celllines"), null, ignoreCase);
            matchers.add(m4);
            logger.info(" done.\n");
        }
        if (ap.containsKey("networkMatcher" + tag)) {
            String[] strs;
            for (String s : strs = ap.gets("networkMatcher" + tag)) {
                matchers.add(new SimpleClientMatcher(s));
            }
        }
        if (ap.containsKey("variantMatcher" + tag)) {
            boolean ignoreCase = ap.containsKey("ignoreCase");
            for (int i = 0; i < ap.gets("variantMatcher").length; ++i) {
                logger.info("%t: Loading variantMatcher from " + ap.gets("variantMatcher")[i] + ", ignoreCase = " + ignoreCase + "...\n");
                matchers.add(VariantDictionaryMatcher.load(ap.getInputStreams("variantMatcher")[i], ignoreCase));
            }
        }
        if (ap.containsKey("variantMatcherDB" + tag)) {
            boolean ignoreCase = ap.containsKey("ignoreCase");
            Connection conn = SQL.connectMySQL(ap, logger, "dictionaries");
            matchers.add(new VariantDictionaryMatcher(conn, ap.gets("variantMatcherDB" + tag), null, ignoreCase));
        }
        if (ap.containsKey("internalSpeciesMatcher")) {
            // empty if block
        }
        if ((tag == null || tag.length() == 0) && ap.containsKey("matchers")) {
            for (String t : ap.gets("matchers")) {
                m = EntityTagger.getMatcher(ap, logger, "-" + t);
                if (m == null) continue;
                matchers.add(m);
            }
        }
        if (matchers.size() == 0) {
            logger.warning("Warning: no matcher have been chosen.\n");
            return null;
        }
        Matcher matcher2 = matcher = matchers.size() == 1 ? (Matcher)matchers.get(0) : new UnionMatcher(matchers, true);
        if (ap.containsKey("duplicates" + tag)) {
            matcher = new DuplicationMatcher(matcher);
        }
        File ppConvertIDs = ap.getFile("ppConvertIDs");
        matcher = new MatchPostProcessor(matcher, disambiguation, abbrevResolution, ppConvertIDs, defaultPostprocessor);
        matcher.match("test", new Document("none", null, null, null, null, null, null, null, null, null, null, null, null, null, null));
        return matcher;
    }

    public static String getDefaultHelpMessage() {
        String msg = "[--automatons <automaton file>]\n[--regexpMatcher <regexp file>]\n\n[--out <output file>]\n[--outDir <output dir>]\n[--outHTML <html output file>]\n\n[--threads <number of threads>]\n[--properties <file>]";
        msg = msg + DocumentParser.getDocumentHelpMessage();
        return msg;
    }

    public static void main(String[] args) {
        DocumentIterator documents;
        ArgParser ap = new ArgParser(args);
        if (args.length == 0 || ap.containsKey("help")) {
            System.out.println(EntityTagger.getDefaultHelpMessage());
            System.exit(0);
        }
        if (ap.containsKey("version")) {
            System.out.println(LINNAEUS_VERSION);
        }
        int numThreads = ap.getInt("threads", 1);
        int report = ap.getInt("report", -1);
        Logger logger = Loggers.getDefaultLogger(ap);
        if (ap.containsKey("default")) {
            ap.addProperties("internal:/resources-linnaeus/properties.conf");
        } else if (ap.containsKey("default-proxy")) {
            ap.addProperties("internal:/resources-linnaeus/properties-proxy.conf");
        }
        Matcher matcher = EntityTagger.getMatcher(ap, logger);
        if (matcher == null) {
            logger.info("%t: No species matcher has been chosen, so loading the default species matcher...\n");
            ap.addProperties("internal:/resources-linnaeus/properties.conf");
            matcher = EntityTagger.getMatcher(ap, logger);
        }
        if (ap.containsKey("out")) {
            documents = DocumentParser.getDocuments(ap);
            MatchOperations.runToFile(matcher, documents, numThreads, report, ap.getFile("out"), logger);
        }
        if (ap.containsKey("outDir")) {
            documents = DocumentParser.getDocuments(ap);
            MatchOperations.runToDir(matcher, documents, numThreads, report, ap.getFile("outDir"), logger);
        }
        if (ap.containsKey("outHTML")) {
            documents = DocumentParser.getDocuments(ap);
            MatchOperations.runHTML(matcher, documents, numThreads, ap.getFile("outHTML"), report, logger, TaggedDocument.Format.HTML, !ap.containsKey("nolinks"));
        }
        if (ap.containsKey("outXML")) {
            documents = DocumentParser.getDocuments(ap);
            MatchOperations.runHTML(matcher, documents, numThreads, ap.getFile("outXML"), report, logger, TaggedDocument.Format.XMLTags);
        }
        if (ap.containsKey("outDB")) {
            Connection dbConn = SQL.connectMySQL(ap, logger, ap.gets("outDB")[0]);
            DocumentIterator documents2 = DocumentParser.getDocuments(ap);
            MatchOperations.runDB(matcher, documents2, numThreads, ap.gets("outDB")[1], report, logger, dbConn, ap.containsKey("clear"));
        }
        if (ap.containsKey("outWithContext")) {
            int pre = ap.getInt("pre", 50);
            int post = ap.getInt("post", 50);
            DocumentIterator documents3 = DocumentParser.getDocuments(ap);
            MatchOperations.runOutWithContext(matcher, documents3, numThreads, report, ap.getFile("outWithContext"), logger, pre, post);
        }
        if (ap.containsKey("server")) {
            int port = ap.getInt("serverPort", 55000);
            int numConns = ap.getInt("conns", 4);
            EntityTagger.doServer(matcher, port, numConns, logger, ap.containsKey("enableCache"), ap.getInt("report", -1));
        }
    }

    public static void doServer(Matcher matcher, int port, int numConns, Logger logger, boolean enableCache, int report) {
        logger.info("%t: Starting server at port " + port + ", maximum " + numConns + " concurrent connections (caching: " + enableCache + ")... ");
        SimpleServer server = new SimpleServer(port, matcher, enableCache);
        IteratorBasedMaster<Object> master = new IteratorBasedMaster<Object>(server, numConns);
        master.startThread();
        logger.info("done.\n");
        long c = 0L;
        while (master.hasNext()) {
            master.next();
            if (report == -1 || ++c % (long)report != 0L) continue;
            logger.info("%t: Served " + c + " requests.\n");
        }
    }

    public static Map<String, String> loadComments(File[] files, Logger logger) {
        if (logger != null) {
            logger.info("%t Loading comments... ");
        }
        try {
            HashMap<String, String> res = new HashMap<String, String>();
            for (File f : files) {
                BufferedReader inStream = new BufferedReader(new FileReader(f));
                String line = inStream.readLine();
                while (line != null) {
                    String[] fields;
                    if (!line.startsWith("#") && (fields = line.split("\t")).length > 2 && fields[2].length() > 0) {
                        res.put(fields[0], fields[2]);
                    }
                    line = inStream.readLine();
                }
                inStream.close();
            }
            if (logger != null) {
                logger.info("done.\n");
            }
            return res;
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }
}

