/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.documentparser.input.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.documentparser.input.DocumentIterator;

public class DocumentBuffer
implements DocumentIterator {
    private DocumentIterator documents;
    private LinkedList<Document> retrieved;
    private int fetchsize;
    private boolean hasNext;
    private Logger logger;

    public DocumentBuffer(DocumentIterator documents, int fetchsize, Logger logger) {
        this.documents = documents;
        this.retrieved = new LinkedList();
        this.fetchsize = fetchsize;
        this.hasNext = this.retrieved.size() > 0 || documents.hasNext();
        this.logger = logger;
    }

    @Override
    public void skip() {
        if (this.retrieved.size() == 0) {
            this.documents.skip();
        } else {
            this.retrieved.poll();
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Document next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.retrieved.size() == 0) {
            this.populateRetrieved();
        }
        Document d = this.retrieved.poll();
        this.hasNext = this.retrieved.size() > 0 || this.documents.hasNext();
        return d;
    }

    private void populateRetrieved() {
        for (int i = 0; i < this.fetchsize && this.documents.hasNext(); ++i) {
            this.retrieved.add((Document)this.documents.next());
        }
    }

    @Override
    public void remove() {
        throw new IllegalStateException();
    }

    @Override
    public Iterator<Document> iterator() {
        return this;
    }
}

