/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.documentparser.input;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import martin.common.xml.MyNodeList;
import martin.common.xml.XPath;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.documentparser.input.DocumentIterator;

public class OTMI
implements DocumentIterator {
    private Node root;

    public OTMI(File file) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.root = XPath.getNode("atom:entry", db.parse(file));
        }
        catch (Exception e) {
            System.err.println("Failed parsing " + file.getAbsolutePath() + ", error: " + e);
            this.root = null;
        }
    }

    @Override
    public void skip() {
        if (this.root == null) {
            throw new NoSuchElementException();
        }
        this.root = null;
    }

    @Override
    public boolean hasNext() {
        return this.root != null;
    }

    @Override
    public Iterator<Document> iterator() {
        return this;
    }

    private ArrayList<String> getSnippets(NodeList sections) {
        ArrayList<String> snippets = new ArrayList<String>();
        for (int i = 0; i < sections.getLength(); ++i) {
            Node n = sections.item(i);
            MyNodeList sections2 = XPath.getNodeList("otmi:section", n);
            snippets.addAll(this.getSnippets(sections2));
            MyNodeList ss = XPath.getNodeList("otmi:snippets/otmi:snippet", n);
            for (int j = 0; j < ss.getLength(); ++j) {
                Node s = ss.item(j);
                snippets.add(s.getTextContent());
            }
        }
        return snippets;
    }

    private HashMap<String, Integer> getWordCounts(NodeList sections) {
        HashMap<String, Integer> res = new HashMap<String, Integer>();
        for (int i = 0; i < sections.getLength(); ++i) {
            Node n = sections.item(i);
            MyNodeList sections2 = XPath.getNodeList("otmi:section", n);
            HashMap<String, Integer> r = this.getWordCounts(sections2);
            for (String k : r.keySet()) {
                if (res.containsKey(k)) {
                    res.put(k, res.get(k) + r.get(k));
                    continue;
                }
                res.put(k, r.get(k));
            }
            MyNodeList vectors = XPath.getNodeList("otmi:vectors/otmi:vector", n);
            for (int j = 0; j < vectors.getLength(); ++j) {
                Node v = vectors.item(j);
                String k = v.getTextContent();
                int c = Integer.parseInt(v.getAttributes().getNamedItem("count").getTextContent());
                if (res.containsKey(k)) {
                    res.put(k, res.get(k) + c);
                    continue;
                }
                res.put(k, c);
            }
        }
        return res;
    }

    @Override
    public Document next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String title = XPath.getNode("atom:title", this.root).getTextContent();
        String id = XPath.getNode("atom:id", this.root).getTextContent();
        String yearstr = XPath.getNode("atom:published", this.root).getTextContent();
        String year = yearstr.length() >= 4 ? yearstr.substring(0, 4) : null;
        MyNodeList sections = XPath.getNodeList("otmi:data/otmi:section", this.root);
        ArrayList<String> snippets = this.getSnippets(sections);
        HashMap<String, Integer> wordCounts = this.getWordCounts(sections);
        StringBuffer sb = new StringBuffer();
        for (String sn : snippets) {
            sb.append(sn + "\n");
        }
        sb.append("\n");
        for (String k : wordCounts.keySet()) {
            int c = wordCounts.get(k);
            for (int j = 0; j < c; ++j) {
                sb.append(k + " ");
            }
            sb.append("\n");
        }
        Document d = new Document(id, title, null, null, sb.toString(), Document.Text_raw_type.XML, year, null, null, null, null, null, null, null, null);
        d.setIgnoreCoordinates(true);
        this.root = null;
        return d;
    }

    @Override
    public void remove() {
        throw new IllegalStateException("not implemented");
    }
}

