/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.documentparser.input;

import java.io.File;
import java.util.Set;
import uk.ac.man.documentparser.input.DocumentIterator;
import uk.ac.man.documentparser.input.InputFactory;
import uk.ac.man.documentparser.input.MedlinePMCIndex;

public class MedlinePMCIndexFactory
implements InputFactory {
    File medlineBaseDir;
    private File pmcBaseDir;
    private int minYearFilter = -1;
    private Set<String> validIDs = null;
    private String[] dtds;

    public MedlinePMCIndexFactory(File medlineBaseDir, File pmcBaseDir, String[] dtds, Set<String> validIDs) {
        this.medlineBaseDir = medlineBaseDir;
        this.pmcBaseDir = pmcBaseDir;
        this.dtds = dtds;
        this.validIDs = validIDs;
    }

    public MedlinePMCIndexFactory(File baseDir) {
        this.medlineBaseDir = baseDir;
    }

    @Override
    public DocumentIterator parse(StringBuffer data) {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public DocumentIterator parse(String file) {
        return this.parse(new File(file));
    }

    @Override
    public DocumentIterator parse(File file) {
        return new MedlinePMCIndex(this.medlineBaseDir, this.pmcBaseDir, file, this.dtds, this.minYearFilter, this.validIDs);
    }

    public void setMinYearFilter(int minYearFilter) {
        this.minYearFilter = minYearFilter;
    }
}

