/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.documentparser.input;

import java.io.File;
import java.io.StringReader;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import martin.common.xml.MyNodeList;
import martin.common.xml.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import uk.ac.man.documentparser.dataholders.Author;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.documentparser.dataholders.ExternalID;
import uk.ac.man.documentparser.dataholders.Journal;
import uk.ac.man.documentparser.input.DocumentIterator;

public class Medline
implements DocumentIterator {
    private NodeList citations;
    private int numArticles;
    private int nextArticle = 0;
    private String xml = null;

    public Medline(String filename) {
        this(new File(filename));
    }

    public Medline(StringBuffer data) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new StringReader(data.toString())));
            this.citations = XPath.getNodeList("MedlineCitation", doc.getDocumentElement());
            this.numArticles = this.citations.getLength();
            this.xml = data.toString();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public Medline(File file) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            this.citations = XPath.getNodeList("MedlineCitation", doc.getDocumentElement());
            this.numArticles = this.citations.getLength();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextArticle < this.numArticles;
    }

    @Override
    public Iterator<uk.ac.man.documentparser.dataholders.Document> iterator() {
        return this;
    }

    @Override
    public uk.ac.man.documentparser.dataholders.Document next() {
        String[] pagess;
        String pages;
        Node yearNode;
        String journalTitleAbbrev;
        Node n = this.citations.item(this.nextArticle);
        String ID = XPath.getNode("PMID", n).getTextContent();
        String title = XPath.getNode("Article/ArticleTitle", n).getTextContent();
        Node absNode = XPath.getNode("Article/Abstract/AbstractText", n);
        String abs = absNode != null ? absNode.getTextContent() : null;
        Node ISSNNode = XPath.getNode("Article/Journal/ISSN", n);
        String ISSN = ISSNNode != null ? ISSNNode.getTextContent() : null;
        Node journalNode = XPath.getNode("Article/Journal/Title", n);
        String journalTitle = journalNode != null ? journalNode.getTextContent() : null;
        Node journalAbbrevNode = XPath.getNode("Article/Journal/ISOAbbreviation", n);
        String string = journalTitleAbbrev = journalAbbrevNode != null ? journalAbbrevNode.getTextContent() : null;
        if (abs == null) {
            absNode = XPath.getNode("OtherAbstract/AbstractText", n);
            abs = absNode != null ? absNode.getTextContent() : null;
        }
        String year = (yearNode = XPath.getNode("Article/Journal/JournalIssue/PubDate/Year", n)) != null ? yearNode.getTextContent() : XPath.getNode("Article/Journal/JournalIssue/PubDate/MedlineDate", n).getTextContent().split(" ")[0];
        MyNodeList meshTermList = XPath.getNodeList("MeshHeadingList/MeshHeading", n);
        String[] meshTerms = new String[meshTermList.getLength()];
        for (int i = 0; i < meshTerms.length; ++i) {
            meshTerms[i] = XPath.getNode("DescriptorName", meshTermList.item(i)).getTextContent();
        }
        MyNodeList authorList = XPath.getNodeList("Article/AuthorList/Author", n);
        Author[] authors = new Author[authorList.getLength()];
        for (int i = 0; i < authorList.getLength(); ++i) {
            String fn = XPath.getNode("ForeName", authorList.item(i)) != null ? XPath.getNode("ForeName", authorList.item(i)).getTextContent() : null;
            String sn = XPath.getNode("LastName", authorList.item(i)) != null ? XPath.getNode("LastName", authorList.item(i)).getTextContent() : null;
            authors[i] = new Author(sn, fn, null);
        }
        String volume = XPath.getNode("Article/Journal/JournalIssue/Volume", n) != null ? XPath.getNode("Article/Journal/JournalIssue/Volume", n).getTextContent() : null;
        String issue = XPath.getNode("Article/Journal/JournalIssue/Issue", n) != null ? XPath.getNode("Article/Journal/JournalIssue/Issue", n).getTextContent() : null;
        String string2 = pages = XPath.getNode("Article/Pagination/MedlinePgn", n) != null ? XPath.getNode("Article/Pagination/MedlinePgn", n).getTextContent() : null;
        if (pages != null && (pagess = pages.split("-")).length == 2) {
            if (pagess[1].length() < pagess[0].length()) {
                pagess[1] = pagess[0].substring(0, pagess[0].length() - pagess[1].length()) + pagess[1];
            }
            pages = pagess[0] + "-" + pagess[1];
        }
        Journal journal = new Journal(ISSN, journalTitle, journalTitleAbbrev);
        ExternalID externalID = new ExternalID(ID, ExternalID.Source.MEDLINE);
        Document.Type type = Document.Type.RESEARCH;
        ++this.nextArticle;
        return new uk.ac.man.documentparser.dataholders.Document(ID, title, abs, null, null, null, year, journal, type, authors, volume, issue, pages, this.xml, externalID);
    }

    @Override
    public void remove() {
        throw new IllegalStateException("remove() is not supported");
    }

    @Override
    public void skip() {
        ++this.nextArticle;
    }
}

