/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.documentparser.input;

import java.io.File;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import martin.common.Misc;
import martin.common.xml.MyNodeList;
import martin.common.xml.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import uk.ac.man.documentparser.dataholders.Author;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.documentparser.dataholders.ExternalID;
import uk.ac.man.documentparser.dataholders.Journal;
import uk.ac.man.documentparser.input.DocumentIterator;

public class Elsevier
implements DocumentIterator {
    private boolean next = true;
    private String xml;

    public Elsevier(StringBuffer xml, String[] dtdLocations) {
        this.xml = xml.toString();
    }

    public Elsevier(File file, String[] dtdLocations) {
        System.out.println(file.getAbsolutePath());
        this.xml = Misc.loadFile(file);
    }

    @Override
    public void skip() {
        if (!this.next) {
            throw new NoSuchElementException();
        }
        this.next = false;
    }

    @Override
    public boolean hasNext() {
        return this.next;
    }

    private String get(Node root, String name) {
        return this.get(root, new String[]{name});
    }

    private String get(Node root, String[] nodes) {
        for (String name : nodes) {
            Node n = XPath.getNode(name, root);
            if (n == null) continue;
            return n.getTextContent();
        }
        return null;
    }

    @Override
    public uk.ac.man.documentparser.dataholders.Document next() {
        String raw;
        String bdy;
        if (!this.next) {
            throw new NoSuchElementException();
        }
        this.xml = this.xml.replaceAll("\t*", "");
        this.xml = this.xml.replaceAll("\n", " ");
        while (this.xml.contains("  ")) {
            this.xml = this.xml.replaceAll("  ", " ");
        }
        Document root = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            root = db.parse(new InputSource(new StringReader(this.xml)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String title = this.get((Node)root, new String[]{"doc:document/ja:article/ja:head/ce:title", "doc:document/cja:converted-article/cja:head/ce:title", "doc:document/ja:simple-article/ja:simple-head/ce:title"});
        String abs = this.get((Node)root, new String[]{"doc:document/ja:article/ja:head/ce:abstract", "doc:document/cja:converted-article/cja:head/ce:abstract", "doc:document/ja:simple-article/ja:simple-head/ce:abstract"});
        if (abs != null && abs.startsWith(" Abstract ")) {
            abs = abs.substring(11);
        }
        while (abs != null && abs.contains("  ")) {
            abs = abs.replaceAll("  ", " ");
        }
        for (bdy = this.getBody(root); bdy != null && bdy.contains("  "); bdy = bdy.replaceAll("  ", " ")) {
        }
        for (raw = this.get((Node)root, new String[]{"doc:document/dp:document-properties/dp:raw-text"}); raw != null && raw.contains("  "); raw = raw.replaceAll("  ", " ")) {
        }
        String doi = this.get((Node)root, new String[]{"doc:document/rdf:RDF/rdf:Description/prism:doi", "doc:document/cja:converted-article/cja:item-info/ce:doi"});
        String year = this.get((Node)root, "doc:document/rdf:RDF/rdf:Description/prism:coverDate");
        String pages = this.get((Node)root, "doc:document/rdf:RDF/rdf:Description/prism:pageRange");
        String volume = this.get((Node)root, "doc:document/rdf:RDF/rdf:Description/prism:volume");
        String issue = this.get((Node)root, "doc:document/rdf:RDF/rdf:Description/prism:number");
        String ISSN = this.get((Node)root, "doc:document/rdf:RDF/rdf:Description/prism:issn");
        String journalName = this.get((Node)root, "doc:document/rdf:RDF/rdf:Description/prism:publicationName");
        Author[] authors = this.getAuthors(root);
        Document.Type type = abs != null ? Document.Type.RESEARCH : Document.Type.OTHER;
        ExternalID eid = new ExternalID(doi, ExternalID.Source.ELSEVIER);
        Journal journal = new Journal(ISSN, journalName, null);
        if (doi == null) {
            return null;
        }
        uk.ac.man.documentparser.dataholders.Document d = new uk.ac.man.documentparser.dataholders.Document(doi, title, abs, bdy, raw, null, year, journal, type, authors, volume, issue, pages, this.xml, eid);
        this.next = false;
        return d;
    }

    private StringBuffer getSection(Node root) {
        StringBuffer sb = new StringBuffer();
        MyNodeList sections = XPath.getNodeList("ce:section", root);
        for (Node s : sections) {
            String title = XPath.getNode("ce:section-title", s) != null ? XPath.getNode("ce:section-title", s).getTextContent() : null;
            sb.append(title + "\n");
            sb.append(this.getSection(s));
        }
        MyNodeList paras = XPath.getNodeList("ce:para", root);
        for (Node p : paras) {
            sb.append(p.getTextContent() + "\n");
        }
        return sb;
    }

    private String getBody(Document root) {
        StringBuffer sb = new StringBuffer();
        Node bdyNode = XPath.getNode("doc:document/ja:article/ja:body/ce:sections", root);
        if (bdyNode == null) {
            bdyNode = XPath.getNode("doc:document/cja:converted-article/cja:body/ce:sections", root);
        }
        if (bdyNode == null) {
            bdyNode = XPath.getNode("doc:document/ja:simple-article/ja:body/ce:sections", root);
        }
        if (bdyNode == null) {
            return null;
        }
        return this.getSection(bdyNode).toString();
    }

    private Author[] getAuthors(Document root) {
        MyNodeList authorList = XPath.getNodeList("doc:document/ja:article/ja:head/ce:author-group/ce:author", root);
        if (authorList == null || authorList.getLength() == 0) {
            authorList = XPath.getNodeList("doc:document/cja:converted-article/cja:head/ce:author-group/ce:author", root);
        }
        if (authorList == null || authorList.getLength() == 0) {
            return null;
        }
        Author[] authors = new Author[authorList.getLength()];
        int i = 0;
        for (Node n : authorList) {
            String gn = XPath.getNode("ce:given-name", n) != null ? XPath.getNode("ce:given-name", n).getTextContent() : null;
            String sn = XPath.getNode("ce:surname", n).getTextContent();
            String add = XPath.getNode("ce:e-address", n) != null ? XPath.getNode("ce:e-address", n).getTextContent() : null;
            authors[i++] = new Author(sn, gn, add);
        }
        return authors;
    }

    @Override
    public void remove() {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public Iterator<uk.ac.man.documentparser.dataholders.Document> iterator() {
        return this;
    }
}

