/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.documentparser.input;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import uk.ac.man.documentparser.dataholders.Document;
import uk.ac.man.documentparser.input.DocumentIterator;
import uk.ac.man.documentparser.input.InputFactory;

public class Directory
implements DocumentIterator {
    private File[] contents;
    private int nextDocIndex = 0;
    private Document nextDocument;
    private String acceptedSuffix;
    private boolean recursive;
    private InputFactory factory;
    private DocumentIterator currentSubDirectory = null;
    private DocumentIterator currentFileIterator = null;

    public Directory(File dir, InputFactory factory, String acceptedSuffix, boolean recursive) {
        this.acceptedSuffix = acceptedSuffix;
        this.recursive = recursive;
        this.factory = factory;
        this.contents = dir.listFiles();
        Arrays.sort(this.contents);
        if (dir == null || !dir.isDirectory()) {
            System.err.println("You did not specify a valid directory path. This can be caused by: 1) no path was specified, or 2) the path you specified does not exist, or 3) the path you specified does not represent a directory. The program will now exit.");
            System.exit(-1);
        }
        this.fetchNext();
    }

    private void fetchNext() {
        this.nextDocument = null;
        if (this.currentSubDirectory != null) {
            this.nextDocument = (Document)this.currentSubDirectory.next();
            if (!this.currentSubDirectory.hasNext()) {
                this.currentSubDirectory = null;
            }
        } else if (this.currentFileIterator != null) {
            this.nextDocument = (Document)this.currentFileIterator.next();
            if (!this.currentFileIterator.hasNext()) {
                this.currentFileIterator = null;
            }
        } else if (this.nextDocIndex < this.contents.length) {
            File item;
            if ((item = this.contents[this.nextDocIndex++]).isDirectory()) {
                if (this.recursive) {
                    this.currentSubDirectory = new Directory(item, this.factory, this.acceptedSuffix, this.recursive);
                    if (!this.currentSubDirectory.hasNext()) {
                        this.currentSubDirectory = null;
                    }
                    this.fetchNext();
                } else {
                    this.fetchNext();
                }
            } else if (item.isFile()) {
                if (this.acceptedSuffix == null || item.getAbsolutePath().endsWith(this.acceptedSuffix)) {
                    this.currentFileIterator = this.factory.parse(item);
                    if (!this.currentFileIterator.hasNext()) {
                        this.currentFileIterator = null;
                    }
                    this.fetchNext();
                } else {
                    this.fetchNext();
                }
            }
        }
    }

    @Override
    public void skip() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.fetchNext();
    }

    @Override
    public boolean hasNext() {
        return this.nextDocument != null;
    }

    @Override
    public Document next() {
        if (this.nextDocument == null) {
            throw new NoSuchElementException("no more documents available");
        }
        Document res = this.nextDocument;
        this.fetchNext();
        return res;
    }

    @Override
    public void remove() {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public Iterator<Document> iterator() {
        return this;
    }
}

