/*
 * Decompiled with CFR 0.152.
 */
package martin.common.compthreads;

import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import martin.common.compthreads.Master;
import martin.common.compthreads.Problem;
import martin.common.compthreads.Worker;

public class ArrayBasedMaster<E>
extends Master<E>
implements Runnable {
    private Problem<E>[] problems;
    private Object[] solutions;
    private Semaphore threadsem;
    private Semaphore solutionsem = new Semaphore(0, true);

    public ArrayBasedMaster(Problem<E>[] problems, int numThreads) {
        this.problems = problems;
        this.solutions = new Object[problems.length];
        this.threadsem = new Semaphore(numThreads, true);
    }

    @Override
    public void run() {
        for (int i = 0; i < this.problems.length; ++i) {
            try {
                this.threadsem.acquire();
                Worker<E> w = new Worker<E>(this.problems[i], this, i);
                new Thread(w).start();
                continue;
            }
            catch (Exception e) {
                System.err.println(e);
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }

    public Object[] getSolutions() {
        try {
            for (int i = 0; i < this.problems.length; ++i) {
                this.solutionsem.acquire();
            }
        }
        catch (InterruptedException e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
        return this.solutions;
    }

    public ArrayList<E> getArrayListSolutions() {
        Object[] sols = this.getSolutions();
        ArrayList<Object> res = new ArrayList<Object>(sols.length);
        for (int i = 0; i < res.size(); ++i) {
            res.add(sols[i]);
        }
        return res;
    }

    @Override
    void report(E solution, int id) {
        this.solutions[id] = solution;
        if (this.getReportProgress()) {
            if (solution != null) {
                System.out.println("\tThread " + id + " finished.");
            } else {
                System.out.println("\tThread finished.");
            }
        }
        this.solutionsem.release();
        this.threadsem.release();
    }
}

