/*
 * Decompiled with CFR 0.152.
 */
package martin.common;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import martin.common.ComparableTuple;

public class Stopwatch {
    private static Map<String, Long> sums = new HashMap<String, Long>();
    private static Map<String, Integer> hits = new HashMap<String, Integer>();
    private static Semaphore totalSem = new Semaphore(1);
    private long startTime = -1L;
    private String label;

    public Stopwatch(String label) {
        this.label = label;
    }

    public static Stopwatch startNew(String label) {
        Stopwatch s = new Stopwatch(label);
        s.start();
        return s;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public void cancel() {
        this.startTime = -1L;
    }

    public long stop() {
        if (this.startTime == -1L) {
            throw new IllegalStateException("This stopwatch needs to be restarted before stop() is called a second time.");
        }
        long time = System.currentTimeMillis() - this.startTime;
        try {
            totalSem.acquire();
            if (!sums.containsKey(this.label)) {
                sums.put(this.label, time);
                hits.put(this.label, 1);
            } else {
                sums.put(this.label, sums.get(this.label) + time);
                hits.put(this.label, hits.get(this.label) + 1);
            }
            totalSem.release();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
        this.startTime = -1L;
        return time;
    }

    public static void printStats() {
        try {
            totalSem.acquire();
            Object[] sums_list = new ComparableTuple[sums.size()];
            int c = 0;
            for (String l : sums.keySet()) {
                sums_list[c++] = new ComparableTuple<Long, String>(-sums.get(l).longValue(), l);
            }
            Arrays.sort(sums_list);
            System.out.println("Label\tTime (ms)\tHits");
            for (Object t : sums_list) {
                System.out.println((String)((ComparableTuple)t).getB() + "\t" + -((Long)((ComparableTuple)t).getA()).longValue() + "\t" + hits.get(((ComparableTuple)t).getB()));
            }
            totalSem.release();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

