/*
 * Decompiled with CFR 0.152.
 */
package martin.common;

import java.io.File;
import java.util.GregorianCalendar;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import martin.common.ArgParser;
import martin.common.Misc;

public class Loggers {
    private static String millisToString(long millis) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(millis);
        String time = c.get(1) + "-" + Misc.addzeros(c.get(2), 2) + "-" + Misc.addzeros(c.get(5), 2) + " " + Misc.addzeros(c.get(11), 2) + ":" + Misc.addzeros(c.get(12), 2) + ":" + Misc.addzeros(c.get(13), 2);
        return time;
    }

    private static Handler getDefaultConsoleHandler() {
        Handler h = new Handler(){

            @Override
            public void close() throws SecurityException {
            }

            @Override
            public void flush() {
            }

            @Override
            public void publish(LogRecord record) {
                String str = this.getFormatter().format(record);
                if (record.getLevel() == Level.SEVERE || record.getLevel() == Level.WARNING) {
                    System.err.print(str);
                } else {
                    System.out.print(str);
                }
            }
        };
        h.setFormatter(Loggers.getDefaultFormatter());
        return h;
    }

    private static Formatter getDefaultFormatter() {
        return new Formatter(){

            @Override
            public String format(LogRecord arg0) {
                String message = arg0.getMessage();
                if (!(message = message.replace("%t", Loggers.millisToString(arg0.getMillis()))).endsWith("\n")) {
                    message = message + "\n";
                }
                return message;
            }
        };
    }

    private static Formatter getDefaultFileFormatter() {
        return new Formatter(){

            @Override
            public String format(LogRecord arg0) {
                String time = Loggers.millisToString(arg0.getMillis());
                String message = time + "," + arg0.getLevel() + "," + arg0.getMessage();
                if (!message.endsWith("\n")) {
                    message = message + "\n";
                }
                message = message.replace("%t: ", "");
                message = message.replace("%t", "");
                return message;
            }
        };
    }

    public static Logger getDefaultFileLogger(File file) {
        try {
            Logger logger = Logger.getAnonymousLogger();
            logger.setLevel(Level.INFO);
            logger.setUseParentHandlers(false);
            FileHandler h = new FileHandler(file.getAbsolutePath(), true);
            h.setFormatter(Loggers.getDefaultFileFormatter());
            logger.addHandler(h);
            return logger;
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public static Logger getDefaultLogger(ArgParser ap) {
        if (ap != null && ap.containsKey("fileLogger")) {
            return Loggers.getDefaultFileLogger(ap.getFile("fileLogger"));
        }
        Logger logger = Logger.getAnonymousLogger();
        Loggers.configureLogger(logger, ap);
        return logger;
    }

    public static void configureLogger(Logger logger, ArgParser ap) {
        logger.setLevel(Level.INFO);
        if (ap != null && ap.containsKey("quiet")) {
            logger.setLevel(Level.SEVERE);
        }
        if (ap != null && ap.containsKey("veryquiet")) {
            logger.setLevel(Level.OFF);
        }
        logger.setUseParentHandlers(false);
        logger.addHandler(Loggers.getDefaultConsoleHandler());
    }
}

