/*
 * Decompiled with CFR 0.152.
 */
package martin.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import martin.common.Pair;

public class ExtractAbbrev {
    HashMap mTestDefinitions = new HashMap();
    HashMap mStats = new HashMap();
    int truePositives = 0;
    int falsePositives = 0;
    int falseNegatives = 0;
    int trueNegatives = 0;
    char delimiter = (char)9;
    boolean testMode = false;

    private boolean isValidShortForm(String str) {
        return this.hasLetter(str) && (Character.isLetterOrDigit(str.charAt(0)) || str.charAt(0) == '(');
    }

    private boolean hasLetter(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isLetter(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private boolean hasCapital(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private void loadTrueDefinitions(String inFile) {
        String str = "";
        HashMap definitions = this.mTestDefinitions;
        try {
            BufferedReader fin = new BufferedReader(new FileReader(inFile));
            while ((str = fin.readLine()) != null) {
                int j = str.indexOf(this.delimiter);
                String abbrString = str.substring(0, j).trim();
                String defnString = str.substring(j, str.length()).trim();
                Vector<String> entry = (Vector<String>)definitions.get(abbrString);
                if (entry == null) {
                    entry = new Vector<String>();
                }
                entry.add(defnString);
                definitions.put(abbrString, entry);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(str);
        }
    }

    private boolean isTrueDefinition(String shortForm, String longForm) {
        Vector entry = (Vector)this.mTestDefinitions.get(shortForm);
        if (entry == null) {
            return false;
        }
        Iterator itr = entry.iterator();
        while (itr.hasNext()) {
            if (!itr.next().toString().equalsIgnoreCase(longForm)) continue;
            return true;
        }
        return false;
    }

    public Map<String, String> extractAbbrPairs(File inFile) {
        String longForm = "";
        String shortForm = "";
        String currSentence = "";
        int closeParenIndex = -1;
        int tmpIndex = -1;
        boolean newParagraph = true;
        HashMap<String, String> abbrevs = new HashMap<String, String>();
        try {
            String str;
            BufferedReader fin = new BufferedReader(new FileReader(inFile));
            block2: while ((str = fin.readLine()) != null) {
                if (str.length() == 0 || newParagraph && !Character.isUpperCase(str.charAt(0))) {
                    currSentence = "";
                    newParagraph = true;
                    continue;
                }
                newParagraph = false;
                str = str + " ";
                currSentence = currSentence + str;
                int openParenIndex = currSentence.indexOf(" (");
                do {
                    if (openParenIndex > -1) {
                        ++openParenIndex;
                    }
                    int sentenceEnd = Math.max(currSentence.lastIndexOf(". "), currSentence.lastIndexOf(", "));
                    if (openParenIndex != -1 || sentenceEnd != -1) {
                        if (openParenIndex == -1) {
                            currSentence = currSentence.substring(sentenceEnd + 2);
                        } else {
                            closeParenIndex = currSentence.indexOf(41, openParenIndex);
                            if (closeParenIndex > -1) {
                                sentenceEnd = Math.max(currSentence.lastIndexOf(". ", openParenIndex), currSentence.lastIndexOf(", ", openParenIndex));
                                if (sentenceEnd == -1) {
                                    sentenceEnd = -2;
                                }
                                longForm = currSentence.substring(sentenceEnd + 2, openParenIndex);
                                shortForm = currSentence.substring(openParenIndex + 1, closeParenIndex);
                            }
                        }
                    }
                    if (shortForm.length() > 0 || longForm.length() > 0) {
                        if (shortForm.length() > 1 && longForm.length() > 1) {
                            Pair<String> p;
                            StringTokenizer shortTokenizer;
                            int newCloseParenIndex;
                            if (shortForm.indexOf(40) > -1 && (newCloseParenIndex = currSentence.indexOf(41, closeParenIndex + 1)) > -1) {
                                shortForm = currSentence.substring(openParenIndex + 1, newCloseParenIndex);
                                closeParenIndex = newCloseParenIndex;
                            }
                            if ((tmpIndex = shortForm.indexOf(", ")) > -1) {
                                shortForm = shortForm.substring(0, tmpIndex);
                            }
                            if ((tmpIndex = shortForm.indexOf("; ")) > -1) {
                                shortForm = shortForm.substring(0, tmpIndex);
                            }
                            if ((shortTokenizer = new StringTokenizer(shortForm)).countTokens() > 2 || shortForm.length() > longForm.length()) {
                                tmpIndex = currSentence.lastIndexOf(" ", openParenIndex - 2);
                                String tmpStr = currSentence.substring(tmpIndex + 1, openParenIndex - 1);
                                longForm = shortForm;
                                shortForm = tmpStr;
                                if (!this.hasCapital(shortForm)) {
                                    shortForm = "";
                                }
                            }
                            if (this.isValidShortForm(shortForm) && (p = this.extractAbbrPair(shortForm.trim(), longForm.trim())) != null) {
                                abbrevs.put(p.getX(), p.getY());
                            }
                        }
                        currSentence = currSentence.substring(closeParenIndex + 1);
                    } else if (openParenIndex > -1) {
                        if (currSentence.length() - openParenIndex <= 200) continue block2;
                        currSentence = currSentence.substring(openParenIndex + 1);
                        continue block2;
                    }
                    shortForm = "";
                    longForm = "";
                } while ((openParenIndex = currSentence.indexOf(" (")) > -1);
            }
            fin.close();
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            System.out.println(currSentence);
            System.out.println(tmpIndex);
        }
        return abbrevs;
    }

    private String findBestLongForm(String shortForm, String longForm) {
        int lIndex = longForm.length() - 1;
        for (int sIndex = shortForm.length() - 1; sIndex >= 0; --sIndex) {
            char currChar = Character.toLowerCase(shortForm.charAt(sIndex));
            if (!Character.isLetterOrDigit(currChar)) continue;
            while (lIndex >= 0 && Character.toLowerCase(longForm.charAt(lIndex)) != currChar || sIndex == 0 && lIndex > 0 && Character.isLetterOrDigit(longForm.charAt(lIndex - 1))) {
                --lIndex;
            }
            if (lIndex < 0) {
                return null;
            }
            --lIndex;
        }
        lIndex = longForm.lastIndexOf(" ", lIndex) + 1;
        return longForm.substring(lIndex);
    }

    private Pair<String> extractAbbrPair(String shortForm, String longForm) {
        if (shortForm.length() == 1) {
            return null;
        }
        String bestLongForm = this.findBestLongForm(shortForm, longForm);
        if (bestLongForm == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(bestLongForm, " \t\n\r\f-");
        int longFormSize = tokenizer.countTokens();
        int shortFormSize = shortForm.length();
        for (int i = shortFormSize - 1; i >= 0; --i) {
            if (Character.isLetterOrDigit(shortForm.charAt(i))) continue;
            --shortFormSize;
        }
        if (bestLongForm.length() < shortForm.length() || bestLongForm.indexOf(shortForm + " ") > -1 || bestLongForm.endsWith(shortForm) || longFormSize > shortFormSize * 2 || longFormSize > shortFormSize + 5 || shortFormSize > 10) {
            return null;
        }
        if (this.testMode) {
            if (this.isTrueDefinition(shortForm, bestLongForm)) {
                System.out.println(shortForm + this.delimiter + bestLongForm + this.delimiter + "TP");
                ++this.truePositives;
            } else {
                ++this.falsePositives;
                System.out.println(shortForm + this.delimiter + bestLongForm + this.delimiter + "FP");
            }
        } else {
            return new Pair<String>(shortForm, bestLongForm);
        }
        return null;
    }

    private static void usage() {
        System.err.println("Usage: ExtractAbbrev [-options] <filename>");
        System.err.println("       <filename> contains text from which abbreviations are extracted");
        System.err.println("       -testlist <file> = list of true abbreviation definition pairs");
        System.err.println("       -usage or -help = this message");
        System.exit(1);
    }

    public static void main(String[] args) {
        ExtractAbbrev extractAbbrev = new ExtractAbbrev();
        String filename = null;
        String testList = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-testlist")) {
                if (i == args.length - 1) {
                    ExtractAbbrev.usage();
                }
                testList = args[++i];
                extractAbbrev.testMode = true;
                continue;
            }
            if (args[i].equals("-usage")) {
                ExtractAbbrev.usage();
                continue;
            }
            if (args[i].equals("-help")) {
                ExtractAbbrev.usage();
                continue;
            }
            filename = args[i];
            if (i == args.length - 1) continue;
            ExtractAbbrev.usage();
        }
        if (filename == null) {
            ExtractAbbrev.usage();
        }
        if (extractAbbrev.testMode) {
            extractAbbrev.loadTrueDefinitions(testList);
        }
        extractAbbrev.extractAbbrPairs(new File(filename));
        if (extractAbbrev.testMode) {
            System.out.println("TP: " + extractAbbrev.truePositives + " FP: " + extractAbbrev.falsePositives + " FN: " + extractAbbrev.falseNegatives + " TN: " + extractAbbrev.trueNegatives);
        }
    }
}

