/*
 * Decompiled with CFR 0.152.
 */
package martin.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import martin.common.Properties;

public class ArgParser {
    private static ArgParser parser;
    private String[] nonSwitched;
    private HashSet<String> enabledSwitches = new HashSet();
    private HashMap<String, String[]> followers = new HashMap();

    public static ArgParser getParser(String[] args) {
        if (parser == null) {
            parser = new ArgParser(args);
        }
        return parser;
    }

    public static ArgParser getParser() {
        return parser;
    }

    public void addAlternate(String a, String b) {
        if (this.enabledSwitches.contains(a)) {
            this.enabledSwitches.add(b);
            if (this.followers.containsKey(a)) {
                this.followers.put(b, this.followers.get(a));
            }
        } else if (this.enabledSwitches.contains(b)) {
            this.enabledSwitches.add(a);
            if (this.followers.containsKey(b)) {
                this.followers.put(a, this.followers.get(b));
            }
        }
    }

    public void addProperties(String name) {
        this.addProperties(Properties.load(name));
    }

    private void addProperties(Properties p) {
        HashMap<String, String> variables = new HashMap<String, String>();
        for (Object ko : p.keySet()) {
            String k = (String)ko;
            String v = p.getProperty(k);
            if (!k.startsWith("$")) continue;
            variables.put(k, v);
        }
        Pattern pattern = Pattern.compile("\\$[a-zA-Z]+");
        for (Object ko : p.keySet()) {
            String k = (String)ko;
            if (this.enabledSwitches.contains(k)) continue;
            String v = p.getProperty(k);
            this.enabledSwitches.add(k);
            String[] fs = v.split(";");
            for (int i = 0; i < fs.length; ++i) {
                Matcher m = pattern.matcher(fs[i]);
                while (m.find()) {
                    String var = fs[i].substring(m.start(), m.end());
                    if (variables.containsKey(var)) {
                        fs[i] = fs[i].substring(0, m.start()) + (String)variables.get(var) + fs[i].substring(m.end());
                        m = pattern.matcher(fs[i]);
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized variable: '" + var + "'");
                }
            }
            this.followers.put(k, fs);
        }
    }

    public ArgParser(String[] args) {
        ArrayList nonSwitched = new ArrayList();
        for (int i = 0; i < args.length; ++i) {
            ArrayList<String> followers;
            String switch_;
            String arg = args[i];
            if (arg.startsWith("--")) {
                if (arg.length() > 2) {
                    switch_ = arg.substring(2);
                    this.enabledSwitches.add(switch_);
                    followers = new ArrayList<String>();
                    while (i + 1 < args.length && (!args[i + 1].startsWith("-") || Character.isDigit(args[i + 1].charAt(1)))) {
                        followers.add(args[++i]);
                    }
                    if (followers.size() <= 0) continue;
                    this.followers.put(switch_, followers.toArray(new String[0]));
                    nonSwitched.addAll(followers);
                    continue;
                }
                System.err.println("Invalid argument: " + arg);
                System.exit(-1);
                continue;
            }
            if (arg.startsWith("-") && !Character.isDigit(arg.charAt(1))) {
                if (arg.length() > 1) {
                    if (arg.length() > 2) {
                        for (int j = 1; j < arg.length(); ++j) {
                            this.enabledSwitches.add("" + arg.charAt(j));
                        }
                        continue;
                    }
                    switch_ = arg.substring(1);
                    this.enabledSwitches.add(switch_);
                    followers = new ArrayList();
                    while (i + 1 < args.length && (!args[i + 1].startsWith("-") || Character.isDigit(args[i + 1].charAt(1)))) {
                        followers.add(args[++i]);
                    }
                    if (followers.size() <= 0) continue;
                    this.followers.put(switch_, followers.toArray(new String[0]));
                    nonSwitched.addAll(followers);
                    continue;
                }
                System.err.println("Invalid argument: " + arg);
                System.exit(-1);
                continue;
            }
            nonSwitched.add(arg);
        }
        this.nonSwitched = nonSwitched.toArray(new String[0]);
        if (this.containsKey("properties")) {
            for (String s : this.gets("properties")) {
                this.addProperties(Properties.load(s));
            }
        }
    }

    public void printContents() {
        System.out.println("\nNonSwitched:");
        for (String s : this.nonSwitched) {
            System.out.println("\t" + s);
        }
        System.out.println("\nEnabled switches:");
        for (String s : this.enabledSwitches) {
            System.out.println("\t" + s);
        }
        System.out.println("\nFollowers:");
        for (String k : this.followers.keySet()) {
            System.out.println("\t" + k);
            for (String s : this.followers.get(k)) {
                System.out.println("\t\t" + s);
            }
        }
    }

    public boolean containsKey(String key) {
        return this.enabledSwitches.contains(key);
    }

    public double[] getDoubles(String key) {
        if (!this.followers.containsKey(key)) {
            return new double[0];
        }
        String[] followers = this.gets(key);
        double[] retres = new double[followers.length];
        for (int i = 0; i < retres.length; ++i) {
            retres[i] = Double.parseDouble(followers[i]);
        }
        return retres;
    }

    public boolean[] getBooleans(String key) {
        if (!this.followers.containsKey(key)) {
            return new boolean[0];
        }
        String[] followers = this.gets(key);
        boolean[] retres = new boolean[followers.length];
        for (int i = 0; i < retres.length; ++i) {
            retres[i] = Boolean.parseBoolean(followers[i]);
        }
        return retres;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Boolean b = this.getBoolean(key);
        if (b == null) {
            return defaultValue;
        }
        return b;
    }

    public Boolean getBoolean(String key) {
        if (!this.followers.containsKey(key) || this.followers.get(key).length != 1) {
            return null;
        }
        return Boolean.parseBoolean(this.get(key));
    }

    public int[] getInts(String key) {
        if (!this.followers.containsKey(key)) {
            return new int[0];
        }
        String[] followers = this.gets(key);
        int[] retres = new int[followers.length];
        for (int i = 0; i < retres.length; ++i) {
            retres[i] = Integer.parseInt(followers[i]);
        }
        return retres;
    }

    public String[] gets(String key) {
        if (this.followers.containsKey(key)) {
            return this.followers.get(key);
        }
        return new String[0];
    }

    public String get(String key) {
        if (this.followers.containsKey(key) && this.followers.get(key).length == 1) {
            return this.followers.get(key)[0];
        }
        return null;
    }

    public String get(String key, String defaultValue) {
        if (this.followers.containsKey(key) && this.followers.get(key).length == 1) {
            return this.followers.get(key)[0];
        }
        return defaultValue;
    }

    public Integer getInt(String key) {
        if (!this.followers.containsKey(key) || this.followers.get(key).length != 1) {
            return null;
        }
        return Integer.parseInt(this.get(key));
    }

    public int getInt(String key, int defaultValue) {
        Integer x = this.getInt(key);
        if (x == null) {
            return defaultValue;
        }
        return x;
    }

    public Double getDouble(String key) {
        if (!this.followers.containsKey(key) || this.followers.get(key).length != 1) {
            return null;
        }
        return Double.parseDouble(this.get(key));
    }

    public double getDouble(String key, double defaultValue) {
        Double d = this.getDouble(key);
        if (d == null) {
            return defaultValue;
        }
        return d;
    }

    public File[] getFiles(String key) {
        if (!this.followers.containsKey(key)) {
            return new File[0];
        }
        String[] followers = this.gets(key);
        File[] retres = new File[followers.length];
        for (int i = 0; i < retres.length; ++i) {
            retres[i] = new File(followers[i]);
        }
        return retres;
    }

    public File getFile(String key) {
        if (!this.containsKey(key) || this.gets(key).length == 0) {
            return null;
        }
        return new File(this.get(key));
    }

    public File getFile(String key, File defaultValue) {
        File f = this.getFile(key);
        if (f != null) {
            return f;
        }
        return defaultValue;
    }

    public String getRequired(String string) {
        String res = this.get(string);
        if (res == null) {
            throw new IllegalStateException("When running this software, you need to specify exactly one argument for the switch --" + string + ".");
        }
        return res;
    }

    public InputStream getInputStream(String key) {
        String v = this.get(key);
        if (v == null) {
            return null;
        }
        if (v.startsWith("internal:")) {
            InputStream stream = this.getClass().getResourceAsStream(v.substring(9));
            if (this.hasGzipEnding(v) && stream != null) {
                try {
                    stream = new GZIPInputStream(stream);
                }
                catch (IOException e) {
                    System.out.println("Could not open file " + v + " as a gzip file although it ends on .gzip or .gz");
                    System.exit(0);
                }
            }
            if (stream == null) {
                System.out.println("Could not find the internal resource " + v);
                System.exit(0);
            }
            return stream;
        }
        try {
            InputStream stream = new FileInputStream(new File(v));
            if (this.hasGzipEnding(v) && stream != null) {
                stream = new GZIPInputStream(stream);
            }
            return stream;
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not find the file " + v);
            System.exit(0);
        }
        catch (IOException e) {
            System.out.println("Could not open file " + v + " as a gzip file although it ends on .gzip or .gz");
            System.exit(0);
        }
        return null;
    }

    public InputStream[] getInputStreams(String key) {
        String[] v = this.gets(key);
        if (v == null) {
            return null;
        }
        InputStream[] res = new InputStream[v.length];
        for (int i = 0; i < res.length; ++i) {
            if (v[i].startsWith("internal:")) {
                InputStream stream = this.getClass().getResourceAsStream(v[i].substring(9));
                if (this.hasGzipEnding(v[i]) && stream != null) {
                    try {
                        stream = new GZIPInputStream(stream);
                    }
                    catch (IOException e) {
                        System.out.println("Could not open file " + v[i] + " as a gzip file although it ends on .gzip or .gz");
                        System.exit(0);
                    }
                }
                if (stream == null) {
                    System.out.println("Could not find the internal resource " + v[i]);
                    System.exit(0);
                }
                res[i] = stream;
                continue;
            }
            try {
                res[i] = new FileInputStream(new File(v[i]));
                if (!this.hasGzipEnding(v[i]) || res[i] == null) continue;
                res[i] = new GZIPInputStream(res[i]);
                continue;
            }
            catch (FileNotFoundException e) {
                System.out.println("Could not find the file " + v[i]);
                System.exit(0);
                continue;
            }
            catch (IOException e) {
                System.out.println("Could not open file " + v[i] + " as a gzip file although it ends on .gzip or .gz");
                System.exit(0);
            }
        }
        return res;
    }

    public InputStream getInputStream(String key, InputStream defaultStream) {
        InputStream stream = this.getInputStream(key);
        if (stream != null) {
            return stream;
        }
        return defaultStream;
    }

    private boolean hasGzipEnding(String str) {
        return str.endsWith(".gz") || str.endsWith(".gzip");
    }
}

