/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.CustomRunAutomaton;
import java.util.ArrayList;
import java.util.regex.MatchResult;

public class CustomAutomatonMatcher
implements MatchResult {
    private final CustomRunAutomaton automaton;
    private final CharSequence chars;
    private int matchStart = -1;
    private int matchEnd = -1;
    private ArrayList<String> matchIDs;

    CustomAutomatonMatcher(CharSequence chars, CustomRunAutomaton automaton) {
        this.chars = chars;
        this.automaton = automaton;
    }

    private ArrayList<String> getIDs(int state) {
        ArrayList<String> res = new ArrayList<String>();
        ArrayList<Character> validCharacters = this.automaton.getValidChars(state);
        for (char c : validCharacters) {
            int step = this.automaton.step(state, c);
            if (step == -1 || step == state) continue;
            if (this.automaton.accept[step]) {
                res.add("" + c);
            }
            ArrayList<String> list = this.getIDs(step);
            for (int i = 0; i < list.size(); ++i) {
                res.add("" + c + list.get(i));
            }
        }
        return res;
    }

    public boolean findWithDelimitedID(char delimiter) {
        int new_state;
        int i;
        int p;
        if (this.getMatchStart() == -2) {
            return false;
        }
        int begin = this.getMatchStart() == -1 ? 0 : this.getMatchStart();
        if (this.automaton.isAcceptDelimited(this.automaton.getInitialState(), delimiter)) {
            throw new IllegalStateException("Automaton matched the empty string");
        }
        int match_start = -1;
        int match_end = -1;
        ArrayList<String> match_ids = null;
        int l = this.getChars().length();
        if (this.getMatchEnd() != -1) {
            p = this.automaton.getInitialState();
            for (i = begin; i < l && (new_state = this.automaton.step(p, this.getChars().charAt(i))) != -1; ++i) {
                if (this.automaton.isAcceptDelimited(new_state, delimiter) && i + 1 > this.getMatchEnd()) {
                    if (match_start == -1) {
                        match_start = begin;
                    }
                    match_end = i;
                    match_ids = this.getIDs(this.automaton.step(new_state, delimiter));
                    this.setMatch(match_start, match_end + 1, match_ids);
                    return true;
                }
                p = new_state;
            }
            ++begin;
        }
        while (begin < l) {
            p = this.automaton.getInitialState();
            for (i = begin; i < l && (new_state = this.automaton.step(p, this.getChars().charAt(i))) != -1; ++i) {
                if (this.automaton.isAcceptDelimited(new_state, delimiter)) {
                    if (match_start == -1) {
                        match_start = begin;
                    }
                    match_end = i;
                    match_ids = this.getIDs(this.automaton.step(new_state, delimiter));
                    this.setMatch(match_start, match_end + 1, match_ids);
                    return true;
                }
                p = new_state;
            }
            ++begin;
        }
        if (match_start != -1) {
            this.setMatch(match_start, match_end, match_ids);
            return true;
        }
        this.setMatch(-2, -2, null);
        return false;
    }

    public boolean find() {
        int match_end;
        int match_start;
        if (this.getMatchStart() == -2) {
            return false;
        }
        int begin = this.getMatchStart() == -1 ? 0 : this.getMatchEnd();
        if (this.automaton.isAccept(this.automaton.getInitialState())) {
            match_start = begin;
            match_end = begin;
        } else {
            match_start = -1;
            match_end = -1;
        }
        int l = this.getChars().length();
        while (begin < l) {
            int new_state;
            int p = this.automaton.getInitialState();
            for (int i = begin; i < l && (new_state = this.automaton.step(p, this.getChars().charAt(i))) != -1; ++i) {
                if (this.automaton.isAccept(new_state)) {
                    if (match_start == -1) {
                        match_start = begin;
                    }
                    match_end = i;
                }
                p = new_state;
            }
            if (match_start != -1) {
                this.setMatch(match_start, match_end + 1);
                return true;
            }
            ++begin;
        }
        if (match_start != -1) {
            this.setMatch(match_start, match_end + 1);
            return true;
        }
        this.setMatch(-2, -2);
        return false;
    }

    private void setMatch(int matchStart, int matchEnd, ArrayList<String> matchIDs) throws IllegalArgumentException {
        if (matchStart > matchEnd) {
            throw new IllegalArgumentException("Start must be less than or equal to end: " + matchStart + ", " + matchEnd);
        }
        if (matchIDs != null && matchIDs.size() == 0) {
            throw new IllegalStateException("matchIDs.size() == 0");
        }
        this.matchStart = matchStart;
        this.matchEnd = matchEnd;
        this.matchIDs = matchIDs;
    }

    private void setMatch(int matchStart, int matchEnd) throws IllegalArgumentException {
        if (matchStart > matchEnd) {
            throw new IllegalArgumentException("Start must be less than or equal to end: " + matchStart + ", " + matchEnd);
        }
        this.matchStart = matchStart;
        this.matchEnd = matchEnd;
    }

    private int getMatchStart() {
        return this.matchStart;
    }

    private int getMatchEnd() {
        return this.matchEnd;
    }

    private CharSequence getChars() {
        return this.chars;
    }

    @Override
    public int end() throws IllegalStateException {
        this.matchGood();
        return this.matchEnd;
    }

    @Override
    public int end(int group) throws IndexOutOfBoundsException, IllegalStateException {
        CustomAutomatonMatcher.onlyZero(group);
        return this.end();
    }

    @Override
    public String group() throws IllegalStateException {
        this.matchGood();
        return this.chars.subSequence(this.matchStart, this.matchEnd).toString();
    }

    @Override
    public String group(int group) throws IndexOutOfBoundsException, IllegalStateException {
        CustomAutomatonMatcher.onlyZero(group);
        return this.group();
    }

    @Override
    public int groupCount() {
        return 0;
    }

    @Override
    public int start() throws IllegalStateException {
        this.matchGood();
        return this.matchStart;
    }

    @Override
    public int start(int group) throws IndexOutOfBoundsException, IllegalStateException {
        CustomAutomatonMatcher.onlyZero(group);
        return this.start();
    }

    private static void onlyZero(int group) throws IndexOutOfBoundsException {
        if (group != 0) {
            throw new IndexOutOfBoundsException("The only group supported is 0.");
        }
    }

    private void matchGood() throws IllegalStateException {
        if (this.matchStart < 0 || this.matchEnd < 0) {
            throw new IllegalStateException("There was no available match.");
        }
    }

    public ArrayList<String> getMatchIDs() {
        this.matchGood();
        return this.matchIDs;
    }
}

