/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.test;

import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.Representation;

public class TestUtilities {
    public static final File GRAPH_DB_DIR;
    private static final Random random;
    private static final String[] symbols;

    public static void deleteEverythingInDB(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            ResourceIterable nodes = tx.getAllNodes();
            for (Node n : nodes) {
                for (Relationship r : n.getRelationships()) {
                    r.delete();
                }
                n.delete();
            }
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            ResourceIterator nodeIt = tx.getAllNodes().iterator();
            Assert.assertFalse((boolean)nodeIt.hasNext());
            for (ConstraintDefinition cd : tx.schema().getConstraints()) {
                cd.drop();
            }
            for (IndexDefinition id : tx.schema().getIndexes()) {
                id.drop();
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    public static <T extends Representation> List<T> getListFromListRepresentation(ListRepresentation listrep) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field responseContent = ListRepresentation.class.getDeclaredField("content");
        responseContent.setAccessible(true);
        List content = (List)responseContent.get(listrep);
        return content;
    }

    public static <T extends Representation> Iterable<T> getIterableFromListRepresentation(ListRepresentation listrep) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field responseContent = ListRepresentation.class.getDeclaredField("content");
        responseContent.setAccessible(true);
        Iterable content = (Iterable)responseContent.get(listrep);
        return content;
    }

    public static DatabaseManagementService getGraphDBMS() {
        DatabaseManagementService managementService = new DatabaseManagementServiceBuilder(GRAPH_DB_DIR).build();
        return managementService;
    }

    static {
        int idx;
        GRAPH_DB_DIR = new File("src/test/resources/graph.db");
        random = new Random();
        symbols = new String[36];
        for (idx = 0; idx < 10; ++idx) {
            TestUtilities.symbols[idx] = String.valueOf((char)(48 + idx));
        }
        for (idx = 10; idx < 36; ++idx) {
            TestUtilities.symbols[idx] = String.valueOf((char)(97 + idx - 10));
        }
    }
}

